/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.common.DDEditorNavigator;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.j2ee.ddloaders.catalog.EnterpriseCatalog;
import org.netbeans.modules.j2ee.ddloaders.ejb.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.ejb.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.ejb.EjbJarDataLoader;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationshipsMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.SessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EjbJarMultiViewDataObject
extends DDMultiViewDataObject
implements DDChangeListener,
DDEditorNavigator,
FileChangeListener,
ChangeListener {
    private EjbJarProxy ejbJar;
    private final List<FileObject> srcRoots = new ArrayList<FileObject>();
    private PropertyChangeListener ejbJarChangeListener;
    private Map entityHelperMap = new HashMap();
    private Map sessionHelperMap = new HashMap();
    private static final long serialVersionUID = 8857563089355069362L;
    private static final Logger LOGGER = Logger.getLogger(EjbJarMultiViewDataObject.class.getName());
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private static final int HOME = 10;
    private static final int REMOTE = 20;
    private static final int LOCAL_HOME = 30;
    private static final int LOCAL = 40;
    private static final String OVERVIEW = "Overview";
    private static final String CMP_RELATIONSHIPS = "CmpRelationships";
    private static final RequestProcessor rp = new RequestProcessor(EjbJarMultiViewDataObject.class);
    private final RequestProcessor.Task refreshSourcesTask = rp.create(new Runnable(){

        @Override
        public void run() {
            EjbJarMultiViewDataObject.this.refreshSourceFolders();
        }
    });
    private RequestProcessor.Task elementTask;
    private List deletedEjbNames;
    private List newFileNames;

    public EjbJarMultiViewDataObject(FileObject pf, EjbJarDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        CookieSet set = this.getCookieSet();
        set.add((Node.Cookie)validateCookie);
        ViewCookieFactory viewCookieFactory = new ViewCookieFactory();
        set.add(ViewCookie.class, (CookieSet.Factory)viewCookieFactory);
        Project project = this.getProject();
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
        }
        this.refreshSourceFolders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSourceFolders() {
        SourceGroup[] groups;
        Project project = this.getProject();
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            groups = sources.getSourceGroups("java");
        } else {
            groups = null;
        }
        if (groups != null) {
            List<FileObject> list = this.srcRoots;
            synchronized (list) {
                this.srcRoots.clear();
                for (int i = 0; i < groups.length; ++i) {
                    org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)groups[i].getRootFolder());
                    if (ejbModule == null || ejbModule.getDeploymentDescriptor() == null) continue;
                    try {
                        FileObject fo = groups[i].getRootFolder();
                        this.srcRoots.add(fo);
                        FileSystem fs = fo.getFileSystem();
                        fs.removeFileChangeListener((FileChangeListener)this);
                        fs.addFileChangeListener((FileChangeListener)this);
                        continue;
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
    }

    public FileObject getProjectDirectory() {
        Project project = this.getProject();
        return project == null ? null : project.getProjectDirectory();
    }

    public SourceGroup[] getSourceGroups() {
        Project project = this.getProject();
        if (project != null) {
            return ProjectUtils.getSources((Project)project).getSourceGroups("java");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPackageName(FileObject clazz) {
        List<FileObject> list = this.srcRoots;
        synchronized (list) {
            for (FileObject fo : this.srcRoots) {
                String rp = FileUtil.getRelativePath((FileObject)fo, (FileObject)clazz);
                if (rp == null) continue;
                if (clazz.getExt().length() > 0) {
                    rp = rp.substring(0, rp.length() - clazz.getExt().length() - 1);
                }
                return rp.replace('/', '.');
            }
        }
        return null;
    }

    public EjbJar getEjbJar() {
        if (this.ejbJar == null) {
            try {
                this.parseDocument();
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        return this.ejbJar;
    }

    protected Node createNodeDelegate() {
        return new EjbJarMultiViewDataNode(this);
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject dataObject = super.handleCopy(f);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    @Override
    public void deploymentChange(DDChangeEvent evt) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elementCreated(String elementName) {
        EjbJarMultiViewDataObject ejbJarMultiViewDataObject = this;
        synchronized (ejbJarMultiViewDataObject) {
            if (this.newFileNames == null) {
                this.newFileNames = new ArrayList();
            }
            this.newFileNames.add(elementName);
        }
        if (this.elementTask == null) {
            this.elementTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EjbJarMultiViewDataObject ejbJarMultiViewDataObject;
                    if (EjbJarMultiViewDataObject.this.deletedEjbNames != null) {
                        for (int i = 0; i < EjbJarMultiViewDataObject.this.deletedEjbNames.size(); ++i) {
                            String deletedServletName;
                            String deletedName = deletedServletName = (String)EjbJarMultiViewDataObject.this.deletedEjbNames.get(i);
                            int index = deletedServletName.lastIndexOf(".");
                            if (index > 0) {
                                deletedName = deletedServletName.substring(index + 1);
                            }
                            boolean found = false;
                            for (int j = 0; j < EjbJarMultiViewDataObject.this.newFileNames.size(); ++j) {
                                String newFileName;
                                String newName = newFileName = (String)EjbJarMultiViewDataObject.this.newFileNames.get(j);
                                int ind = newFileName.lastIndexOf(".");
                                if (ind > 0) {
                                    newName = newFileName.substring(ind + 1);
                                }
                                if (!deletedName.equals(newName)) continue;
                                found = true;
                                DDChangeEvent ddEvent = new DDChangeEvent(EjbJarMultiViewDataObject.this, (DataObject)EjbJarMultiViewDataObject.this, deletedServletName, newFileName, 2);
                                EjbJarMultiViewDataObject.this.deploymentChange(ddEvent);
                                EjbJarMultiViewDataObject ejbJarMultiViewDataObject2 = EjbJarMultiViewDataObject.this;
                                synchronized (ejbJarMultiViewDataObject2) {
                                    EjbJarMultiViewDataObject.this.newFileNames.remove(newFileName);
                                    break;
                                }
                            }
                            if (found) continue;
                            DDChangeEvent ddEvent = new DDChangeEvent(EjbJarMultiViewDataObject.this, (DataObject)EjbJarMultiViewDataObject.this, null, deletedServletName, 3);
                            EjbJarMultiViewDataObject.this.deploymentChange(ddEvent);
                        }
                        ejbJarMultiViewDataObject = EjbJarMultiViewDataObject.this;
                        synchronized (ejbJarMultiViewDataObject) {
                            EjbJarMultiViewDataObject.this.deletedEjbNames = null;
                        }
                    }
                    ejbJarMultiViewDataObject = EjbJarMultiViewDataObject.this;
                    synchronized (ejbJarMultiViewDataObject) {
                        EjbJarMultiViewDataObject.this.newFileNames = null;
                    }
                }
            }, 1500, 1);
        } else {
            this.elementTask.schedule(1500);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fo = fileRenameEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null) {
            int index = resourceName.lastIndexOf(".");
            String oldName = fileRenameEvent.getName();
            String oldResourceName = (index >= 0 ? resourceName.substring(0, index + 1) : "") + oldName;
            EjbJar ejbJar = this.getEjbJar();
            if (ejbJar.getStatus() == 0) {
                this.fireEvent(oldResourceName, resourceName, 2);
            }
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        FileObject fo = fileEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null) {
            if (this.newFileNames == null) {
                this.fireEvent(null, resourceName, 3);
            } else {
                Ejb[] ejbs = this.nullSafeGetEjbs();
                for (int i = 0; i < ejbs.length; ++i) {
                    if (!resourceName.equals(ejbs[i].getEjbClass())) continue;
                    EjbJarMultiViewDataObject ejbJarMultiViewDataObject = this;
                    synchronized (ejbJarMultiViewDataObject) {
                        if (this.deletedEjbNames == null) {
                            this.deletedEjbNames = new ArrayList();
                        }
                        this.deletedEjbNames.add(resourceName);
                        break;
                    }
                }
            }
        }
    }

    private Ejb[] nullSafeGetEjbs() {
        EjbJar ejbJar = this.getEjbJar();
        if (ejbJar == null) {
            return new Ejb[0];
        }
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return new Ejb[0];
        }
        Ejb[] result = enterpriseBeans.getEjbs();
        return result != null ? result : new Ejb[]{};
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fo = fileEvent.getFile();
        String resourceName = this.getPackageName(fo);
        if (resourceName != null) {
            this.elementCreated(resourceName);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshSourcesTask.schedule(100);
    }

    @Override
    protected void parseDocument() throws IOException {
        DDProvider ddProvider = DDProvider.getDefault();
        if (this.ejbJar == null || this.ejbJar.getOriginal() == null) {
            try {
                EjbJarProxy newEjbJar = (EjbJarProxy)ddProvider.getDDRoot(this.getPrimaryFile());
                if (newEjbJar == null) {
                    LOGGER.log(Level.INFO, "Could not resolve EjbJar for " + this.getPrimaryFile().getPath() + "");
                    newEjbJar = new EjbJarProxy(null, null);
                }
                this.setEjbJar(newEjbJar);
            }
            catch (IOException e) {
                if (this.ejbJar == null) {
                    this.setEjbJar(new EjbJarProxy(null, null));
                }
            }
        } else {
            DDUtils.merge((EjbJarProxy)this.ejbJar, (Reader)this.createReader());
        }
        this.validateDocument();
    }

    @Override
    protected void validateDocument() throws IOException {
        block3: {
            try {
                ParseUtils.parseDD((InputSource)new InputSource(this.createInputStream()), (EntityResolver)new EnterpriseCatalog());
                this.setSaxError(null);
            }
            catch (SAXException saxe) {
                this.setSaxError(saxe);
                this.ejbJar.setStatus(2);
                if (saxe instanceof SAXParseException) {
                    this.ejbJar.setError((SAXParseException)saxe);
                }
                if (!(saxe.getException() instanceof SAXParseException)) break block3;
                this.ejbJar.setError((SAXParseException)saxe.getException());
            }
        }
    }

    private void setEjbJar(EjbJarProxy newEjbJar) {
        if (this.ejbJar != null) {
            this.ejbJar.removePropertyChangeListener(this.ejbJarChangeListener);
        }
        this.ejbJar = newEjbJar;
        if (this.ejbJarChangeListener == null) {
            this.ejbJarChangeListener = new EjbJarPropertyChangeListener();
        }
        this.ejbJar.addPropertyChangeListener(this.ejbJarChangeListener);
    }

    @Override
    protected RootInterface getDDModel() {
        if (this.ejbJar == null) {
            try {
                this.parseDocument();
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
        return this.ejbJar;
    }

    @Override
    public boolean isDocumentParseable() {
        return 2 != this.getEjbJar().getStatus();
    }

    protected String getPrefixMark() {
        return "<ejb-jar";
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        if (Util.isJavaEE5orHigher((Project)this.getProject())) {
            return new DesignMultiViewDesc[0];
        }
        return new DesignMultiViewDesc[]{new DDView(this, OVERVIEW), new DDView(this, CMP_RELATIONSHIPS)};
    }

    @Override
    protected boolean isModelCreated() {
        return this.ejbJar != null && this.ejbJar.getOriginal() != null;
    }

    public void showElement(final Object element) {
        if (element instanceof Relationships || element instanceof EjbRelation) {
            this.openView(1);
        } else {
            this.openView(0);
        }
        Utils.runInAwtDispatchThread(new Runnable(){

            @Override
            public void run() {
                SectionNodeView sectionView = (SectionNodeView)EjbJarMultiViewDataObject.this.getActiveMVElement().getSectionView();
                Node root = sectionView.getRoot();
                SectionNode node = ((SectionNode)root.getChildren().getNodes()[0]).getNodeForElement(element);
                if (node != null) {
                    sectionView.openPanel((Object)node);
                    ((SectionNodeInnerPanel)node.getSectionNodePanel().getInnerPanel()).focusData(element);
                }
            }
        });
    }

    public ToolBarMultiViewElement getActiveMVElement() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    private Ejb getEjbFromEjbClass(String ejbClassName) {
        EnterpriseBeans enterpriseBeans = this.getEjbJar().getEnterpriseBeans();
        if (enterpriseBeans != null) {
            Ejb[] ejbs = enterpriseBeans.getEjbs();
            for (int i = 0; i < ejbs.length; ++i) {
                if (ejbs[i].getEjbClass() == null || !ejbs[i].getEjbClass().equals(ejbClassName)) continue;
                return ejbs[i];
            }
        }
        return null;
    }

    private int getBeanInterfaceType(String interfaceName) {
        int interfaceType = -1;
        EjbJar ejbJar = this.getEjbJar();
        if (ejbJar == null) {
            return interfaceType;
        }
        EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
        if (eb == null) {
            return interfaceType;
        }
        Session[] beans = eb.getSession();
        for (int i = 0; i < beans.length; ++i) {
            if (beans[i].getHome() != null && beans[i].getHome().equals(interfaceName)) {
                interfaceType = 10;
                break;
            }
            if (beans[i].getRemote() != null && beans[i].getRemote().equals(interfaceName)) {
                interfaceType = 20;
                break;
            }
            if (beans[i].getLocalHome() != null && beans[i].getLocalHome().equals(interfaceName)) {
                interfaceType = 30;
                break;
            }
            if (beans[i].getLocal() == null || !beans[i].getLocal().equals(interfaceName)) continue;
            interfaceType = 40;
            break;
        }
        return interfaceType;
    }

    private int getSpecificEvent(int eventType, int interfaceType) {
        if (eventType == 2) {
            switch (interfaceType) {
                case 10: {
                    return 5;
                }
                case 20: {
                    return 6;
                }
                case 30: {
                    return 7;
                }
                case 40: {
                    return 8;
                }
            }
        }
        if (eventType == 3) {
            switch (interfaceType) {
                case 10: {
                    return 9;
                }
                case 20: {
                    return 10;
                }
                case 30: {
                    return 11;
                }
                case 40: {
                    return 12;
                }
            }
        }
        return -1;
    }

    private boolean fireEvent(String oldResourceName, String resourceName, int eventType) {
        int interfaceType;
        boolean elementFound = false;
        int specificEventType = -1;
        String resource = eventType == 2 ? oldResourceName : resourceName;
        Ejb ejb = this.getEjbFromEjbClass(resource);
        if (ejb != null) {
            specificEventType = eventType == 2 ? 13 : 14;
            elementFound = true;
        }
        if (!elementFound && (interfaceType = this.getBeanInterfaceType(resource)) > 0) {
            specificEventType = this.getSpecificEvent(eventType, interfaceType);
            elementFound = true;
        }
        if (elementFound) {
            assert (specificEventType > 0);
            DDChangeEvent ddEvent = new DDChangeEvent(this, (DataObject)this, oldResourceName, resourceName, specificEventType);
            this.deploymentChange(ddEvent);
        }
        return elementFound;
    }

    public EntityHelper getEntityHelper(Entity entity) {
        EntityHelper entityHelper = (EntityHelper)this.entityHelperMap.get(entity);
        if (entityHelper == null) {
            entityHelper = new EntityHelper(this, entity);
            this.entityHelperMap.put(entity, entityHelper);
        }
        return entityHelper;
    }

    public SessionHelper getSessionHelper(Session session) {
        SessionHelper sessionHelper = (SessionHelper)this.sessionHelperMap.get(session);
        if (sessionHelper == null) {
            sessionHelper = new SessionHelper(this, session);
            this.sessionHelperMap.put(session, sessionHelper);
        }
        return sessionHelper;
    }

    private class EjbJarPropertyChangeListener
    implements PropertyChangeListener {
        private EjbJarPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("dd_status".equals(evt.getPropertyName())) {
                return;
            }
            Object source = evt.getSource();
            if (source instanceof EnterpriseBeans) {
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if (oldValue instanceof Entity || newValue instanceof Entity) {
                    EjbJarMultiViewDataObject.this.entityHelperMap.keySet().retainAll(Arrays.asList(((EnterpriseBeans)source).getEntity()));
                } else if (oldValue instanceof Session || newValue instanceof Session) {
                    EjbJarMultiViewDataObject.this.sessionHelperMap.keySet().retainAll(Arrays.asList(((EnterpriseBeans)source).getSession()));
                }
            }
        }
    }

    private static class DDView
    extends DesignMultiViewDesc
    implements Serializable {
        private String name;
        static final long serialVersionUID = -8759598009819101630L;

        DDView(EjbJarMultiViewDataObject dataObject, String name) {
            super((XmlMultiViewDataObject)dataObject, name);
            this.name = name;
        }

        public MultiViewElement createElement() {
            EjbJarMultiViewDataObject dataObject = (EjbJarMultiViewDataObject)this.getDataObject();
            if (this.name.equals(EjbJarMultiViewDataObject.OVERVIEW)) {
                return new EjbMultiViewElement(dataObject);
            }
            if (this.name.equals(EjbJarMultiViewDataObject.CMP_RELATIONSHIPS)) {
                return new CmpRelationshipsMultiViewElement(dataObject);
            }
            return null;
        }

        public HelpCtx getHelpCtx() {
            EjbJarMultiViewDataObject dataObject = (EjbJarMultiViewDataObject)this.getDataObject();
            return new HelpCtx(dataObject.getActiveMVElement().getSectionView().getClass());
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon.gif");
        }

        public String preferredID() {
            return "dd_multiview_" + this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(EjbJarMultiViewDataObject.class, (String)("LBL_" + this.name));
        }
    }

    private static final class ViewSupport
    implements ViewCookie {
        private MultiDataObject.Entry primary;

        public ViewSupport(MultiDataObject.Entry primary) {
            this.primary = primary;
        }

        public void view() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(this.primary.getFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
    }

    private class ViewCookieFactory
    implements CookieSet.Factory {
        private ViewCookieFactory() {
        }

        public Node.Cookie createCookie(Class klass) {
            if (klass == ViewCookie.class) {
                return new ViewSupport(EjbJarMultiViewDataObject.this.getPrimaryEntry());
            }
            return null;
        }
    }
}

