/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.pdf.ReconfigureReaderPanel;
import org.netbeans.modules.pdf.Settings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class PDFOpenSupport
implements OpenCookie {
    private static final String DEFAULT_MACOS_VIEWER = "open";
    private static final String[] APP_DIRS = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final String[] VIEWER_NAMES = new String[]{"evince", "xpdf", "kghostview", "ggv", "acroread"};
    static final String FALLBACK_VIEWER_NAME = "acroread";
    private File f;
    private DataObject dObj;

    public PDFOpenSupport(File f) {
        this.f = f;
        try {
            this.dObj = DataObject.find((FileObject)FileUtil.toFileObject((File)f));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    public PDFOpenSupport(DataObject dObj) {
        this.dObj = dObj;
        this.f = FileUtil.toFile((FileObject)dObj.getPrimaryFile());
    }

    public void open() {
        String cmd;
        boolean viewerUnset;
        if (this.dObj != null) {
            this.f = FileUtil.toFile((FileObject)this.dObj.getPrimaryFile());
        }
        String filePath = this.f.getAbsolutePath();
        if (Utilities.isWindows()) {
            PDFOpenSupport.tryCommand(new String[]{"cmd.exe", "/C", "start", "\"PDF Viewer\"", filePath});
            return;
        }
        Settings sett = Settings.getDefault();
        File viewer = sett.getPDFViewer();
        boolean bl = viewerUnset = viewer == null;
        if (viewerUnset && Utilities.getOperatingSystem() == 4096 && PDFOpenSupport.tryCommand(new String[]{cmd = DEFAULT_MACOS_VIEWER, filePath})) {
            sett.setPDFViewer(new File(cmd));
            return;
        }
        if (viewerUnset && (viewer = PDFOpenSupport.tryPredefinedViewers(filePath)) != null) {
            sett.setPDFViewer(viewer);
            return;
        }
        if (viewerUnset) {
            viewer = new File(FALLBACK_VIEWER_NAME);
        }
        boolean viewerFailed = false;
        while (true) {
            try {
                PDFOpenSupport.tryCommandExc(new String[]{viewer.getPath(), filePath});
                if (!viewerUnset && !viewerFailed) break;
                sett.setPDFViewer(viewer);
            }
            catch (IOException ioe) {
                viewerFailed = true;
                String excmessage = ioe.getLocalizedMessage();
                ReconfigureReaderPanel configPanel = new ReconfigureReaderPanel(viewer, excmessage);
                String title = NbBundle.getMessage(PDFOpenSupport.class, (String)"TITLE_pick_a_viewer");
                DialogDescriptor d = new DialogDescriptor((Object)configPanel, title);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != DialogDescriptor.OK_OPTION) break;
                viewer = configPanel.getSelectedFile();
                sett.setPDFViewer(viewer);
                continue;
            }
            break;
        }
    }

    private static File tryPredefinedViewers(String filePath) {
        for (int i = 0; i < APP_DIRS.length; ++i) {
            File dir = new File(APP_DIRS[i]);
            if (!dir.exists() || !dir.isDirectory()) continue;
            for (int j = 0; j < VIEWER_NAMES.length; ++j) {
                String viewerPath = APP_DIRS[i] + File.separatorChar + VIEWER_NAMES[j];
                File viewer = new File(viewerPath);
                if (!viewer.exists() || !PDFOpenSupport.tryCommand(new String[]{viewerPath, filePath})) continue;
                return viewer;
            }
        }
        return null;
    }

    private static boolean tryCommand(String[] cmdArray) {
        try {
            PDFOpenSupport.tryCommandExc(cmdArray);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static void tryCommandExc(String[] cmdArray) throws IOException {
        Runtime.getRuntime().exec(cmdArray);
    }
}

