/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddMIDletPanel;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerMIDlets
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ChangeListener,
TableModelListener {
    static final long serialVersionUID = -7485135564331430899L;
    static final String[] PROPERTY_GROUP = new String[]{"manifest.midlets"};
    private final DefaultComboBoxModel cbmClassesForAdd;
    private final DefaultComboBoxModel cbmIconsForAdd;
    protected HashSet<String> classes;
    protected HashSet<String> icons;
    private VisualPropertySupport vps;
    private final MIDletsTableModel model = new MIDletsTableModel();
    private JButton addButton;
    private JCheckBox defaultCheck;
    private JButton downButton;
    private JButton editButton;
    private ErrorPanel errorPanel;
    private JTable midletsTable;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JLabel tableLabel;
    private JButton upButton;

    public CustomizerMIDlets() {
        this.initComponents();
        this.initAccessibility();
        this.cbmClassesForAdd = new DefaultComboBoxModel();
        this.cbmIconsForAdd = new DefaultComboBoxModel();
        this.model.addTableModelListener(this);
        this.midletsTable.setSelectionMode(0);
        this.midletsTable.getSelectionModel().addListSelectionListener(this);
        this.midletsTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 1 && CustomizerMIDlets.this.classes != null && !CustomizerMIDlets.this.classes.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.midletsTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setForeground(isSelected ? table.getSelectionForeground() : (column == 2 && CustomizerMIDlets.this.icons != null && !CustomizerMIDlets.this.icons.contains(value) ? Color.RED : table.getForeground()));
                return component;
            }
        });
        this.midletsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    CustomizerMIDlets.this.editButtonActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.defaultCheck = new JCheckBox();
        this.tableLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.midletsTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultCheck, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_Use_Default"));
        this.defaultCheck.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.defaultCheck, gridBagConstraints);
        this.defaultCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_UseDefault"));
        this.tableLabel.setLabelFor(this.midletsTable);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MIDlets"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.midletsTable.setModel(this.model);
        this.scrollPane.setViewportView(this.midletsTable);
        this.midletsTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MIDlets"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDlets.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDlets.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.editButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Edit"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDlets.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MoveUp"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDlets.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MoveDown"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMIDlets.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 12, 0);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSN_CustMIDlets"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets"));
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0 || editedRow > this.midletsTable.getRowCount() - 2) {
            return;
        }
        this.model.moveDown(editedRow);
        this.midletsTable.getSelectionModel().setSelectionInterval(editedRow + 1, editedRow + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 1) {
            return;
        }
        this.model.moveUp(editedRow);
        this.midletsTable.getSelectionModel().setSelectionInterval(editedRow - 1, editedRow - 1);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0) {
            return;
        }
        this.model.remove(editedRow);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int editedRow = this.midletsTable.getSelectedRow();
        if (editedRow < 0) {
            return;
        }
        String[] s = this.model.getRow(editedRow).split(",", 3);
        AddMIDletPanel p = new AddMIDletPanel(s[0].trim(), s[2].trim(), s[1].trim(), this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor desc = new DialogDescriptor((Object)p, NbBundle.getMessage(CustomizerMIDlets.class, (String)"Title_CustMIDlets_EditMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddMIDletPanel.class), null);
        p.setDialogDescriptor(desc);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            this.model.setRow(editedRow, p.getName(), p.getClazz(), p.getIcon());
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int i;
        HashSet<String> hs = new HashSet<String>();
        for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
            hs.add(this.model.getValueAt(i2, 2).trim());
        }
        String cname = null;
        for (i = 0; i < this.cbmClassesForAdd.getSize() && hs.contains(this.cbmClassesForAdd.getElementAt(i)); ++i) {
        }
        String string = cname = i < this.cbmClassesForAdd.getSize() ? (String)this.cbmClassesForAdd.getElementAt(i) : null;
        if (cname != null) {
            cname = cname.trim();
        }
        AddMIDletPanel p = new AddMIDletPanel(null, cname, null, this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor desc = new DialogDescriptor((Object)p, NbBundle.getMessage(CustomizerMIDlets.class, (String)"Title_CustMIDlets_AddMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddMIDletPanel.class), null);
        p.setDialogDescriptor(desc);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            this.model.addRow(p.getName(), p.getClazz(), p.getIcon());
        }
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.vps = VisualPropertySupport.getDefault(props);
        this.icons = null;
        this.classes = null;
        MIDletScanner scanner = MIDletScanner.getDefault(props);
        scanner.scan(this.cbmClassesForAdd, this.cbmIconsForAdd, configuration, this);
        this.vps.register(this.defaultCheck, configuration, this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i;
        this.classes = new HashSet();
        for (i = 0; i < this.cbmClassesForAdd.getSize(); ++i) {
            this.classes.add((String)this.cbmClassesForAdd.getElementAt(i));
        }
        this.icons = new HashSet();
        for (i = 0; i < this.cbmIconsForAdd.getSize(); ++i) {
            this.icons.add((String)this.cbmIconsForAdd.getElementAt(i));
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        this.vps.register(this.model, new String[]{"manifest.midlets"}, useDefault);
        this.addButton.setEnabled(!useDefault);
        this.midletsTable.setEnabled(!useDefault);
        this.midletsTable.setBackground(UIManager.getDefaults().getColor(useDefault ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
        this.tableLabel.setEnabled(!useDefault);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i = this.midletsTable.getSelectedRow();
        boolean enabled = this.midletsTable.isEnabled();
        boolean selected = enabled && i >= 0;
        this.editButton.setEnabled(selected);
        this.removeButton.setEnabled(selected);
        this.upButton.setEnabled(enabled && i > 0);
        this.downButton.setEnabled(selected && i < this.model.getRowCount() - 1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.classes != null && !this.classes.containsAll(this.model.getClasses())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
        } else if (this.icons != null && !this.icons.containsAll(this.model.getIcons())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongIcons");
        } else {
            this.errorPanel.setErrorBundleMessage(null);
        }
    }

    private static class MIDletsTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        public static final String PREFIX = "MIDlet-";
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final int[] COLUMN_MAP = new int[]{0, 2, 1};
        private static final String[] COLUMN_NAMES = new String[]{NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDletsName_Name"), NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Class"), NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Icon")};
        private static final long serialVersionUID = -7485135564331430899L;

        private MIDletsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public String getColumnName(int column) {
            assert (column < 3);
            return COLUMN_NAMES[column];
        }

        public Set<String> getClasses() {
            HashSet<String> classes = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                classes.add(this.getValueAt(i, 1));
            }
            return classes;
        }

        public Set<String> getIcons() {
            HashSet<String> icons = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                String icon = this.getValueAt(i, 2);
                if (icon.length() <= 0) continue;
                icons.add(icon);
            }
            return icons;
        }

        public void addRow(String name, String clazz, String icon) {
            ++this.rows;
            this.setRow(this.rows - 1, name + ',' + icon + ',' + clazz);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
        }

        protected String getRow(int row) {
            assert (row < this.rows);
            String value = this.map.get(PREFIX + String.valueOf(row + 1));
            return value == null ? ",," : value;
        }

        private void setRow(int row, String value) {
            assert (row < this.rows);
            this.map.put(PREFIX + String.valueOf(row + 1), value);
        }

        public void remove(int row) {
            for (int i = row; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(row, row);
        }

        public void moveUp(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row - 1));
            this.setRow(row - 1, r);
            this.fireTableRowsUpdated(row - 1, row);
        }

        public void moveDown(int row) {
            String r = this.getRow(row);
            this.setRow(row, this.getRow(row + 1));
            this.setRow(row + 1, r);
            this.fireTableRowsUpdated(row, row + 1);
        }

        @Override
        public String getValueAt(int row, int column) {
            assert (column < 3);
            return this.getRow(row).split(",", 3)[COLUMN_MAP[column]].trim();
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public synchronized void setDataDelegates(Object[] data) {
            this.map = data[0] == null ? new HashMap() : (HashMap)data[0];
            this.rows = 0;
            for (String key : this.map.keySet()) {
                if (!key.startsWith(PREFIX)) continue;
                try {
                    int i = Integer.parseInt(key.substring(PREFIX.length()));
                    if (i <= this.rows) continue;
                    this.rows = i;
                }
                catch (NumberFormatException nfe) {
                    assert (false) : nfe;
                }
            }
            this.fireTableDataChanged();
        }

        public void setRow(int row, String name, String clazz, String icon) {
            this.setRow(row, name + ',' + icon + ',' + clazz);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

