/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.CyclicDependencyWarningPanel;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class CompiledSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private static final RequestProcessor RP = new RequestProcessor(CompiledSourceForBinaryQuery.class);
    protected J2MEProject project;
    protected final Set<Thread> threads;
    protected final AntProjectHelper helper;

    public CompiledSourceForBinaryQuery(J2MEProject project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
        this.threads = Collections.synchronizedSet(new HashSet());
    }

    public SourceForBinaryQuery.Result findSourceRoots(final URL binaryRoot) {
        try {
            URL distRoot = this.helper.resolveFile("dist").toURI().toURL();
            URL buildRoot = this.helper.resolveFile("build").toURI().toURL();
            if (J2MEProjectUtils.isParentOf(distRoot, binaryRoot) || J2MEProjectUtils.isParentOf(buildRoot, binaryRoot)) {
                class R
                implements SourceForBinaryQuery.Result,
                AntProjectListener {
                    List<ChangeListener> listeners = Collections.synchronizedList(new ArrayList());
                    private FileObject[] cache = null;
                    private final AntProjectListener antProjectListener;
                    private final transient Object lock = new Object();

                    public R(AntProjectHelper helper) {
                        this.antProjectListener = (AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)((Object)this), (Object)helper);
                        helper.addAntProjectListener(this.antProjectListener);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public FileObject[] getRoots() {
                        FileObject[] fo = this.cache;
                        if (fo == null) {
                            fo = this.createRoots();
                            Object object = this.lock;
                            synchronized (object) {
                                if (this.cache != null) {
                                    this.cache = fo;
                                }
                            }
                        }
                        return fo;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private FileObject[] createRoots() {
                        ArrayList<FileObject> roots;
                        block11: {
                            roots = new ArrayList<FileObject>();
                            try {
                                String cfg;
                                String path;
                                FileObject src;
                                URL projectRoot = URLMapper.findURL((FileObject)CompiledSourceForBinaryQuery.this.helper.getProjectDirectory(), (int)1);
                                URL distRoot = CompiledSourceForBinaryQuery.this.helper.resolveFile("dist").toURI().toURL();
                                URL buildRoot = CompiledSourceForBinaryQuery.this.helper.resolveFile("build").toURI().toURL();
                                if (!J2MEProjectUtils.isParentOf(distRoot, binaryRoot) && !J2MEProjectUtils.isParentOf(buildRoot, binaryRoot)) break block11;
                                String srcPath = CompiledSourceForBinaryQuery.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
                                FileObject fileObject = src = srcPath == null ? null : CompiledSourceForBinaryQuery.this.helper.resolveFileObject(srcPath);
                                if (src != null) {
                                    roots.add(src);
                                }
                                if ((path = J2MEProjectUtils.evaluateProperty(CompiledSourceForBinaryQuery.this.helper, "libs.classpath", cfg = J2MEProjectUtils.detectConfiguration(projectRoot, binaryRoot))) != null) {
                                    path = CompiledSourceForBinaryQuery.this.helper.resolvePath(path);
                                }
                                if (path == null) break block11;
                                String[] p = PropertyUtils.tokenizePath((String)path);
                                for (int i = 0; i < p.length; ++i) {
                                    try {
                                        URL url = J2MEProjectUtils.wrapJar(new File(p[i]).toURI().toURL());
                                        if (url == null || J2MEProjectUtils.isParentOf(projectRoot, url)) continue;
                                        if (CompiledSourceForBinaryQuery.this.threads.contains(Thread.currentThread())) {
                                            CyclicDependencyWarningPanel.showWarning(ProjectUtils.getInformation((Project)CompiledSourceForBinaryQuery.this.project).getDisplayName());
                                            return new FileObject[0];
                                        }
                                        try {
                                            CompiledSourceForBinaryQuery.this.threads.add(Thread.currentThread());
                                            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)url);
                                            if (result == null) continue;
                                            roots.addAll(Arrays.asList(result.getRoots()));
                                            continue;
                                        }
                                        finally {
                                            CompiledSourceForBinaryQuery.this.threads.remove(Thread.currentThread());
                                        }
                                    }
                                    catch (MalformedURLException mue) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (MalformedURLException mue) {
                                ErrorManager.getDefault().notify((Throwable)mue);
                            }
                        }
                        return roots.toArray(new FileObject[roots.size()]);
                    }

                    public void addChangeListener(ChangeListener l) {
                        this.listeners.add(l);
                    }

                    public void removeChangeListener(ChangeListener l) {
                        this.listeners.remove(l);
                    }

                    private void fireChanged() {
                        RP.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                List<ChangeListener> list = listeners;
                                synchronized (list) {
                                    ChangeEvent event = new ChangeEvent(this);
                                    for (int i = 0; i < listeners.size(); ++i) {
                                        ChangeListener changeListener = listeners.get(i);
                                        changeListener.stateChanged(event);
                                    }
                                }
                            }
                        });
                    }

                    public void configurationXmlChanged(AntProjectEvent event) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertiesChanged(AntProjectEvent event) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.cache = null;
                        }
                        this.fireChanged();
                    }
                }
                return new R(this.helper);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }
}

