/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.javadoc.DocPositions;
import org.netbeans.modules.java.editor.javadoc.JavaReference;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;

public final class JavadocImports {
    private static final Set<String> ALL_REF_TAG_NAMES = new HashSet<String>(Arrays.asList("@link", "@linkplain", "@value", "@see", "@throws"));

    private JavadocImports() {
    }

    public static Set<String> computeUnresolvedImports(CompilationInfo javac) {
        List topLevelElements = javac.getTopLevelElements();
        UnresolvedImportScanner scanner = new UnresolvedImportScanner(javac);
        scanner.scan(topLevelElements, null);
        return scanner.unresolved;
    }

    public static Set<TypeElement> computeReferencedElements(CompilationInfo javac, TreePath tp) {
        Set<TypeElement> result = null;
        Element el = javac.getTrees().getElement(tp);
        TokenSequence<JavadocTokenId> jdTokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(javac, tp.getLeaf(), el);
        if (el != null && jdTokenSequence != null) {
            List<Object> tags;
            ElementKind kind = el.getKind();
            TypeElement scope = kind.isClass() || kind.isInterface() ? (TypeElement)el : javac.getElementUtilities().enclosingTypeElement(el);
            Doc javadoc = javac.getElementUtilities().javaDocFor(el);
            DocPositions positions = null;
            if (javadoc != null && scope != null) {
                positions = DocPositions.get(javac, javadoc, jdTokenSequence);
                tags = positions.getTags();
            } else {
                tags = Collections.emptyList();
            }
            for (Tag tag : tags) {
                List<JavaReference> refs = JavadocImports.findReferences(tag, positions, jdTokenSequence);
                if (refs == null) continue;
                for (JavaReference reference : refs) {
                    DeclaredType declaredType;
                    TypeElement foundElement;
                    if (reference.fqn == null) continue;
                    String fqn = ((Object)reference.fqn).toString();
                    TypeMirror type = javac.getTreeUtilities().parseType(fqn, scope);
                    if (type == null || type.getKind() != TypeKind.DECLARED && type.getKind() != TypeKind.ERROR || !SourceVersion.isIdentifier((foundElement = (TypeElement)(declaredType = (DeclaredType)type).asElement()).getSimpleName())) continue;
                    if (result == null) {
                        result = new HashSet<TypeElement>();
                    }
                    result.add(foundElement);
                }
            }
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public static List<Token> computeTokensOfReferencedElements(CompilationInfo javac, TreePath forElement, Element toFind) {
        List<Token> result = null;
        Element el = javac.getTrees().getElement(forElement);
        TokenSequence<JavadocTokenId> jdTokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(javac, forElement.getLeaf(), el);
        if (el != null && jdTokenSequence != null) {
            List<Object> tags;
            ElementKind kind = el.getKind();
            TypeElement scope = kind.isClass() || kind.isInterface() ? (TypeElement)el : javac.getElementUtilities().enclosingTypeElement(el);
            Doc javadoc = javac.getElementUtilities().javaDocFor(el);
            DocPositions positions = null;
            if (javadoc != null && scope != null) {
                positions = DocPositions.get(javac, javadoc, jdTokenSequence);
                tags = positions.getTags();
            } else {
                tags = Collections.emptyList();
            }
            boolean isParam = toFind.getKind() == ElementKind.PARAMETER;
            boolean isTypeParam = toFind.getKind() == ElementKind.TYPE_PARAMETER;
            for (Tag tag : tags) {
                Token<JavadocTokenId> token;
                List<JavaReference> references = JavadocImports.findReferences(tag, positions, jdTokenSequence);
                if (references != null) {
                    for (JavaReference ref : references) {
                        Element referenced;
                        for (referenced = ref.getReferencedElement(javac, scope); referenced != null && referenced != toFind; referenced = referenced.getEnclosingElement()) {
                        }
                        if (referenced != toFind) continue;
                        int pos = -1;
                        ElementKind rkind = referenced.getKind();
                        if (ref.fqn != null && (rkind.isClass() || rkind.isInterface())) {
                            String fqn = ((TypeElement)referenced).getQualifiedName().toString();
                            String reffqn = ((Object)ref.fqn).toString();
                            if (reffqn.startsWith(fqn)) {
                                pos = ref.begin + fqn.length() - 1;
                            } else {
                                String simpleName = referenced.getSimpleName().toString();
                                pos = ref.begin + simpleName.length() - 1;
                            }
                        } else if (rkind.isField() || rkind == ElementKind.METHOD || rkind == ElementKind.CONSTRUCTOR) {
                            pos = ref.end - 1;
                        }
                        if (pos < 0) continue;
                        jdTokenSequence.move(pos);
                        if (!jdTokenSequence.moveNext() || jdTokenSequence.token().id() != JavadocTokenId.IDENT) continue;
                        if (result == null) {
                            result = new ArrayList<Token>();
                        }
                        result.add(jdTokenSequence.token());
                    }
                    continue;
                }
                if (!isParam && !isTypeParam || tag == null || !"@param".equals(tag.name())) continue;
                ParamTag ptag = (ParamTag)tag;
                boolean isKindMatching = isParam && !ptag.isTypeParameter() || isTypeParam && ptag.isTypeParameter();
                if (!isKindMatching || !toFind.getSimpleName().contentEquals(ptag.parameterName()) || toFind != JavadocImports.paramElementFor(el, ptag) || (token = JavadocImports.findNameTokenOfParamTag(tag, positions, jdTokenSequence)) == null) continue;
                if (result == null) {
                    result = new ArrayList<Token>();
                }
                result.add(token);
            }
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private static Element paramElementFor(Element methodOrClass, ParamTag ptag) {
        ElementKind kind = methodOrClass.getKind();
        List<Object> params = Collections.emptyList();
        if (kind == ElementKind.METHOD || kind == ElementKind.CONSTRUCTOR) {
            ExecutableElement ee = (ExecutableElement)methodOrClass;
            params = ptag.isTypeParameter() ? ee.getTypeParameters() : ee.getParameters();
        } else if (kind.isClass() || kind.isInterface()) {
            TypeElement te = (TypeElement)methodOrClass;
            params = te.getTypeParameters();
        }
        for (Element element : params) {
            if (!element.getSimpleName().contentEquals(ptag.parameterName())) continue;
            return element;
        }
        return null;
    }

    public static Element findReferencedElement(CompilationInfo javac, int offset) {
        Element result = null;
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (doc == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> jdTokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(javac, offset);
        if (jdTokenSequence != null) {
            List<JavaReference> references;
            Doc javadoc = JavadocCompletionUtils.findJavadoc(javac, doc, offset);
            if (javadoc == null) {
                return null;
            }
            DocPositions positions = DocPositions.get(javac, javadoc, jdTokenSequence);
            Element el = javac.getElementUtilities().elementFor(javadoc);
            if (positions == null || el == null) {
                return null;
            }
            ElementKind kind = el.getKind();
            TypeElement scope = kind.isClass() || kind.isInterface() ? (TypeElement)el : javac.getElementUtilities().enclosingTypeElement(el);
            Tag tag = positions.getTag(offset);
            List<JavaReference> list = references = tag != null ? JavadocImports.findReferences(tag, positions, jdTokenSequence) : null;
            if (references != null && scope != null) {
                for (JavaReference reference : references) {
                    result = reference.getReferencedElement(javac, scope);
                    if (result == null || reference.fqn == null || offset >= reference.begin + reference.fqn.length()) continue;
                    result = result.getKind().isClass() || result.getKind().isInterface() ? result : result.getEnclosingElement();
                    int elmNameLength = result.getSimpleName().length();
                    while (result != null && offset < reference.begin + reference.fqn.length() - elmNameLength) {
                        elmNameLength += (result = result.getEnclosingElement()) != null ? result.getSimpleName().length() + 1 : 0;
                    }
                    if (result == null) continue;
                    break;
                }
            } else if (tag instanceof ParamTag && "@param".equals(tag.name())) {
                ParamTag ptag = (ParamTag)tag;
                result = JavadocImports.paramElementFor(el, ptag);
            }
        }
        return result;
    }

    public static Token findNameTokenOfReferencedElement(CompilationInfo javac, int offset) {
        Document doc = null;
        try {
            doc = javac.getDocument();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (doc == null) {
            return null;
        }
        TokenSequence<JavadocTokenId> jdTokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(javac, offset);
        if (jdTokenSequence != null) {
            List<JavaReference> references;
            Doc javadoc = JavadocCompletionUtils.findJavadoc(javac, doc, offset);
            if (javadoc == null) {
                return null;
            }
            DocPositions positions = DocPositions.get(javac, javadoc, jdTokenSequence);
            Element el = javac.getElementUtilities().elementFor(javadoc);
            if (positions == null || el == null) {
                return null;
            }
            ElementKind kind = el.getKind();
            TypeElement scope = kind.isClass() || kind.isInterface() ? (TypeElement)el : javac.getElementUtilities().enclosingTypeElement(el);
            Tag tag = positions.getTag(offset);
            List<JavaReference> list = references = tag != null ? JavadocImports.findReferences(tag, positions, jdTokenSequence) : null;
            if (references != null && scope != null) {
                for (JavaReference reference : references) {
                    int fqnLength;
                    Element elm = reference.getReferencedElement(javac, scope);
                    if (elm == null) continue;
                    int n = fqnLength = reference.fqn != null ? reference.fqn.length() : 0;
                    if ((reference.fqn == null || offset < reference.begin || offset >= reference.begin + fqnLength) && (reference.member == null || offset <= reference.begin + fqnLength || offset >= reference.end)) continue;
                    jdTokenSequence.move(offset);
                    if (!jdTokenSequence.moveNext()) continue;
                    return jdTokenSequence.token().id() == JavadocTokenId.IDENT ? jdTokenSequence.token() : null;
                }
            } else {
                Token<JavadocTokenId> token = JavadocImports.findNameTokenOfParamTag(tag, positions, jdTokenSequence);
                return token;
            }
        }
        return null;
    }

    private static Token<JavadocTokenId> findNameTokenOfParamTag(Tag tag, DocPositions positions, TokenSequence<JavadocTokenId> jdTokenSequence) {
        if (tag == null || !"@param".equals(tag.name())) {
            return null;
        }
        ParamTag ptag = (ParamTag)tag;
        int[] tagSpan = positions.getTagSpan(tag);
        Token result = null;
        if (ptag.isTypeParameter()) {
            jdTokenSequence.move(tagSpan[0]);
            if (jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.TAG && jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.OTHER_TEXT && jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.HTML_TAG) {
                result = jdTokenSequence.token();
            }
        } else {
            jdTokenSequence.move(tagSpan[0]);
            if (jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.TAG && jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.OTHER_TEXT && jdTokenSequence.moveNext() && jdTokenSequence.token().id() == JavadocTokenId.IDENT) {
                result = jdTokenSequence.token();
            }
        }
        return result;
    }

    public static boolean isInsideReference(TokenSequence<JavadocTokenId> jdts, int pos) {
        jdts.move(pos);
        if (jdts.moveNext() && JavadocTokenId.IDENT == jdts.token().id()) {
            boolean isBeforeWS = false;
            block6: while (jdts.movePrevious()) {
                Token jdt = jdts.token();
                switch ((JavadocTokenId)jdt.id()) {
                    case DOT: 
                    case HASH: 
                    case IDENT: {
                        if (!isBeforeWS) continue block6;
                        return false;
                    }
                    case OTHER_TEXT: {
                        isBeforeWS |= JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)jdt);
                        if (isBeforeWS |= JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)jdt)) continue block6;
                        return false;
                    }
                    case TAG: {
                        return isBeforeWS && JavadocImports.isReferenceTag((Token<JavadocTokenId>)jdt);
                    }
                    case HTML_TAG: {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isInsideParamName(TokenSequence<JavadocTokenId> jdts, int pos) {
        jdts.move(pos);
        if (jdts.moveNext() && (JavadocTokenId.IDENT == jdts.token().id() || JavadocTokenId.HTML_TAG == jdts.token().id()) && jdts.movePrevious() && JavadocTokenId.OTHER_TEXT == jdts.token().id() && jdts.movePrevious() && JavadocTokenId.TAG == jdts.token().id()) {
            return "@param".contentEquals(jdts.token().text());
        }
        return false;
    }

    private static List<JavaReference> findReferences(Tag tag, DocPositions positions, TokenSequence<JavadocTokenId> jdTokenSequence) {
        if (tag == null || !JavadocImports.isReferenceTag(tag)) {
            return null;
        }
        int[] tagSpan = positions.getTagSpan(tag);
        jdTokenSequence.move(tagSpan[0] + (JavadocCompletionUtils.isBlockTag(tag) ? 0 : 1));
        if (!jdTokenSequence.moveNext() || jdTokenSequence.token().id() != JavadocTokenId.TAG) {
            return null;
        }
        if (!jdTokenSequence.moveNext() || !JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)jdTokenSequence.token()) && !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)jdTokenSequence.token()) || !jdTokenSequence.moveNext()) {
            return null;
        }
        JavaReference reference = JavaReference.resolve(jdTokenSequence, jdTokenSequence.offset(), tagSpan[1]);
        return reference.getAllReferences();
    }

    private static boolean isReferenceTag(Tag tag) {
        String tagName = tag.name();
        return ALL_REF_TAG_NAMES.contains(tagName.intern());
    }

    private static boolean isReferenceTag(Token<JavadocTokenId> tag) {
        String tagName = ((Object)tag.text()).toString().intern();
        return tag.id() == JavadocTokenId.TAG && ALL_REF_TAG_NAMES.contains(tagName);
    }

    private static final class UnresolvedImportScanner
    extends ElementScanner6<Void, Void> {
        private final CompilationInfo javac;
        private Set<String> unresolved = new HashSet<String>();

        public UnresolvedImportScanner(CompilationInfo javac) {
            this.javac = javac;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            TypeElement enclosingTypeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)e);
            if (enclosingTypeElement != null) {
                this.resolveElement(e, enclosingTypeElement);
            }
            return (Void)super.visitExecutable(e, p);
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            this.resolveElement(e, e);
            return (Void)super.visitType(e, p);
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            TypeElement enclosingTypeElement = this.javac.getElementUtilities().enclosingTypeElement((Element)e);
            if (enclosingTypeElement != null) {
                this.resolveElement(e, enclosingTypeElement);
            }
            return (Void)super.visitVariable(e, p);
        }

        private void resolveElement(Element el, TypeElement scope) {
            String jdText = this.javac.getElements().getDocComment(el);
            if (jdText != null) {
                DocPositions positions;
                Doc javadoc = this.javac.getElementUtilities().javaDocFor(el);
                TokenSequence<JavadocTokenId> jdTokenSequence = JavadocCompletionUtils.findJavadocTokenSequence(this.javac, null, el);
                if (jdTokenSequence != null && (positions = DocPositions.get(this.javac, javadoc, jdTokenSequence)) != null) {
                    this.resolveTags(positions, jdTokenSequence, scope);
                }
            }
        }

        private void resolveTags(DocPositions positions, TokenSequence<JavadocTokenId> jdTokenSequence, TypeElement scope) {
            for (Tag tag : positions.getTags()) {
                List references = JavadocImports.findReferences(tag, positions, (TokenSequence<JavadocTokenId>)jdTokenSequence);
                if (references == null) continue;
                for (JavaReference reference : references) {
                    if (reference.fqn == null || reference.fqn.length() <= 0) continue;
                    String fqn = ((Object)reference.fqn).toString();
                    TypeMirror type = this.javac.getTreeUtilities().parseType(fqn, scope);
                    if (type == null || type.getKind() != TypeKind.ERROR) continue;
                    this.unresolved.add(fqn);
                }
            }
        }
    }
}

