/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Scope;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class LazyTypeCompletionItem
extends JavaCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> handle;
    private EnumSet<ElementKind> kinds;
    private Source source;
    private boolean insideNew;
    private boolean addTypeVars;
    private boolean afterExtends;
    private String name;
    private String simpleName;
    private String pkgName;
    private JavaCompletionItem delegate = null;
    private CharSequence sortText;
    private int prefWidth = -1;

    public static final LazyTypeCompletionItem create(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends) {
        return new LazyTypeCompletionItem(handle, kinds, substitutionOffset, source, insideNew, addTypeVars, afterExtends);
    }

    private LazyTypeCompletionItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends) {
        super(substitutionOffset);
        this.handle = handle;
        this.kinds = kinds;
        this.source = source;
        this.insideNew = insideNew;
        this.addTypeVars = addTypeVars;
        this.afterExtends = afterExtends;
        this.name = handle.getQualifiedName();
        int idx = this.name.lastIndexOf(46);
        this.simpleName = idx > -1 ? this.name.substring(idx + 1) : this.name;
        this.pkgName = idx > -1 ? this.name.substring(0, idx) : "";
        this.sortText = this.simpleName + Utilities.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
    }

    public boolean accept() {
        if (this.handle != null) {
            try {
                ParserManager.parse(Collections.singletonList(this.source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(LazyTypeCompletionItem.this.substitutionOffset));
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Scope scope = controller.getTrees().getScope(controller.getTreeUtilities().pathFor(LazyTypeCompletionItem.this.substitutionOffset));
                        TypeElement e = (TypeElement)LazyTypeCompletionItem.this.handle.resolve((CompilationInfo)controller);
                        Elements elements = controller.getElements();
                        if (!(e == null || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(e) || !controller.getTrees().isAccessible(scope, e) || !LazyTypeCompletionItem.this.isOfKind(e, LazyTypeCompletionItem.this.kinds) || LazyTypeCompletionItem.this.afterExtends && e.getModifiers().contains((Object)Modifier.FINAL) || LazyTypeCompletionItem.this.isInDefaultPackage(e) && !LazyTypeCompletionItem.this.isInDefaultPackage(scope.getEnclosingClass()) || Utilities.isExcluded(e.getQualifiedName()))) {
                            LazyTypeCompletionItem.this.delegate = JavaCompletionItem.createTypeItem((CompilationInfo)controller, e, (DeclaredType)e.asType(), LazyTypeCompletionItem.this.substitutionOffset, true, controller.getElements().isDeprecated(e), LazyTypeCompletionItem.this.insideNew, LazyTypeCompletionItem.this.addTypeVars, false, false);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.delegate != null;
    }

    @Override
    public void defaultAction(JTextComponent component) {
        if (this.delegate != null) {
            this.delegate.defaultAction(component);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(evt);
        }
    }

    @Override
    public int getPreferredWidth(Graphics g, Font defaultFont) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)g, (Font)defaultFont);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (this.delegate != null) {
            this.delegate.render(g, defaultFont, defaultColor, backgroundColor, width, height, selected);
        }
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    public int getSortPriority() {
        return 700;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    private boolean isOfKind(Element e, EnumSet<ElementKind> kinds) {
        if (kinds.contains((Object)e.getKind())) {
            return true;
        }
        for (Element element : e.getEnclosedElements()) {
            if (!this.isOfKind(element, kinds)) continue;
            return true;
        }
        return false;
    }

    private boolean isInDefaultPackage(Element e) {
        while (e != null && e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return e != null && e.getSimpleName().length() == 0;
    }
}

