/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCodeTemplateFilter;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.preprocessorbridge.api.JavaSourceUtil;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCodeTemplateProcessor
implements CodeTemplateProcessor {
    public static final String INSTANCE_OF = "instanceof";
    public static final String ARRAY = "array";
    public static final String ITERABLE = "iterable";
    public static final String TYPE = "type";
    public static final String TYPE_VAR = "typeVar";
    public static final String ITERABLE_ELEMENT_TYPE = "iterableElementType";
    public static final String LEFT_SIDE_TYPE = "leftSideType";
    public static final String RIGHT_SIDE_TYPE = "rightSideType";
    public static final String CAST = "cast";
    public static final String NEW_VAR_NAME = "newVarName";
    public static final String NAMED = "named";
    public static final String UNCAUGHT_EXCEPTION_TYPE = "uncaughtExceptionType";
    public static final String UNCAUGHT_EXCEPTION_CATCH_STATEMENTS = "uncaughtExceptionCatchStatements";
    public static final String CURRENT_CLASS_NAME = "currClassName";
    private static final String TRUE = "true";
    private static final String NULL = "null";
    private static final String ERROR = "<error>";
    private static final String CLASS = "class";
    private CodeTemplateInsertRequest request;
    private int caretOffset;
    private CompilationInfo cInfo = null;
    private TreePath treePath = null;
    private Scope scope = null;
    private TypeElement enclClass = null;
    private List<Element> locals = null;
    private List<Element> typeVars = null;
    private Map<CodeTemplateParameter, String> param2hints = new HashMap<CodeTemplateParameter, String>();
    private Map<CodeTemplateParameter, TypeMirror> param2types = new HashMap<CodeTemplateParameter, TypeMirror>();
    private ErrChecker errChecker = new ErrChecker();

    private JavaCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
        for (CodeTemplateParameter param : request.getMasterParameters()) {
            if ("selection".equals(param.getName())) {
                this.initParsing();
                return;
            }
            for (String hint : param.getHints().keySet()) {
                if (!UNCAUGHT_EXCEPTION_CATCH_STATEMENTS.equals(hint) && !INSTANCE_OF.equals(hint) && !ARRAY.equals(hint) && !ITERABLE.equals(hint) && !TYPE.equals(hint) && !ITERABLE_ELEMENT_TYPE.equals(hint) && !LEFT_SIDE_TYPE.equals(hint) && !RIGHT_SIDE_TYPE.equals(hint) && !CAST.equals(hint) && !NEW_VAR_NAME.equals(hint) && !CURRENT_CLASS_NAME.equals(hint) && !ITERABLE_ELEMENT_TYPE.equals(hint) && !UNCAUGHT_EXCEPTION_TYPE.equals(hint)) continue;
                this.initParsing();
                return;
            }
        }
    }

    public void updateDefaultValues() {
        this.updateTemplateEnding();
        this.updateTemplateBasedOnCatchers();
        this.updateTemplateBasedOnSelection();
        boolean cont = true;
        while (cont) {
            cont = false;
            for (CodeTemplateParameter p : this.request.getMasterParameters()) {
                CodeTemplateParameter param = p;
                String value = this.getProposedValue(param);
                if (value == null || value.equals(param.getValue())) continue;
                param.setValue(value);
                cont = true;
            }
        }
        this.updateImports();
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
        if (typingChange) {
            for (CodeTemplateParameter p : this.request.getMasterParameters()) {
                CodeTemplateParameter param = p;
                if (!param.isUserModified()) {
                    String value = this.getProposedValue(param);
                    if (value == null || value.equals(param.getValue())) continue;
                    param.setValue(value);
                    continue;
                }
                this.param2types.remove(param);
            }
            this.updateImports();
        }
    }

    public void release() {
    }

    private void updateTemplateEnding() {
        String text = this.request.getParametrizedText();
        if (text.endsWith("\n")) {
            JTextComponent component = this.request.getComponent();
            int offset = component.getSelectionEnd();
            Document doc = component.getDocument();
            if (doc.getLength() > offset) {
                try {
                    if ("\n".equals(doc.getText(offset, 1))) {
                        this.request.setParametrizedText(text.substring(0, text.length() - 1));
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
        }
    }

    private void updateTemplateBasedOnCatchers() {
        for (CodeTemplateParameter parameter : this.request.getAllParameters()) {
            for (String hint : parameter.getHints().keySet()) {
                if (!UNCAUGHT_EXCEPTION_CATCH_STATEMENTS.equals(hint) || this.cInfo == null) continue;
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) continue;
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), parameter.getInsertTextOffset(), sourcePositions[0]);
                if ((path = Utilities.getPathElementOfKind(Tree.Kind.TRY, path)) == null || ((TryTree)path.getLeaf()).getBlock() == null) continue;
                tu.attributeTree((Tree)stmt, this.scope);
                StringBuilder sb = new StringBuilder();
                int cnt = 0;
                for (TypeMirror tm : tu.getUncaughtExceptions(new TreePath(path, ((TryTree)path.getLeaf()).getBlock()))) {
                    sb.append("catch (");
                    sb.append("${_GEN_UCE_TYPE_" + cnt++ + " type=" + Utilities.getTypeName(this.cInfo, tm, true) + " default=" + Utilities.getTypeName(this.cInfo, tm, false) + "}");
                    sb.append(" ${_GEN_UCE_NAME_" + cnt++ + " newVarName}){}");
                }
                if (sb.length() <= 0) continue;
                StringBuilder ptBuilder = new StringBuilder(this.request.getParametrizedText());
                ptBuilder.replace(parameter.getParametrizedTextStartOffset(), parameter.getParametrizedTextEndOffset(), sb.toString());
                this.request.setParametrizedText(ptBuilder.toString());
            }
        }
    }

    private void updateTemplateBasedOnSelection() {
        block0: for (CodeTemplateParameter parameter : this.request.getAllParameters()) {
            int idx;
            TreePath treePath;
            Tree tree;
            if (!"selection".equals(parameter.getName())) continue;
            JTextComponent component = this.request.getComponent();
            if (component.getSelectionStart() == component.getSelectionEnd() || this.cInfo == null) break;
            TreeUtilities tu = this.cInfo.getTreeUtilities();
            StatementTree stat = tu.parseStatement(this.request.getInsertText(), null);
            EnumSet<Tree.Kind[]> kinds = EnumSet.of(Tree.Kind.BLOCK, new Tree.Kind[]{Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.IF, Tree.Kind.SYNCHRONIZED, Tree.Kind.TRY, Tree.Kind.WHILE_LOOP});
            if (stat == null || !kinds.contains((Object)stat.getKind()) || (tree = (treePath = tu.pathFor(component.getSelectionStart())).getLeaf()).getKind() != Tree.Kind.BLOCK || tree != tu.pathFor(component.getSelectionEnd()).getLeaf()) break;
            String selection = component.getSelectedText();
            for (idx = 0; idx < selection.length() && selection.charAt(idx) <= ' '; ++idx) {
            }
            StringBuilder selectionText = new StringBuilder(parameter.getValue());
            int caretOffset = component.getSelectionStart() + idx;
            final StringBuilder sb = new StringBuilder();
            final Trees trees = this.cInfo.getTrees();
            SourcePositions sp = trees.getSourcePositions();
            final HashMap<VariableElement, VariableTree> vars = new HashMap<VariableElement, VariableTree>();
            LinkedList<VariableTree> varList = new LinkedList<VariableTree>();
            TreePathScanner scanner = new TreePathScanner(){
                private int cnt = 0;

                @Override
                public Object visitIdentifier(IdentifierTree node, Object p) {
                    VariableTree var;
                    Element e = trees.getElement(this.getCurrentPath());
                    if (e != null && (var = (VariableTree)vars.remove(e)) != null) {
                        sb.append(var.getType()).append(' ').append(var.getName());
                        TypeMirror tm = ((VariableElement)e).asType();
                        switch (tm.getKind()) {
                            case ARRAY: 
                            case DECLARED: {
                                sb.append(" = ${_GEN_PARAM_" + this.cnt++ + " default=\"null\"}");
                                break;
                            }
                            case BOOLEAN: {
                                sb.append(" = ${_GEN_PARAM_" + this.cnt++ + " default=\"false\"}");
                                break;
                            }
                            case BYTE: 
                            case CHAR: 
                            case DOUBLE: 
                            case FLOAT: 
                            case INT: 
                            case LONG: 
                            case SHORT: {
                                sb.append(" = ${_GEN_PARAM_" + this.cnt++ + " default=\"0\"}");
                            }
                        }
                        sb.append(";\n");
                    }
                    return null;
                }
            };
            for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                if (sp.getStartPosition(this.cInfo.getCompilationUnit(), statementTree) < (long)component.getSelectionStart()) continue;
                if (sp.getEndPosition(this.cInfo.getCompilationUnit(), statementTree) <= (long)component.getSelectionEnd()) {
                    Element e;
                    if (statementTree.getKind() != Tree.Kind.VARIABLE || (e = trees.getElement(new TreePath(treePath, statementTree))) == null || e.getKind() != ElementKind.LOCAL_VARIABLE) continue;
                    vars.put((VariableElement)e, (VariableTree)statementTree);
                    varList.addFirst((VariableTree)statementTree);
                    continue;
                }
                scanner.scan(new TreePath(treePath, statementTree), null);
            }
            Collection vals = vars.values();
            for (VariableTree var : varList) {
                if (vals.contains(var)) continue;
                int start = (int)sp.getStartPosition(this.cInfo.getCompilationUnit(), var) - caretOffset;
                int end = (int)sp.getEndPosition(this.cInfo.getCompilationUnit(), var.getType()) - caretOffset;
                selectionText.delete(start, end);
            }
            if (sb.length() <= 0) break;
            this.request.setParametrizedText(sb.toString() + this.request.getParametrizedText());
            for (CodeTemplateParameter p : this.request.getAllParameters()) {
                if (!"selection".equals(p.getName())) continue;
                p.setValue(selectionText.toString());
                break block0;
            }
        }
    }

    private void updateImports() {
        if (!this.param2types.isEmpty()) {
            AutoImport imp = AutoImport.get(this.cInfo);
            for (Map.Entry<CodeTemplateParameter, TypeMirror> entry : this.param2types.entrySet()) {
                CodeTemplateParameter param = entry.getKey();
                TypeMirror tm = this.param2types.get(param);
                TreePath tp = this.cInfo.getTreeUtilities().pathFor(this.caretOffset + param.getInsertTextOffset());
                CharSequence typeName = imp.resolveImport(tp, tm);
                if (CAST.equals(this.param2hints.get(param))) {
                    param.setValue("(" + typeName + ")");
                    continue;
                }
                if (INSTANCE_OF.equals(this.param2hints.get(param))) {
                    String value = param.getValue().substring(param.getValue().lastIndexOf(46) + 1);
                    param.setValue(typeName + "." + value);
                    continue;
                }
                param.setValue(((Object)typeName).toString());
            }
        }
    }

    private String getProposedValue(CodeTemplateParameter param) {
        this.param2hints.remove(param);
        this.param2types.remove(param);
        String name = null;
        for (Map.Entry e : param.getHints().entrySet()) {
            String value;
            TypeMirror tm;
            VariableElement ve;
            Map.Entry entry = e;
            if (INSTANCE_OF.equals(entry.getKey())) {
                ve = this.instanceOf((String)entry.getValue(), name);
                if (ve != null) {
                    this.param2hints.put(param, INSTANCE_OF);
                    return ve.getSimpleName().toString();
                }
                if (name == null) continue;
                ve = this.staticInstanceOf((String)entry.getValue(), name);
                if (ve != null) {
                    this.param2hints.put(param, INSTANCE_OF);
                    TypeMirror tm2 = ve.getEnclosingElement().asType();
                    tm2 = this.cInfo.getTypes().erasure(tm2);
                    if (this.containsDeclaredType(tm2)) {
                        this.param2types.put(param, tm2);
                    }
                    return Utilities.getTypeName(this.cInfo, tm2, true) + "." + ve.getSimpleName();
                }
                return this.valueOf((String)entry.getValue());
            }
            if (ARRAY.equals(entry.getKey())) {
                ve = this.array();
                if (ve == null) continue;
                this.param2hints.put(param, ARRAY);
                return ve.getSimpleName().toString();
            }
            if (ITERABLE.equals(entry.getKey())) {
                ve = this.iterable();
                if (ve == null) continue;
                this.param2hints.put(param, ITERABLE);
                return ve.getSimpleName().toString();
            }
            if (TYPE.equals(entry.getKey())) {
                TypeParameterElement tpe;
                tm = this.type((String)entry.getValue());
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (name != null && (tpe = this.typeVar(tm, name)) != null) {
                    return tpe.getSimpleName().toString();
                }
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
                this.param2hints.put(param, TYPE);
                if (this.containsDeclaredType(tm)) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (TYPE_VAR.equals(entry.getKey())) {
                name = (String)entry.getValue();
                continue;
            }
            if (ITERABLE_ELEMENT_TYPE.equals(entry.getKey())) {
                tm = this.iterableElementType(param.getInsertTextOffset() + 1);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
                this.param2hints.put(param, ITERABLE_ELEMENT_TYPE);
                if (this.containsDeclaredType(tm)) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (LEFT_SIDE_TYPE.equals(entry.getKey())) {
                tm = this.assignmentSideType(param.getInsertTextOffset() + 1, true);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
                this.param2hints.put(param, LEFT_SIDE_TYPE);
                if (this.containsDeclaredType(tm)) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (RIGHT_SIDE_TYPE.equals(entry.getKey())) {
                tm = this.assignmentSideType(param.getInsertTextOffset() + 1, false);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
                this.param2hints.put(param, RIGHT_SIDE_TYPE);
                if (this.containsDeclaredType(tm)) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (CAST.equals(entry.getKey())) {
                tm = this.cast(param.getInsertTextOffset() + 1);
                if (tm == null) {
                    this.param2hints.put(param, CAST);
                    this.param2types.remove(param);
                    return "";
                }
                if (tm.getKind() == TypeKind.ERROR || (value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
                this.param2hints.put(param, CAST);
                if (this.containsDeclaredType(tm)) {
                    this.param2types.put(param, tm);
                }
                return "(" + value + ")";
            }
            if (NEW_VAR_NAME.equals(entry.getKey())) {
                this.param2hints.put(param, NEW_VAR_NAME);
                return this.newVarName(param.getInsertTextOffset() + 1);
            }
            if (CURRENT_CLASS_NAME.equals(entry.getKey())) {
                this.param2hints.put(param, CURRENT_CLASS_NAME);
                return this.owningClassName();
            }
            if (NAMED.equals(entry.getKey())) {
                name = param.getName();
                continue;
            }
            if (!UNCAUGHT_EXCEPTION_TYPE.equals(entry.getKey()) || (tm = this.uncaughtExceptionType(param.getInsertTextOffset() + 1)) == null || tm.getKind() == TypeKind.ERROR) continue;
            if (tm.getKind() == TypeKind.TYPEVAR) {
                tm = ((TypeVariable)tm).getUpperBound();
            }
            if ((value = ((Object)Utilities.getTypeName(this.cInfo, tm, true)).toString()) == null) continue;
            this.param2hints.put(param, UNCAUGHT_EXCEPTION_TYPE);
            if (this.containsDeclaredType(tm)) {
                this.param2types.put(param, tm);
            }
            return value;
        }
        return name;
    }

    private VariableElement instanceOf(String typeName, String name) {
        try {
            if (this.cInfo != null) {
                TypeMirror type = this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass);
                VariableElement closest = null;
                int distance = Integer.MAX_VALUE;
                if (type != null) {
                    Types types = this.cInfo.getTypes();
                    for (Element e : this.locals) {
                        if (!(e instanceof VariableElement) || ERROR.contentEquals(e.getSimpleName()) || !types.isAssignable(e.asType(), type)) continue;
                        if (name == null) {
                            return (VariableElement)e;
                        }
                        int d = ElementHeaders.getDistance((String)e.getSimpleName().toString(), (String)name);
                        if (types.isSameType(e.asType(), type)) {
                            d -= 1000;
                        }
                        if (d >= distance) continue;
                        distance = d;
                        closest = (VariableElement)e;
                    }
                }
                return closest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement staticInstanceOf(String typeName, String name) {
        try {
            if (this.cInfo != null) {
                final TreeUtilities tu = this.cInfo.getTreeUtilities();
                TypeMirror type = tu.parseType(typeName, this.enclClass);
                VariableElement closest = null;
                int distance = Integer.MAX_VALUE;
                if (type != null) {
                    final Types types = this.cInfo.getTypes();
                    if (type.getKind() == TypeKind.DECLARED) {
                        final DeclaredType dType = (DeclaredType)type;
                        TypeElement element = (TypeElement)dType.asElement();
                        final boolean isStatic = element.getKind().isClass() || element.getKind().isInterface();
                        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element e, TypeMirror t) {
                                return e.getKind().isField() && !JavaCodeTemplateProcessor.ERROR.contentEquals(e.getSimpleName()) && !JavaCodeTemplateProcessor.CLASS.contentEquals(e.getSimpleName()) && (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && tu.isAccessible(JavaCodeTemplateProcessor.this.scope, e, t) && (e.getKind().isField() && types.isAssignable(((VariableElement)e).asType(), dType) || e.getKind() == ElementKind.METHOD && types.isAssignable(((ExecutableElement)e).getReturnType(), dType));
                            }
                        };
                        for (Element ee : this.cInfo.getElementUtilities().getMembers((TypeMirror)dType, acceptor)) {
                            if (name == null) {
                                return (VariableElement)ee;
                            }
                            int d = ElementHeaders.getDistance((String)ee.getSimpleName().toString(), (String)name);
                            if (ee.getKind().isField() && types.isSameType(((VariableElement)ee).asType(), dType) || ee.getKind() == ElementKind.METHOD && types.isSameType(((ExecutableElement)ee).getReturnType(), dType)) {
                                d -= 1000;
                            }
                            if (d >= distance) continue;
                            distance = d;
                            closest = (VariableElement)ee;
                        }
                    }
                }
                return closest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeParameterElement typeVar(TypeMirror type, String name) {
        try {
            if (this.cInfo != null) {
                TypeParameterElement closest = null;
                int distance = Integer.MAX_VALUE;
                if (type != null) {
                    Types types = this.cInfo.getTypes();
                    for (Element e : this.typeVars) {
                        if (!(e instanceof TypeParameterElement) || ERROR.contentEquals(e.getSimpleName()) || !types.isAssignable(e.asType(), type)) continue;
                        int d = ElementHeaders.getDistance((String)e.getSimpleName().toString(), (String)name);
                        if (types.isSameType(e.asType(), type)) {
                            d -= 1000;
                        }
                        if (d >= distance) continue;
                        distance = d;
                        closest = (TypeParameterElement)e;
                    }
                }
                return closest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String valueOf(String typeName) {
        try {
            TypeMirror type;
            if (this.cInfo != null && (type = this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass)) != null) {
                if (type.getKind() == TypeKind.DECLARED) {
                    return NULL;
                }
                if (type.getKind() == TypeKind.BOOLEAN) {
                    return TRUE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement array() {
        if (this.cInfo != null) {
            for (Element e : this.locals) {
                if (!(e instanceof VariableElement) || ERROR.contentEquals(e.getSimpleName()) || e.asType().getKind() != TypeKind.ARRAY) continue;
                return (VariableElement)e;
            }
        }
        return null;
    }

    private VariableElement iterable() {
        TypeElement iterableTE;
        if (this.cInfo != null && (iterableTE = this.cInfo.getElements().getTypeElement("java.lang.Iterable")) != null) {
            DeclaredType iterableType = this.cInfo.getTypes().getDeclaredType(iterableTE, new TypeMirror[0]);
            for (Element e : this.locals) {
                if (!(e instanceof VariableElement) || ERROR.contentEquals(e.getSimpleName()) || e.asType().getKind() != TypeKind.ARRAY && !this.cInfo.getTypes().isAssignable(e.asType(), iterableType)) continue;
                return (VariableElement)e;
            }
        }
        return null;
    }

    private TypeMirror type(String typeName) {
        typeName = typeName.trim();
        return this.cInfo != null && typeName.length() > 0 ? this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass) : null;
    }

    private TypeMirror iterableElementType(int caretOffset) {
        try {
            if (this.cInfo != null) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset + 1, sourcePositions[0]);
                TreePath loop = Utilities.getPathElementOfKind(Tree.Kind.ENHANCED_FOR_LOOP, path);
                if (loop != null) {
                    tu.attributeTree((Tree)stmt, this.scope);
                    TypeMirror type = this.cInfo.getTrees().getTypeMirror(new TreePath(loop, ((EnhancedForLoopTree)loop.getLeaf()).getExpression()));
                    switch (type.getKind()) {
                        case ARRAY: {
                            type = ((ArrayType)type).getComponentType();
                            return type;
                        }
                        case DECLARED: {
                            Iterator<? extends TypeMirror> types = ((DeclaredType)type).getTypeArguments().iterator();
                            if (types.hasNext()) {
                                return types.next();
                            }
                            return this.cInfo.getElements().getTypeElement("java.lang.Object").asType();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror assignmentSideType(int caretOffset, boolean left) {
        try {
            if (this.cInfo != null) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset + 1, sourcePositions[0]);
                TreePath tree = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), path);
                if (tree == null) {
                    return null;
                }
                tu.attributeTree((Tree)stmt, this.scope);
                TypeMirror tm = null;
                if (tree.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree as = (AssignmentTree)tree.getLeaf();
                    TreePath type = new TreePath(tree, left ? as.getVariable() : as.getExpression());
                    tm = this.cInfo.getTrees().getTypeMirror(type);
                } else {
                    VariableTree vd = (VariableTree)tree.getLeaf();
                    TreePath type = new TreePath(tree, left ? vd.getType() : vd.getInitializer());
                    tm = this.cInfo.getTrees().getTypeMirror(type);
                }
                if (tm != null && tm.getKind() == TypeKind.ERROR) {
                    tm = this.cInfo.getTrees().getOriginalType((ErrorType)tm);
                }
                if (tm.getKind() == TypeKind.NONE) {
                    tm = this.cInfo.getElements().getTypeElement("java.lang.Object").asType();
                }
                return tm;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror cast(int caretOffset) {
        try {
            if (this.cInfo != null) {
                TypeMirror right;
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset + 1, sourcePositions[0]);
                TreePath tree = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), path);
                if (tree == null) {
                    return null;
                }
                tu.attributeTree((Tree)stmt, this.scope);
                if (tree.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    TypeMirror right2;
                    AssignmentTree as = (AssignmentTree)tree.getLeaf();
                    TypeMirror left = this.cInfo.getTrees().getTypeMirror(new TreePath(tree, as.getVariable()));
                    if (left == null) {
                        return null;
                    }
                    TreePath exp = new TreePath(tree, as.getExpression());
                    if (exp.getLeaf() instanceof TypeCastTree) {
                        exp = new TreePath(exp, ((TypeCastTree)exp.getLeaf()).getExpression());
                    }
                    if ((right2 = this.cInfo.getTrees().getTypeMirror(exp)) == null) {
                        return null;
                    }
                    if (right2.getKind() == TypeKind.ERROR) {
                        right2 = this.cInfo.getTrees().getOriginalType((ErrorType)right2);
                    }
                    if (this.cInfo.getTypes().isAssignable(right2, left)) {
                        return null;
                    }
                    return left;
                }
                VariableTree vd = (VariableTree)tree.getLeaf();
                TypeMirror left = this.cInfo.getTrees().getTypeMirror(new TreePath(tree, vd.getType()));
                if (left == null) {
                    return null;
                }
                TreePath exp = new TreePath(tree, vd.getInitializer());
                if (exp.getLeaf() instanceof TypeCastTree) {
                    exp = new TreePath(exp, ((TypeCastTree)exp.getLeaf()).getExpression());
                }
                if ((right = this.cInfo.getTrees().getTypeMirror(exp)) == null) {
                    return null;
                }
                if (right.getKind() == TypeKind.ERROR) {
                    right = this.cInfo.getTrees().getOriginalType((ErrorType)right);
                }
                if (this.cInfo.getTypes().isAssignable(right, left) || !this.cInfo.getTypeUtilities().isCastable(right, left)) {
                    return null;
                }
                return left;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String newVarName(int caretOffset) {
        try {
            if (this.cInfo != null) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset + 1, sourcePositions[0]);
                TreePath decl = Utilities.getPathElementOfKind(Tree.Kind.VARIABLE, path);
                if (decl != null) {
                    Scope s = tu.attributeTreeTo((Tree)stmt, this.scope, decl.getLeaf());
                    TypeMirror type = this.cInfo.getTrees().getTypeMirror(decl);
                    boolean isConst = ((VariableTree)decl.getLeaf()).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.STATIC));
                    final Element element = this.cInfo.getTrees().getElement(decl);
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            switch (e.getKind()) {
                                case EXCEPTION_PARAMETER: 
                                case LOCAL_VARIABLE: 
                                case PARAMETER: {
                                    return element != e;
                                }
                            }
                            return false;
                        }
                    };
                    Iterator<String> names = Utilities.varNamesSuggestions(type, null, this.cInfo.getTypes(), this.cInfo.getElements(), this.cInfo.getElementUtilities().getLocalVars(s, acceptor), isConst).iterator();
                    if (names.hasNext()) {
                        return names.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String owningClassName() {
        try {
            if (this.cInfo != null) {
                TreePath path = Utilities.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, this.treePath);
                if (path != null) {
                    ClassTree tree = (ClassTree)path.getLeaf();
                    String result = tree.getSimpleName().toString();
                    return result;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror uncaughtExceptionType(int caretOffset) {
        try {
            if (this.cInfo != null) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement("{" + this.request.getInsertText() + "}", sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset + 1, sourcePositions[0]);
                if ((path = Utilities.getPathElementOfKind(Tree.Kind.TRY, path)) != null && ((TryTree)path.getLeaf()).getBlock() != null) {
                    tu.attributeTree((Tree)stmt, this.scope);
                    Iterator excs = tu.getUncaughtExceptions(new TreePath(path, ((TryTree)path.getLeaf()).getBlock())).iterator();
                    if (excs.hasNext()) {
                        return (TypeMirror)excs.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean containsDeclaredType(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return this.containsDeclaredType(((ArrayType)type).getComponentType());
            }
            case DECLARED: {
                return true;
            }
        }
        return false;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            JTextComponent c = this.request.getComponent();
            this.caretOffset = c.getSelectionStart();
            JavaSource js = JavaSource.forDocument((Document)c.getDocument());
            if (js != null) {
                try {
                    Future initTask = js.runWhenScanFinished((Task)new Task<CompilationController>(){

                        public void run(CompilationController c) throws IOException {
                            CompilationUnitTree cut;
                            Iterator<? extends Tree> it;
                            boolean isStatic;
                            if (JavaCodeTemplateProcessor.this.cInfo != null) {
                                return;
                            }
                            CompilationController controller = (CompilationController)JavaSourceUtil.createControllerHandle((FileObject)c.getSnapshot().getSource().getFileObject(), null).getCompilationController();
                            controller.toPhase(JavaSource.Phase.RESOLVED);
                            JavaCodeTemplateProcessor.this.cInfo = (CompilationInfo)controller;
                            final TreeUtilities tu = JavaCodeTemplateProcessor.this.cInfo.getTreeUtilities();
                            JavaCodeTemplateProcessor.this.treePath = tu.pathFor(JavaCodeTemplateProcessor.this.caretOffset);
                            JavaCodeTemplateProcessor.this.scope = tu.scopeFor(JavaCodeTemplateProcessor.this.caretOffset);
                            JavaCodeTemplateProcessor.this.enclClass = JavaCodeTemplateProcessor.this.scope.getEnclosingClass();
                            boolean bl = isStatic = JavaCodeTemplateProcessor.this.enclClass != null ? tu.isStaticContext(JavaCodeTemplateProcessor.this.scope) : false;
                            if (JavaCodeTemplateProcessor.this.enclClass == null && (it = (cut = JavaCodeTemplateProcessor.this.treePath.getCompilationUnit()).getTypeDecls().iterator()).hasNext()) {
                                JavaCodeTemplateProcessor.this.enclClass = (TypeElement)JavaCodeTemplateProcessor.this.cInfo.getTrees().getElement(TreePath.getPath(cut, it.next()));
                            }
                            Trees trees = controller.getTrees();
                            SourcePositions sp = trees.getSourcePositions();
                            final Collection<? extends Element> illegalForwardRefs = Utilities.getForwardReferences(JavaCodeTemplateProcessor.this.treePath, JavaCodeTemplateProcessor.this.caretOffset, sp, trees);
                            final HashSet<Name> illegalForwardRefNames = new HashSet<Name>();
                            for (Element element : illegalForwardRefs) {
                                if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.EXCEPTION_PARAMETER && element.getKind() != ElementKind.PARAMETER) continue;
                                illegalForwardRefNames.add(element.getSimpleName());
                            }
                            final ExecutableElement method = JavaCodeTemplateProcessor.this.scope.getEnclosingMethod();
                            ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                                public boolean accept(Element e, TypeMirror t) {
                                    switch (e.getKind()) {
                                        case TYPE_PARAMETER: {
                                            return true;
                                        }
                                        case EXCEPTION_PARAMETER: 
                                        case LOCAL_VARIABLE: 
                                        case PARAMETER: {
                                            return (method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL)) && !illegalForwardRefNames.contains(e.getSimpleName());
                                        }
                                        case FIELD: {
                                            if (e.getSimpleName().contentEquals("this")) {
                                                return !isStatic;
                                            }
                                            if (e.getSimpleName().contentEquals("super")) {
                                                return false;
                                            }
                                            if (!illegalForwardRefs.contains(e)) break;
                                            return false;
                                        }
                                    }
                                    return (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && tu.isAccessible(JavaCodeTemplateProcessor.this.scope, e, t);
                                }
                            };
                            JavaCodeTemplateProcessor.this.locals = new ArrayList();
                            JavaCodeTemplateProcessor.this.typeVars = new ArrayList();
                            block4: for (Element element : JavaCodeTemplateProcessor.this.cInfo.getElementUtilities().getLocalMembersAndVars(JavaCodeTemplateProcessor.this.scope, elementAcceptor)) {
                                switch (element.getKind()) {
                                    case TYPE_PARAMETER: {
                                        JavaCodeTemplateProcessor.this.typeVars.add(element);
                                        continue block4;
                                    }
                                }
                                JavaCodeTemplateProcessor.this.locals.add(element);
                            }
                        }
                    }, true);
                    if (!initTask.isDone()) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.cInfo != null;
    }

    private static class ErrChecker
    extends TreeScanner<Void, Void> {
        private boolean containsErrors;

        private ErrChecker() {
        }

        public boolean containsErrors(Tree tree) {
            this.containsErrors = false;
            this.scan(tree, null);
            return this.containsErrors;
        }

        @Override
        public Void visitErroneous(ErroneousTree node, Void p) {
            this.containsErrors = true;
            return null;
        }

        @Override
        public Void scan(Tree node, Void p) {
            if (this.containsErrors) {
                return null;
            }
            return (Void)super.scan(node, p);
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new JavaCodeTemplateProcessor(request);
        }
    }
}

