/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ConnectionAction
extends SQLExecutionBaseAction {
    @Override
    protected String getDisplayName(SQLExecution sqlExecution) {
        return NbBundle.getMessage(ConnectionAction.class, (String)"LBL_DatabaseConnection");
    }

    @Override
    protected void actionPerformed(SQLExecution sqlExecution) {
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConnectionContextAwareDelegate(this, actionContext);
    }

    private static final class DatabaseConnectionRenderer
    extends DefaultListCellRenderer {
        private DatabaseConnectionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object displayName = null;
            String tooltipText = null;
            if (value instanceof DatabaseConnection) {
                DatabaseConnection dbconn = (DatabaseConnection)value;
                tooltipText = dbconn.getDisplayName();
                displayName = tooltipText;
            } else {
                displayName = value;
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            component.setToolTipText(tooltipText);
            return component;
        }
    }

    private static final class DatabaseConnectionModel
    extends AbstractListModel
    implements ComboBoxModel,
    ConnectionListener,
    PropertyChangeListener {
        private ConnectionListener listener = (ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, (Object)ConnectionManager.getDefault());
        private List<DatabaseConnection> connectionList;
        private SQLExecution sqlExecution;

        public DatabaseConnectionModel() {
            ConnectionManager.getDefault().addConnectionListener(this.listener);
            this.connectionList = new ArrayList<DatabaseConnection>();
            this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
            this.sortConnections();
        }

        @Override
        public Object getElementAt(int index) {
            return this.connectionList.get(index);
        }

        @Override
        public int getSize() {
            return this.connectionList.size();
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.sqlExecution != null) {
                this.sqlExecution.setDatabaseConnection((DatabaseConnection)object);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.sqlExecution != null ? this.sqlExecution.getDatabaseConnection() : null;
        }

        public void setSQLExecution(SQLExecution sqlExecution) {
            if (this.sqlExecution != null) {
                this.sqlExecution.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.sqlExecution = sqlExecution;
            if (this.sqlExecution != null) {
                this.sqlExecution.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.fireContentsChanged(this, 0, 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == null || propertyName.equals("databaseConnection")) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        DatabaseConnectionModel.this.fireContentsChanged(this, 0, 0);
                    }
                });
            }
        }

        public void connectionsChanged() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    DatabaseConnectionModel.this.connectionList.clear();
                    DatabaseConnectionModel.this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
                    DatabaseConnectionModel.this.sortConnections();
                    DatabaseConnection selectedItem = (DatabaseConnection)DatabaseConnectionModel.this.getSelectedItem();
                    if (selectedItem != null && !DatabaseConnectionModel.this.connectionList.contains(selectedItem)) {
                        DatabaseConnectionModel.this.setSelectedItem(null);
                    }
                    DatabaseConnectionModel.this.fireContentsChanged(this, 0, DatabaseConnectionModel.this.connectionList.size());
                }
            });
        }

        void sortConnections() {
            Collections.sort(this.connectionList, new Comparator<DatabaseConnection>(){

                @Override
                public int compare(DatabaseConnection o1, DatabaseConnection o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
        }
    }

    private static final class ToolbarPresenter
    extends JPanel {
        private final Lookup actionContext;
        private JComboBox combo;
        private JLabel comboLabel;
        private DatabaseConnectionModel model;
        private boolean waiting;
        private SQLExecution waitingSQLExecution = null;
        private static final RequestProcessor RP = new RequestProcessor(ToolbarPresenter.class);

        public ToolbarPresenter(Lookup actionContext) {
            this.initComponents();
            this.waiting = true;
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ToolbarPresenter.this.model = new DatabaseConnectionModel();
                    if (ToolbarPresenter.this.waitingSQLExecution != null) {
                        ToolbarPresenter.this.model.setSQLExecution(ToolbarPresenter.this.waitingSQLExecution);
                        ToolbarPresenter.this.waitingSQLExecution = null;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ToolbarPresenter.this.waiting = false;
                            ToolbarPresenter.this.combo.setModel(ToolbarPresenter.this.model);
                            ToolbarPresenter.this.setEnabled(true);
                        }
                    });
                }
            });
            this.actionContext = actionContext;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            int minWidth = this.comboLabel.getWidth() * 2;
            return new Dimension(minWidth, dim.height);
        }

        public void setSQLExecution(SQLExecution sqlExecution) {
            if (this.model != null) {
                this.model.setSQLExecution(sqlExecution);
            } else {
                this.waitingSQLExecution = sqlExecution;
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(4, 0));
            this.setBorder(new EmptyBorder(0, 2, 0, 8));
            this.setOpaque(false);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    JEditorPane[] panes;
                    if (!SwingUtilities.isEventDispatchThread()) {
                        return null;
                    }
                    EditorCookie ec = (EditorCookie)ToolbarPresenter.this.actionContext.lookup(EditorCookie.class);
                    if (ec != null && (panes = ec.getOpenedPanes()) != null) {
                        for (JEditorPane pane : panes) {
                            if (!pane.isShowing()) continue;
                            return pane;
                        }
                    }
                    return null;
                }
            });
            this.combo = new JComboBox();
            this.combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DatabaseConnection dbconn = (DatabaseConnection)ToolbarPresenter.this.combo.getSelectedItem();
                    ToolbarPresenter.this.combo.setToolTipText(dbconn != null ? dbconn.getDisplayName() : null);
                }
            });
            this.combo.setOpaque(false);
            this.combo.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(ToolbarPresenter.class, (String)"ConnectionAction.ToolbarPresenter.LoadingConnections")}));
            this.setEnabled(false);
            this.combo.setRenderer(new DatabaseConnectionRenderer());
            String accessibleName = NbBundle.getMessage(ConnectionAction.class, (String)"LBL_DatabaseConnection");
            this.combo.getAccessibleContext().setAccessibleName(accessibleName);
            this.combo.getAccessibleContext().setAccessibleDescription(accessibleName);
            this.combo.setPreferredSize(new Dimension(400, this.combo.getPreferredSize().height));
            this.add((Component)this.combo, "Center");
            this.comboLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.comboLabel, (String)NbBundle.getMessage(ConnectionAction.class, (String)"LBL_ConnectionAction"));
            this.comboLabel.setOpaque(false);
            this.comboLabel.setLabelFor(this.combo);
            this.add((Component)this.comboLabel, "West");
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.combo.setEnabled(enabled && !this.waiting);
            super.setEnabled(enabled && !this.waiting);
        }
    }

    private static final class ConnectionContextAwareDelegate
    extends SQLExecutionBaseAction.ContextAwareDelegate {
        private final Lookup actionContext;
        private ToolbarPresenter toolbarPresenter;

        public ConnectionContextAwareDelegate(ConnectionAction parent, Lookup actionContext) {
            super(parent, actionContext);
            this.actionContext = actionContext;
        }

        @Override
        public Component getToolbarPresenter() {
            this.toolbarPresenter = new ToolbarPresenter(this.actionContext);
            this.toolbarPresenter.setSQLExecution(this.getSQLExecution());
            return this.toolbarPresenter;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.toolbarPresenter != null) {
                this.toolbarPresenter.setEnabled(enabled);
            }
            super.setEnabled(enabled);
        }

        @Override
        protected void setSQLExecution(final SQLExecution sqlExecution) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (ConnectionContextAwareDelegate.this.toolbarPresenter != null) {
                        ConnectionContextAwareDelegate.this.toolbarPresenter.setSQLExecution(sqlExecution);
                    }
                }
            });
            super.setSQLExecution(sqlExecution);
        }
    }
}

