/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbCollections;

public final class ProjectTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_LICENSE = "license";
    private static final String ATTR_ENCODING = "encoding";

    public Map<String, ? extends Object> attributesFor(DataObject template, DataFolder target, String name) {
        Project prj = FileOwnerQuery.getOwner((FileObject)target.getPrimaryFile());
        HashMap all = null;
        if (prj != null) {
            for (CreateFromTemplateAttributesProvider attrs : prj.getLookup().lookupAll(CreateFromTemplateAttributesProvider.class)) {
                Map m = attrs.attributesFor(template, target, name);
                if (m == null) continue;
                if (all == null) {
                    all = new HashMap();
                }
                all.putAll(m);
            }
        }
        return ProjectTemplateAttributesProvider.checkProjectAttrs(all, target.getPrimaryFile());
    }

    static Map<String, ? extends Object> checkProjectAttrs(Map<String, Object> m, FileObject parent) {
        Object prjAttrObj;
        Object object = prjAttrObj = m != null ? m.get(ATTR_PROJECT) : null;
        if (prjAttrObj instanceof Map) {
            Map prjAttrs = NbCollections.checkedMapByFilter((Map)((Map)prjAttrObj), String.class, Object.class, (boolean)false);
            if (prjAttrs.get(ATTR_LICENSE) == null || prjAttrs.get(ATTR_ENCODING) == null) {
                HashMap<String, Object> newPrjAttrs = new HashMap<String, Object>(prjAttrs);
                m.put(ATTR_PROJECT, newPrjAttrs);
                ProjectTemplateAttributesProvider.ensureProjectAttrs(newPrjAttrs, parent);
            }
            return m;
        }
        if (prjAttrObj != null) {
            return m;
        }
        HashMap<String, Object> projectMap = new HashMap<String, Object>();
        ProjectTemplateAttributesProvider.ensureProjectAttrs(projectMap, parent);
        if (m != null) {
            m.put(ATTR_PROJECT, projectMap);
            return m;
        }
        return Collections.singletonMap(ATTR_PROJECT, projectMap);
    }

    private static void ensureProjectAttrs(Map<String, Object> map, FileObject parent) {
        if (map.get(ATTR_LICENSE) == null) {
            map.put(ATTR_LICENSE, "default");
        }
        if (map.get(ATTR_ENCODING) == null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)parent);
            String encoding = charset != null ? charset.name() : "UTF-8";
            map.put(ATTR_ENCODING, encoding);
        }
    }
}

