/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.html.parser.model.ContentType;
import org.netbeans.modules.html.parser.model.ElementDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescriptorRules {
    private static final Map<ContentType, Collection<ElementDescriptor>> CONTENTTYPE2ELEMENTS = new EnumMap<ContentType, Collection<ElementDescriptor>>(ContentType.class);
    public static final Collection<ElementDescriptor> OPTIONAL_OPEN_TAGS = EnumSet.of(ElementDescriptor.HTML, ElementDescriptor.HEAD, ElementDescriptor.BODY, ElementDescriptor.COLGROUP, ElementDescriptor.TBODY);
    public static final Collection<ElementDescriptor> OPTIONAL_END_TAGS = EnumSet.of(ElementDescriptor.HTML, new ElementDescriptor[]{ElementDescriptor.HEAD, ElementDescriptor.BODY, ElementDescriptor.LI, ElementDescriptor.DT, ElementDescriptor.DD, ElementDescriptor.P, ElementDescriptor.RP, ElementDescriptor.RT, ElementDescriptor.OPTGROUP, ElementDescriptor.OPTION, ElementDescriptor.COLGROUP, ElementDescriptor.THEAD, ElementDescriptor.TBODY, ElementDescriptor.TFOOT, ElementDescriptor.TR, ElementDescriptor.TH, ElementDescriptor.TD});
    public static final Collection<String> MATHML_TAG_NAMES = new HashSet<String>(Arrays.asList("abs", "and", "annotation", "annotation-xml", "apply", "approx", "arccos", "arccosh", "arccot", "arccoth", "arccsc", "arccsch", "arcsec", "arcsech", "arcsin", "arcsinh", "arctan", "arctanh", "arg", "bvar", "card", "cartesianproduct", "ceiling", "ci", "cn", "codomain", "complexes", "compose", "condition", "conjugate", "cos", "cosh", "cot", "coth", "csc", "csch", "csymbol", "curl", "declare", "degree", "determinant", "diff", "divergence", "divide", "domain", "domainofapplication", "emptyset", "encoding", "eq", "equivalent", "eulergamma", "exists", "exp", "exponentiale", "factorial", "factorof", "false", "floor", "fn", "forall", "function", "gcd", "geq", "grad", "gt", "ident", "image", "imaginary", "imaginaryi", "implies", "in", "infinity", "int", "integers", "intersect", "interval", "inverse", "lambda", "laplacian", "lcm", "leq", "limit", "list", "ln", "log", "logbase", "lowlimit", "lt", "apply", "mrow", "maction", "malign", "maligngroup", "malignmark", "malignscope", "math", "matrix", "matrixrow", "max", "mean", "median", "menclose", "merror", "mfenced", "mfrac", "mfraction", "mglyph", "mi", "min", "minus", "mlabeledtr", "mmultiscripts", "mn", "mo", "mode", "moment", "momentabout", "mover", "mpadded", "mphantom", "mprescripts", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msubsup", "msup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "naturalnumbers", "neq", "none", "not", "notanumber", "notin", "notprsubset", "notsubset", "or", "otherwise", "outerproduct", "partialdiff", "pi", "piece", "piecewice", "piecewise", "plus", "power", "primes", "product", "prsubset", "quotient", "rationals", "real", "reals", "reln", "rem", "root", "scalarproduct", "sdev", "sec", "sech", "selector", "semantics", "sep", "set", "setdiff", "sin", "sinh", "subset", "sum", "tan", "tanh", "tendsto", "times", "transpose", "true", "union", "uplimit", "variance", "vector", "vectorproduct", "xor"));
    public static final Collection<String> SVG_TAG_NAMES = new HashSet<String>(Arrays.asList("a", "animate", "animateColor", "animateMotion", "animateTransform", "animation", "audio", "circle", "defs", "desc", "discard", "ellipse", "font", "font-face", "font-face-src", "font-face-uri", "foreignObject", "g", "glyph", "handler", "hkern", "image", "line", "linearGradient", "listener", "metadata", "missing-glyph", "mpath", "path", "polygon", "polyline", "prefetch", "radialGradient", "rect", "script", "set", "solidColor", "stop", "svg", "switch", "tbreak", "text", "textArea", "title", "tspan", "use", "video"));

    public static synchronized Collection<ElementDescriptor> getElementsByContentType(ContentType ctype) {
        Collection<ElementDescriptor> members = CONTENTTYPE2ELEMENTS.get((Object)ctype);
        if (members == null) {
            members = new LinkedList<ElementDescriptor>();
            for (ElementDescriptor ed : ElementDescriptor.values()) {
                if (!ed.getCategoryTypes().contains((Object)ctype)) continue;
                members.add(ed);
            }
            CONTENTTYPE2ELEMENTS.put(ctype, members);
        }
        return members;
    }
}

