/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.modules.project.libraries.LibrariesStorage;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibraryDeclarationHandlerImpl
implements LibraryDeclarationHandler {
    private LibraryImplementation library;
    private String libraryType;
    private String libraryDescription;
    private String libraryName;
    private String localizingBundle;
    private Map<String, List<URL>> contentTypes = new HashMap<String, List<URL>>();
    private List<URL> cpEntries;
    private String contentType;
    private boolean inVolume = false;
    private final AtomicBoolean used = new AtomicBoolean();

    @Override
    public void startDocument() {
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException("The LibraryDeclarationHandlerImpl was already used, create a new instance");
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void start_volume(Attributes meta) throws SAXException {
        this.cpEntries = new ArrayList<URL>();
        this.inVolume = true;
    }

    @Override
    public void end_volume() throws SAXException {
        this.contentTypes.put(this.contentType, this.cpEntries);
        this.inVolume = false;
        this.contentType = null;
    }

    @Override
    public void handle_type(String data, Attributes meta) throws SAXException {
        if (data == null || data.length() == 0) {
            throw new SAXException("Empty value of type element");
        }
        if (this.inVolume) {
            this.contentType = data;
        } else {
            this.libraryType = data;
        }
    }

    @Override
    public void start_library(Attributes meta) throws SAXException {
        if (!"1.0".equals(meta.getValue("version"))) {
            throw new SAXException("Invalid librray descriptor version");
        }
    }

    @Override
    public void end_library() throws SAXException {
        boolean update;
        if (this.library != null) {
            if (this.libraryType == null || !this.libraryType.equals(this.library.getType())) {
                throw new SAXParseException("Changing library type of library: " + this.libraryName + " from: " + this.library.getType() + " to: " + this.libraryType, null);
            }
            update = true;
        } else {
            if (this.libraryType == null) {
                throw new SAXParseException("Unspecified library type for: " + this.libraryName, null);
            }
            LibraryTypeProvider provider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(this.libraryType);
            if (provider == null) {
                throw new SAXParseException("LibraryDeclarationHandlerImpl: Cannot create library: " + this.libraryName + " of unknown type: " + this.libraryType, null);
            }
            this.library = provider.createLibrary();
            update = false;
            LibrariesStorage.LOG.log(Level.FINE, "LibraryDeclarationHandlerImpl library {0} type {1} found", new Object[]{this.libraryName, this.libraryType});
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getLocalizingBundle(), this.localizingBundle)) {
            this.library.setLocalizingBundle(this.localizingBundle);
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getName(), this.libraryName)) {
            this.library.setName(this.libraryName);
        }
        if (!update || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getDescription(), this.libraryDescription)) {
            this.library.setDescription(this.libraryDescription);
        }
        for (Map.Entry<String, List<URL>> entry : this.contentTypes.entrySet()) {
            String contentType = entry.getKey();
            List<URL> cp = entry.getValue();
            try {
                if (update && LibraryDeclarationHandlerImpl.urlsEqual(this.library.getContent(contentType), cp)) continue;
                this.library.setContent(contentType, cp);
            }
            catch (IllegalArgumentException e) {
                throw (SAXException)new SAXException(e.toString()).initCause(e);
            }
        }
    }

    @Override
    public void handle_resource(URL data, Attributes meta) throws SAXException {
        if (data != null) {
            this.cpEntries.add(data);
        }
    }

    @Override
    public void handle_name(String data, Attributes meta) throws SAXException {
        this.libraryName = data;
    }

    @Override
    public void handle_description(String data, Attributes meta) throws SAXException {
        this.libraryDescription = data;
    }

    @Override
    public void handle_localizingBundle(String data, Attributes meta) throws SAXException {
        this.localizingBundle = data;
    }

    public void setLibrary(LibraryImplementation library) {
        this.library = library;
    }

    public LibraryImplementation getLibrary() {
        return this.library;
    }

    private static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean urlsEqual(Collection<? extends URL> first, Collection<? extends URL> second) {
        assert (first != null);
        assert (second != null);
        if (first.size() != second.size()) {
            return false;
        }
        Iterator<? extends URL> fit = first.iterator();
        Iterator<? extends URL> sit = second.iterator();
        while (fit.hasNext()) {
            URL furl = fit.next();
            URL surl = sit.next();
            if (furl.toExternalForm().equals(surl.toExternalForm())) continue;
            return false;
        }
        return true;
    }
}

