/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.Versionable;

public final class PropertyDescriptor {
    private final String name;
    private final TypeID type;
    private final DefaultValueFactory defaultValueFactory;
    private final PropertyValue defaultValue;
    private final boolean allowNull;
    private final boolean allowUserCode;
    private final Versionable versionable;
    private final boolean useForSerialization;
    private final boolean readOnly;

    public PropertyDescriptor(String name, TypeID type, PropertyValue defaultValue, boolean allowNull, boolean allowUserCode, Versionable versionable) {
        this(name, type, defaultValue, allowNull, allowUserCode, versionable, true, false);
    }

    public PropertyDescriptor(String name, TypeID type, PropertyValue defaultValue, boolean allowNull, boolean allowUserCode, Versionable versionable, boolean useForSerialization, boolean readonly) {
        this(name, type, null, defaultValue, allowNull, allowUserCode, versionable, useForSerialization, readonly);
    }

    public PropertyDescriptor(String name, TypeID type, DefaultValueFactory defaultValueFactory, boolean allowNull, boolean allowUserCode, Versionable versionable, boolean useForSerialization, boolean readonly) {
        this(name, type, defaultValueFactory, null, allowNull, allowUserCode, versionable, useForSerialization, readonly);
    }

    private PropertyDescriptor(String name, TypeID type, DefaultValueFactory defaultValueFactory, PropertyValue defaultValue, boolean allowNull, boolean allowUserCode, Versionable versionable, boolean useForSerialization, boolean readonly) {
        assert (name != null && type != null && (defaultValueFactory != null || defaultValue != null)) : "Name, type, defaultValueFactory or defaultValue could be null in PropertyDescriptor : " + this;
        this.name = name;
        this.type = type;
        this.defaultValueFactory = defaultValueFactory;
        this.defaultValue = defaultValue;
        this.allowNull = allowNull;
        this.allowUserCode = allowUserCode;
        this.versionable = versionable;
        this.useForSerialization = useForSerialization;
        this.readOnly = readonly;
    }

    public String getName() {
        return this.name;
    }

    public TypeID getType() {
        return this.type;
    }

    public PropertyValue getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowUserCode() {
        return this.allowUserCode;
    }

    public Versionable getVersionable() {
        return this.versionable;
    }

    public boolean isUseForSerialization() {
        return this.useForSerialization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertyValue createDefaultValue(DesignComponent component, String propertyName) {
        return this.defaultValueFactory != null ? this.defaultValueFactory.createDefaultValue(component, propertyName) : this.defaultValue;
    }

    public static interface DefaultValueFactory {
        public PropertyValue createDefaultValue(DesignComponent var1, String var2);
    }
}

