/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.indicators.graph.GraphPanel;
import org.netbeans.modules.dlight.indicators.graph.Legend;
import org.netbeans.modules.dlight.indicators.graph.RepairPanel;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesIndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesPlot;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.spi.indicator.IndicatorActionsProvider;
import org.netbeans.modules.dlight.spi.indicator.PersistentIndicator;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class TimeSeriesIndicator
extends PersistentIndicator<TimeSeriesIndicatorConfiguration>
implements ViewportAware,
DataFilterListener {
    private static final Logger log = DLightLogger.getLogger(TimeSeriesIndicator.class);
    private final DataRowToTimeSeries dataRowHandler;
    private final TimeSeriesDataContainer data;
    private GraphPanel<TimeSeriesPlot, Legend> panel;
    private TimeSeriesPlot graph;
    private Legend legend;
    private final int timeSeriesCount;
    private int tickCounter;
    private List<Action> popupActions;
    private final TimeSeriesIndicatorConfiguration configuration;
    private final List<TimeSeriesDescriptor> timeSeriesList;
    private final List<DetailDescriptor> detailsList;
    private final DataTableMetadata timeSeriesTable;
    private final DataTableMetadata detailsTable;
    private volatile Map<String, String> detailsValues;

    public TimeSeriesIndicator(TimeSeriesIndicatorConfiguration configuration) {
        super((IndicatorConfiguration)configuration);
        this.configuration = configuration;
        TimeSeriesIndicatorConfigurationAccessor accessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
        this.dataRowHandler = accessor.getDataRowHandler(configuration);
        this.timeSeriesList = accessor.getTimeSeriesDescriptors(configuration);
        this.timeSeriesCount = this.timeSeriesList.size();
        this.data = new TimeSeriesDataContainer(accessor.getGranularity(configuration), accessor.getAggregation(configuration), this.timeSeriesCount, accessor.getLastNonNull(configuration));
        this.data.put(0L, new float[this.timeSeriesCount]);
        this.timeSeriesTable = TimeSeriesIndicator.createTimeSeriesTableMetadata(accessor.getPersistencePrefix(configuration), this.timeSeriesList);
        this.detailsList = accessor.getDetailDescriptors(configuration);
        this.detailsTable = TimeSeriesIndicator.createDetailsTableMetadata(accessor.getPersistencePrefix(configuration), this.detailsList);
        this.detailsValues = Collections.emptyMap();
    }

    protected void targetStarted() {
        this.legend.updateWithInfoProvided(this.getColumnsProvided());
    }

    private void initUI() {
        this.graph = TimeSeriesIndicator.createGraph(this.configuration, this.data);
        TimeSeriesIndicatorConfigurationAccessor accessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
        this.legend = new Legend(this.timeSeriesList, this.detailsList);
        this.panel = new GraphPanel<TimeSeriesPlot, Legend>(accessor.getTitle(this.configuration), this.graph, this.legend, this.graph.getHorizontalAxis(), this.graph.getVerticalAxis(), this.getActions());
        this.panel.setPopupActions(this.popupActions);
    }

    private static TimeSeriesPlot createGraph(TimeSeriesIndicatorConfiguration configuration, TimeSeriesDataContainer data) {
        TimeSeriesIndicatorConfigurationAccessor accessor = TimeSeriesIndicatorConfigurationAccessor.getDefault();
        TimeSeriesPlot graph = new TimeSeriesPlot(accessor.getGraphScale(configuration), accessor.getLabelFormatter(configuration), accessor.getTimeSeriesDescriptors(configuration), data);
        graph.setBorder(BorderFactory.createLineBorder(DLightUIPrefs.getColor((String)"indicator.border.color")));
        Dimension graphSize = new Dimension(DLightUIPrefs.getInt((String)"indicator.graph.width"), DLightUIPrefs.getInt((String)"indicator.graph.height"));
        graph.setMinimumSize(graphSize);
        graph.setPreferredSize(graphSize);
        Dimension valueAxisSize = new Dimension(DLightUIPrefs.getInt((String)"indicator.y_axis.width"), DLightUIPrefs.getInt((String)"indicator.y_axis.height"));
        graph.getVerticalAxis().setMinimumSize(valueAxisSize);
        graph.getVerticalAxis().setPreferredSize(valueAxisSize);
        Dimension timeAxisSize = new Dimension(DLightUIPrefs.getInt((String)"indicator.x_axis.width"), DLightUIPrefs.getInt((String)"indicator.x_axis.height"));
        graph.getHorizontalAxis().setMinimumSize(timeAxisSize);
        graph.getHorizontalAxis().setPreferredSize(timeAxisSize);
        return graph;
    }

    private static DataTableMetadata createTimeSeriesTableMetadata(String tablePrefix, List<TimeSeriesDescriptor> timeSeriesList) {
        DataTableMetadata table = null;
        if (!timeSeriesList.isEmpty()) {
            ArrayList<DataTableMetadata.Column> timeSeriesColumns = new ArrayList<DataTableMetadata.Column>(timeSeriesList.size());
            timeSeriesColumns.add(new DataTableMetadata.Column("timestamp", Long.class));
            for (TimeSeriesDescriptor timeSeries : timeSeriesList) {
                timeSeriesColumns.add(new DataTableMetadata.Column(TimeSeriesDescriptorAccessor.getDefault().getName(timeSeries), Float.class));
            }
            table = new DataTableMetadata(tablePrefix + "_series", timeSeriesColumns, null);
        }
        return table;
    }

    private static DataTableMetadata createDetailsTableMetadata(String tablePrefix, List<DetailDescriptor> detailsList) {
        DataTableMetadata table = null;
        if (!detailsList.isEmpty()) {
            List<DataTableMetadata.Column> detailsColumns = Arrays.asList(new DataTableMetadata.Column("name", String.class), new DataTableMetadata.Column("value", String.class));
            table = new DataTableMetadata(tablePrefix + "_details", detailsColumns, null);
        }
        return table;
    }

    public ViewportModel getViewportModel() {
        return this.graph.getViewportModel();
    }

    public void setViewportModel(ViewportModel viewportModel) {
        this.graph.setViewportModel(viewportModel);
    }

    protected void repairNeeded(boolean needed) {
        if (needed) {
            final RepairPanel repairPanel = new RepairPanel(this.getRepairActionProvider().getValidationStatus());
            repairPanel.setPopupActions(this.popupActions);
            repairPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final Future repairResult = TimeSeriesIndicator.this.getRepairActionProvider().asyncRepair();
                    DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            UIThread.invoke((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    repairPanel.setEnabled(false);
                                }
                            });
                            Boolean retValue = (Boolean)repairResult.get();
                            UIThread.invoke((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    repairPanel.setEnabled(true);
                                }
                            });
                            return retValue;
                        }
                    }, (String)"Click On Indicator task");
                }
            });
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimeSeriesIndicator.this.panel.setOverlay(repairPanel);
                }
            });
        } else {
            final JEditorPane label = UIUtilities.createJEditorPane((String)this.getRepairActionProvider().getMessage(this.getRepairActionProvider().getValidationStatus()), (boolean)false, (Color)DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    TimeSeriesIndicator.this.panel.setOverlay(label);
                }
            });
        }
    }

    protected void tick() {
        ++this.tickCounter;
        this.data.grow(this.tickCounter);
        this.detailsValues = this.dataRowHandler.getDetails();
        this.refresh();
    }

    public void updated(List<DataRow> rows) {
        for (DataRow row : rows) {
            try {
                float[] plotData = this.dataRowHandler.getData(row);
                if (plotData == null) continue;
                long realTimestamp = DataUtil.getTimestamp((DataRow)row);
                this.data.put(0L <= realTimestamp ? realTimestamp : 1000000000L * (long)this.tickCounter, plotData);
            }
            catch (Exception ex) {
                if (!log.isLoggable(Level.WARNING)) continue;
                log.log(Level.WARNING, "Exception while updating indicator", ex);
            }
        }
    }

    public void suggestRepaint() {
        this.refresh();
    }

    private void refresh() {
        for (Map.Entry<String, String> entry : this.detailsValues.entrySet()) {
            this.legend.updateDetail(entry.getKey(), entry.getValue());
        }
        this.graph.repaintAll();
    }

    public void reset() {
    }

    public synchronized JComponent getComponent() {
        if (this.panel == null) {
            this.initUI();
        }
        return this.panel;
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        this.graph.dataFiltersChanged(newSet, isAdjusting);
    }

    public void setIndicatorActionsProviderContext(Lookup context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (IndicatorActionsProvider actionsProvider : Lookup.getDefault().lookupAll(IndicatorActionsProvider.class)) {
            actions.addAll(actionsProvider.getIndicatorActions(context));
        }
        if (this.panel != null) {
            this.panel.setPopupActions(actions);
        }
        this.popupActions = actions;
    }

    public DataStorageType getDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getDataTableMetadata() {
        if (this.timeSeriesTable != null && this.detailsTable != null) {
            return Collections.unmodifiableList(Arrays.asList(this.timeSeriesTable, this.detailsTable));
        }
        if (this.timeSeriesTable != null) {
            return Collections.singletonList(this.timeSeriesTable);
        }
        if (this.detailsTable != null) {
            return Collections.singletonList(this.detailsTable);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initFromStorage(SQLDataStorage storage, String query) {
        if (1 < this.data.size()) {
            throw new IllegalStateException("Indicator must contain no data when loading");
        }
        if (this.timeSeriesTable != null) {
            try {
                ResultSet rs = storage.select(null, null, query);
                try {
                    while (rs.next()) {
                        long timestamp = rs.getLong(1);
                        float[] dataArray = new float[this.timeSeriesCount];
                        for (int i = 0; i < this.timeSeriesList.size(); ++i) {
                            dataArray[i] = rs.getFloat(TimeSeriesDescriptorAccessor.getDefault().getName(this.timeSeriesList.get(i)));
                        }
                        this.data.put(timestamp, dataArray);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadState(DataStorage storage) {
        if (1 < this.data.size()) {
            throw new IllegalStateException("Indicator must contain no data when loading");
        }
        SQLDataStorage sqlStorage = (SQLDataStorage)storage;
        if (this.timeSeriesTable != null) {
            try {
                ResultSet rs = sqlStorage.select(this.timeSeriesTable.getName(), this.timeSeriesTable.getColumns());
                try {
                    while (rs.next()) {
                        long timestamp = rs.getLong(1);
                        float[] dataArray = new float[this.timeSeriesCount];
                        for (int i = 0; i < this.timeSeriesList.size(); ++i) {
                            dataArray[i] = rs.getFloat(TimeSeriesDescriptorAccessor.getDefault().getName(this.timeSeriesList.get(i)));
                        }
                        this.data.put(timestamp, dataArray);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        if (this.detailsTable != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                ResultSet rs = sqlStorage.select(this.detailsTable.getName(), this.detailsTable.getColumns());
                try {
                    while (rs.next()) {
                        String key = rs.getString(1);
                        String value = rs.getString(2);
                        map.put(key, value);
                    }
                }
                finally {
                    rs.close();
                }
                this.detailsValues = map;
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public boolean saveState(DataStorage storage) {
        ArrayList<DataRow> dataRows;
        List columnNames;
        SQLDataStorage sqlStorage = (SQLDataStorage)storage;
        if (this.timeSeriesTable != null) {
            columnNames = this.timeSeriesTable.getColumnNames();
            dataRows = new ArrayList<DataRow>();
            for (int i = 0; i < this.data.size(); ++i) {
                float[] dataArray = this.data.get(i);
                if (dataArray == null) continue;
                ArrayList<Number> dataList = new ArrayList<Number>(1 + columnNames.size());
                dataList.add((long)i * TimeSeriesIndicatorConfigurationAccessor.getDefault().getGranularity(this.configuration));
                for (float x : dataArray) {
                    dataList.add(Float.valueOf(x));
                }
                dataRows.add(new DataRow(columnNames, dataList));
            }
            sqlStorage.syncAddData(this.timeSeriesTable.getName(), dataRows);
        }
        if (this.detailsTable != null) {
            columnNames = this.detailsTable.getColumnNames();
            dataRows = new ArrayList();
            for (Map.Entry<String, String> entry : this.detailsValues.entrySet()) {
                dataRows.add(new DataRow(columnNames, Arrays.asList(entry.getKey(), entry.getValue())));
            }
            sqlStorage.syncAddData(this.detailsTable.getName(), dataRows);
        }
        return true;
    }

    void dumpData(PrintStream out) {
        out.println("Time Series Data:");
        for (int i = 0; i < this.data.size(); ++i) {
            out.printf("%d =>", i);
            for (float x : this.data.get(i)) {
                out.printf(" %.2f", Float.valueOf(x));
            }
            out.println();
        }
        out.println("Details:");
        TreeSet<String> details = new TreeSet<String>(this.detailsValues.keySet());
        for (String detail : details) {
            out.printf("%s => %s\n", detail, this.detailsValues.get(detail));
        }
        out.flush();
    }
}

