/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.awt.Actions;

public class GraphPanel<G extends JComponent, L extends JComponent>
extends JLayeredPane {
    private static final Color BORDER_COLOR = DLightUIPrefs.getColor((String)"indicator.border.color");
    private static final int PADDING = DLightUIPrefs.getInt((String)"indicator.padding");
    private final G graph;
    private final L legend;
    private final JComponent hAxis;
    private final JComponent vAxis;
    private final List<Action> buttonActions = new ArrayList<Action>();
    private final List<Action> popupActions = new ArrayList<Action>();
    private final JComponent graphPanel;
    private JComponent overlay;

    public GraphPanel(String title, G graph, L legend, JComponent hAxis, JComponent vAxis, List<Action> actions) {
        this.graph = graph;
        this.legend = legend;
        this.hAxis = hAxis;
        this.vAxis = vAxis;
        this.buttonActions.addAll(actions);
        this.graphPanel = GraphPanel.createGraphPanel(title, graph, legend, hAxis, vAxis, this.buttonActions);
        this.graphPanel.addMouseListener(new PopupMenuListener());
        this.setOpaque(true);
        this.setMinimumSize(this.graphPanel.getMinimumSize());
        this.setPreferredSize(this.graphPanel.getPreferredSize());
        this.add((Component)this.graphPanel, (Object)0);
    }

    public void setPopupActions(List<Action> actions) {
        this.popupActions.clear();
        if (actions != null) {
            this.popupActions.addAll(actions);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.graphPanel.setToolTipText(text);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.graphPanel.getToolTipText();
    }

    private static JPanel createGraphPanel(String title, JComponent graph, JComponent legend, JComponent hAxis, JComponent vAxis, List<Action> actions) {
        JPanel graphPanel = new JPanel(new GridBagLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(title);
        label.setFont(DLightUIPrefs.getFont((String)"indicator.title.font"));
        label.setForeground(DLightUIPrefs.getColor((String)"indicator.title.font.color"));
        label.setHorizontalAlignment(2);
        label.setHorizontalTextPosition(2);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.insets = new Insets(0, 3, 0, 3);
        topPanel.add((Component)label, c);
        for (Action action : actions) {
            JButton btn = new JButton(action);
            c = new GridBagConstraints();
            c.insets = new Insets(0, 3, 0, 3);
            topPanel.add((Component)btn, c);
        }
        c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(PADDING, PADDING, 0, PADDING);
        graphPanel.add((Component)topPanel, c);
        if (vAxis != null) {
            c = new GridBagConstraints();
            c.fill = 3;
            c.weighty = 1.0;
            c.insets = new Insets(PADDING / 2, PADDING, hAxis == null ? PADDING : 0, 0);
            graphPanel.add((Component)vAxis, c);
        }
        graph.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(PADDING / 2, vAxis == null ? PADDING : 0, hAxis == null ? PADDING : 0, 0);
        graphPanel.add((Component)graph, c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.insets = new Insets(PADDING / 2, -1, hAxis == null ? PADDING : 0, PADDING);
        if (legend.isVisible()) {
            legend.setBackground(Color.WHITE);
            legend.setBorder(BorderFactory.createLineBorder(BORDER_COLOR));
            graphPanel.add((Component)legend, c);
        }
        if (hAxis != null) {
            c = new GridBagConstraints();
            c.gridx = vAxis == null ? 0 : 1;
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(0, vAxis == null ? PADDING : 0, PADDING, 0);
            graphPanel.add((Component)hAxis, c);
        }
        return graphPanel;
    }

    private JPopupMenu createPopupMenu() {
        if (this.popupActions.isEmpty()) {
            return null;
        }
        JPopupMenu pm = new JPopupMenu();
        for (Action action : this.popupActions) {
            JMenuItem menuItem = new JMenuItem();
            Actions.connect((JMenuItem)menuItem, (Action)action, (boolean)true);
            pm.add(menuItem);
        }
        return pm;
    }

    protected final G getGraph() {
        return this.graph;
    }

    protected final L getLegend() {
        return this.legend;
    }

    protected final JComponent getHorizontalAxis() {
        return this.hAxis;
    }

    protected final JComponent getVerticalAxis() {
        return this.vAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        this.graphPanel.setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        GraphPanel graphPanel = this;
        synchronized (graphPanel) {
            if (this.overlay != null) {
                this.graphPanel.validate();
                Rectangle rect = ((Component)this.graph).getBounds();
                this.overlay.setBounds(insets.left + rect.x + PADDING / 2, insets.top + rect.y + PADDING / 2, rect.width - PADDING, rect.height - PADDING);
            }
        }
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        ((JComponent)this.graph).setEnabled(enabled);
        ((JComponent)this.legend).setEnabled(enabled);
        if (this.vAxis != null) {
            this.vAxis.setEnabled(enabled);
        }
        if (this.hAxis != null) {
            this.hAxis.setEnabled(enabled);
        }
        for (Action action : this.buttonActions) {
            action.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public final synchronized void setOverlay(JComponent overlay) {
        if (this.overlay == overlay) {
            return;
        }
        if (this.overlay != null) {
            this.remove(this.overlay);
        }
        if (overlay != null) {
            this.add((Component)overlay, (Object)1);
        }
        this.overlay = overlay;
        this.revalidate();
        this.repaint();
    }

    private class PopupMenuListener
    extends MouseAdapter {
        PopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JPopupMenu pm;
            if (e.isPopupTrigger() && (pm = GraphPanel.this.createPopupMenu()) != null) {
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JPopupMenu pm;
            if (e.isPopupTrigger() && (pm = GraphPanel.this.createPopupMenu()) != null) {
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

