/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messager
extends Log
implements DocErrorReporter {
    final String programName;
    private ResourceBundle messageRB = null;
    static final PrintWriter defaultErrWriter = new PrintWriter(System.err);
    static final PrintWriter defaultWarnWriter = new PrintWriter(System.err);
    static final PrintWriter defaultNoticeWriter = new PrintWriter(System.out);

    public static Messager instance0(Context context) {
        Log instance = (Log)context.get(logKey);
        if (instance == null || !(instance instanceof Messager)) {
            throw new InternalError("no messager instance!");
        }
        return (Messager)instance;
    }

    public static void preRegister(final Context context, final String programName) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make() {
                return new Messager(context, programName);
            }
        });
    }

    public static void preRegister(final Context context, final String programName, final PrintWriter errWriter, final PrintWriter warnWriter, final PrintWriter noticeWriter) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make() {
                return new Messager(context, programName, errWriter, warnWriter, noticeWriter);
            }
        });
    }

    protected Messager(Context context, String programName) {
        this(context, programName, defaultErrWriter, defaultWarnWriter, defaultNoticeWriter);
    }

    protected Messager(Context context, String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        super(context, errWriter, warnWriter, noticeWriter);
        this.programName = programName;
    }

    protected int getDefaultMaxErrors() {
        return Integer.MAX_VALUE;
    }

    protected int getDefaultMaxWarnings() {
        return Integer.MAX_VALUE;
    }

    public void reset() {
        this.messageRB = null;
    }

    private String getString(String key) {
        ResourceBundle messageRB = this.messageRB;
        if (messageRB == null) {
            try {
                this.messageRB = messageRB = ResourceBundle.getBundle("com.sun.tools.javadoc.resources.javadoc");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for javadoc is missing");
            }
        }
        return messageRB.getString(key);
    }

    String getText(String key) {
        return this.getText(key, null);
    }

    String getText(String key, String a1) {
        return this.getText(key, a1, null);
    }

    String getText(String key, String a1, String a2) {
        return this.getText(key, a1, a2, null);
    }

    String getText(String key, String a1, String a2, String a3) {
        return this.getText(key, a1, a2, a3, null);
    }

    String getText(String key, String a1, String a2, String a3, String a4) {
        try {
            String message = this.getString(key);
            String[] args = new String[]{a1, a2, a3, a4};
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            return "********** Resource for javadoc is broken. There is no " + key + " key in resource.";
        }
    }

    public void printError(String msg) {
        this.printError(null, msg);
    }

    public void printError(SourcePosition pos, String msg) {
        if (this.nerrors < this.MaxErrors) {
            String prefix = pos == null ? this.programName : pos.toString();
            this.errWriter.println(prefix + ": " + this.getText("javadoc.error") + " - " + msg);
            this.errWriter.flush();
            this.prompt();
            ++this.nerrors;
        }
    }

    public void printWarning(String msg) {
        this.printWarning(null, msg);
    }

    public void printWarning(SourcePosition pos, String msg) {
        if (this.nwarnings < this.MaxWarnings) {
            String prefix = pos == null ? this.programName : pos.toString();
            this.warnWriter.println(prefix + ": " + this.getText("javadoc.warning") + " - " + msg);
            this.warnWriter.flush();
            ++this.nwarnings;
        }
    }

    public void printNotice(String msg) {
        this.printNotice(null, msg);
    }

    public void printNotice(SourcePosition pos, String msg) {
        if (pos == null) {
            this.noticeWriter.println(msg);
        } else {
            this.noticeWriter.println(pos + ": " + msg);
        }
        this.noticeWriter.flush();
    }

    public void error(SourcePosition pos, String key) {
        this.printError(pos, this.getText(key));
    }

    public void error(SourcePosition pos, String key, String a1) {
        this.printError(pos, this.getText(key, a1));
    }

    public void error(SourcePosition pos, String key, String a1, String a2) {
        this.printError(pos, this.getText(key, a1, a2));
    }

    public void error(SourcePosition pos, String key, String a1, String a2, String a3) {
        this.printError(pos, this.getText(key, a1, a2, a3));
    }

    public void warning(SourcePosition pos, String key) {
        this.printWarning(pos, this.getText(key));
    }

    public void warning(SourcePosition pos, String key, String a1) {
        this.printWarning(pos, this.getText(key, a1));
    }

    public void warning(SourcePosition pos, String key, String a1, String a2) {
        this.printWarning(pos, this.getText(key, a1, a2));
    }

    public void warning(SourcePosition pos, String key, String a1, String a2, String a3) {
        this.printWarning(pos, this.getText(key, a1, a2, a3));
    }

    public void warning(SourcePosition pos, String key, String a1, String a2, String a3, String a4) {
        this.printWarning(pos, this.getText(key, a1, a2, a3, a4));
    }

    public void notice(String key) {
        this.printNotice(this.getText(key));
    }

    public void notice(String key, String a1) {
        this.printNotice(this.getText(key, a1));
    }

    public void notice(String key, String a1, String a2) {
        this.printNotice(this.getText(key, a1, a2));
    }

    public void notice(String key, String a1, String a2, String a3) {
        this.printNotice(this.getText(key, a1, a2, a3));
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void exitNotice() {
        int nerrors = this.nerrors();
        int nwarnings = this.nwarnings();
        if (nerrors > 0) {
            this.notice(nerrors > 1 ? "main.errors" : "main.error", "" + nerrors);
        }
        if (nwarnings > 0) {
            this.notice(nwarnings > 1 ? "main.warnings" : "main.warning", "" + nwarnings);
        }
    }

    public void exit() {
        throw new ExitJavadoc();
    }

    public class ExitJavadoc
    extends Error {
        private static final long serialVersionUID = 0L;
    }
}

