/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MakeConnectionElement;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.mc.runtime.WsMcResponseHandler;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

final class MakeConnectionSenderTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(MakeConnectionSenderTask.class);
    private final String wsmcAnonymousAddress;
    private final Header wsmcAnnonymousReplyToHeader;
    private final Header wsmcAnnonymousFaultToHeader;
    private long lastMcMessageTimestamp;
    private final AtomicBoolean isMcRequestPending;
    private int scheduledMcRequestCounter;
    private final McConfiguration configuration;
    private final Communicator communicator;
    private final SuspendedFiberStorage suspendedFiberStorage;
    private final Map<String, ProtocolMessageHandler> mapOfRegisteredProtocolMessageHandlers;

    MakeConnectionSenderTask(Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, String wsmcAnonymousAddress, Header wsmcAnnonymousReplyToHeader, Header wsmcAnnonymousFaultToHeader, McConfiguration configuration) {
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.wsmcAnonymousAddress = wsmcAnonymousAddress;
        this.wsmcAnnonymousReplyToHeader = wsmcAnnonymousReplyToHeader;
        this.wsmcAnnonymousFaultToHeader = wsmcAnnonymousFaultToHeader;
        this.configuration = configuration;
        this.mapOfRegisteredProtocolMessageHandlers = new HashMap<String, ProtocolMessageHandler>();
        this.lastMcMessageTimestamp = System.currentTimeMillis();
        this.isMcRequestPending = new AtomicBoolean(false);
        this.scheduledMcRequestCounter = 0;
    }

    public synchronized void run() {
        if (!this.isMcRequestPending.get() && this.resendMakeConnectionIntervalPassed() && (this.scheduledMcRequestCounter > 0 || this.suspendedFibersReadyForResend())) {
            this.sendMcRequest();
        }
    }

    private boolean suspendedFibersReadyForResend() {
        return !this.suspendedFiberStorage.isEmpty() && System.currentTimeMillis() - this.suspendedFiberStorage.getOldestRegistrationTimestamp() > 2000L;
    }

    private synchronized boolean resendMakeConnectionIntervalPassed() {
        return System.currentTimeMillis() - this.lastMcMessageTimestamp > 2000L;
    }

    synchronized void register(ProtocolMessageHandler handler) {
        for (String wsaAction : handler.getSuportedWsaActions()) {
            ProtocolMessageHandler oldHandler;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Registering ProtocolMessageHandler of class [ %s ] to process WS-A action [ %s ]", handler.getClass().getName(), wsaAction));
            }
            if ((oldHandler = this.mapOfRegisteredProtocolMessageHandlers.put(wsaAction, handler)) == null || !LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(LocalizationMessages.WSMC_0101_DUPLICATE_PROTOCOL_MESSAGE_HANDLER(wsaAction, oldHandler.getClass().getName(), handler.getClass().getName()));
        }
    }

    synchronized void scheduleMcRequest() {
        ++this.scheduledMcRequestCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMcRequest() {
        Packet mcRequest = this.communicator.createRequestPacket(new MakeConnectionElement(this.wsmcAnonymousAddress), this.configuration.getMcVersion().wsmcAction, true);
        McClientTube.setMcAnnonymousHeaders(mcRequest.getMessage().getHeaders(), this.configuration.getAddressingVersion(), this.wsmcAnnonymousReplyToHeader, this.wsmcAnnonymousFaultToHeader);
        this.isMcRequestPending.set(true);
        try {
            this.communicator.sendAsync(mcRequest, new WsMcResponseHandler(this.configuration, this, this.suspendedFiberStorage, this.mapOfRegisteredProtocolMessageHandlers));
        }
        finally {
            this.lastMcMessageTimestamp = System.currentTimeMillis();
            if (--this.scheduledMcRequestCounter < 0) {
                this.scheduledMcRequestCounter = 0;
            }
        }
    }

    synchronized void clearMcRequestPendingFlag() {
        this.isMcRequestPending.set(false);
    }
}

