/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ClassPathListCellRenderer
extends DefaultListCellRenderer {
    private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
    private static final Pattern UNKNOWN_FILE_REFERENCE = Pattern.compile("\\$\\{([^${}]+)\\}");
    private static ImageIcon ICON_FOLDER = null;
    private static ImageIcon ICON_BROKEN_JAR;
    private static ImageIcon ICON_BROKEN_LIBRARY;
    private static ImageIcon ICON_BROKEN_ARTIFACT;
    private PropertyEvaluator evaluator;
    private FileObject projectFolder;
    private static final Map<String, String> WELL_KNOWN_PATHS_NAMES;

    private ClassPathListCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        this.evaluator = evaluator;
        this.projectFolder = projectFolder;
    }

    public static ListCellRenderer createClassPathListRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        return new ClassPathListCellRenderer(evaluator, projectFolder);
    }

    public static TableCellRenderer createClassPathTableRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
        return new ClassPathTableCellRenderer(evaluator, projectFolder);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (" ".equals(value)) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        if (value != null) assert (value instanceof ClassPathSupport.Item) : value.getClass().toString();
        ClassPathSupport.Item item = (ClassPathSupport.Item)value;
        super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
        this.setIcon(ClassPathListCellRenderer.getIcon(item));
        this.setToolTipText(this.getToolTipText(item));
        return this;
    }

    private String getDisplayName(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                }
                return item.getLibrary().getDisplayName();
            }
            case 3: {
                String name = WELL_KNOWN_PATHS_NAMES.get(CommonProjectUtils.getAntPropertyName(item.getReference()));
                return name == null ? item.getReference() : name;
            }
            case 2: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                }
                Project p = item.getArtifact().getProject();
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                String projectName = pi.getDisplayName();
                return MessageFormat.format(NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"MSG_ProjectArtifactFormat"), projectName, item.getArtifactURI().toString());
            }
            case 0: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                }
                if (item.getVariableBasedProperty() != null) {
                    String s = item.getVariableBasedProperty();
                    return s.substring(6, s.indexOf("}")) + s.substring(s.indexOf("}") + 1);
                }
                return item.getFilePath();
            }
        }
        return item.getReference();
    }

    static Icon getIcon(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_LIBRARY == null) {
                        ICON_BROKEN_LIBRARY = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_LIBRARY.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_LIBRARY;
                }
                return ProjectProperties.ICON_LIBRARY;
            }
            case 2: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_ARTIFACT == null) {
                        ICON_BROKEN_ARTIFACT = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_ARTIFACT.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_ARTIFACT;
                }
                Project p = item.getArtifact().getProject();
                if (p != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    return pi.getIcon();
                }
                return ProjectProperties.ICON_ARTIFACT;
            }
            case 0: {
                ImageIcon icn;
                if (item.isBroken()) {
                    if (ICON_BROKEN_JAR == null) {
                        ICON_BROKEN_JAR = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_JAR.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_JAR;
                }
                File file = item.getResolvedFile();
                ImageIcon imageIcon = icn = file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ProjectProperties.ICON_JAR;
                if (item.getSourceFilePath() != null) {
                    icn = new ImageIcon(ImageUtilities.mergeImages((Image)icn.getImage(), (Image)ProjectProperties.ICON_SOURCE_BADGE.getImage(), (int)8, (int)8));
                }
                if (item.getJavadocFilePath() != null) {
                    icn = new ImageIcon(ImageUtilities.mergeImages((Image)icn.getImage(), (Image)ProjectProperties.ICON_JAVADOC_BADGE.getImage(), (int)8, (int)0));
                }
                return icn;
            }
            case 3: {
                return ProjectProperties.ICON_CLASSPATH;
            }
        }
        return null;
    }

    private String getToolTipText(ClassPathSupport.Item item) {
        if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
            return this.evaluator.evaluate(item.getReference());
        }
        switch (item.getType()) {
            case 0: {
                File f = item.getResolvedFile();
                if (f.getPath().equals(item.getFilePath()) && item.getVariableBasedProperty() == null) break;
                return f.getPath();
            }
            case 2: {
                FileObject projDir;
                AntArtifact artifact = item.getArtifact();
                if (artifact == null || (projDir = artifact.getProject().getProjectDirectory()) == null) break;
                return FileUtil.getFileDisplayName((FileObject)projDir);
            }
        }
        return null;
    }

    private static ImageIcon getFolderIcon() {
        if (ICON_FOLDER == null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
            ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
        }
        return ICON_FOLDER;
    }

    private String getProjectName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        return ID.substring(12, ID.indexOf(46, 12));
    }

    private String getLibraryName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        if (ID == null) {
            if (item.getLibrary() != null) {
                return item.getLibrary().getName();
            }
            return "XXX";
        }
        return ID.substring(7, ID.indexOf(".classpath"));
    }

    private String getFileRefName(ClassPathSupport.Item item) {
        String ID = item.getReference();
        Matcher m = FOREIGN_PLAIN_FILE_REFERENCE.matcher(ID);
        if (m.matches()) {
            return m.group(1);
        }
        m = UNKNOWN_FILE_REFERENCE.matcher(ID);
        if (m.matches()) {
            return m.group(1);
        }
        return ID;
    }

    static {
        WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();
        WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildClassesDir_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
    }

    static class ClassPathTableCellRenderer
    extends DefaultTableCellRenderer {
        private ClassPathListCellRenderer renderer;

        ClassPathTableCellRenderer(PropertyEvaluator evaluator, FileObject projectFolder) {
            this.renderer = new ClassPathListCellRenderer(evaluator, projectFolder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                assert (value instanceof ClassPathSupport.Item) : value.getClass().toString();
                ClassPathSupport.Item item = (ClassPathSupport.Item)value;
                this.setIcon(ClassPathListCellRenderer.getIcon(item));
                this.setToolTipText(this.renderer.getToolTipText(item));
                return super.getTableCellRendererComponent(table, this.renderer.getDisplayName(item), isSelected, false, row, column);
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, null, isSelected, false, row, column);
        }
    }
}

