/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.JDialog;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.navigation.JavaHierarchyPanel;
import org.netbeans.modules.java.navigation.ResizablePopup;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavaHierarchy {
    private static final Logger LOG = Logger.getLogger(JavaHierarchy.class.getName());

    public static void show(final FileObject fileObject) {
        JavaSource javaSource;
        if (fileObject != null && (javaSource = JavaSource.forFileObject((FileObject)fileObject)) != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List topLevels = compilationController.getTopLevelElements();
                        Element[] elements = topLevels.toArray(new Element[topLevels.size()]);
                        JavaHierarchy.show(fileObject, elements, compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public static void show(FileObject fileObject, Element[] elements, CompilationController compilationController) {
        LOG.log(Level.FINE, "Showing hierarchy for: {0}", fileObject == null ? null : FileUtil.getFileDisplayName((FileObject)fileObject));
        if (fileObject != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchy.class, (String)"LBL_WaitNode"));
            JDialog dialog = ResizablePopup.getDialog(fileObject);
            String membersOf = "";
            if (elements != null && elements.length > 0) {
                List<Element> elementsList = Arrays.asList(elements);
                membersOf = elements[0].getKind() == ElementKind.PACKAGE && elements.length > 1 ? elementsList.subList(1, elementsList.size()).toString() : elementsList.toString();
            }
            String title = NbBundle.getMessage(JavaHierarchy.class, (String)"TITLE_Hierarchy", (Object)membersOf);
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHierarchy.class, (String)"ACSD_JavaHierarchyDialog", (Object)membersOf));
            dialog.setTitle(title);
            dialog.setContentPane(new JavaHierarchyPanel(fileObject, elements));
            dialog.setVisible(true);
            LOG.log(Level.FINE, "Opened hierarchy for: {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
        }
    }
}

