/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.editor.BaseAction;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.openide.text.NbDocument;

public abstract class PreprocessorEditorContextAction
extends BaseAction {
    public PreprocessorEditorContextAction(String name) {
        super(name);
    }

    public abstract String getPopupMenuText(ProjectConfigurationsHelper var1, ArrayList<PPLine> var2, JTextComponent var3);

    public abstract boolean isEnabled(ProjectConfigurationsHelper var1, ArrayList<PPLine> var2, JTextComponent var3);

    protected int getSelectionStartLine(JTextComponent c) {
        if (c == null || !(c.getDocument() instanceof StyledDocument)) {
            return 0;
        }
        return NbDocument.findLineNumber((StyledDocument)((StyledDocument)c.getDocument()), (int)c.getSelectionStart()) + 1;
    }

    protected int getSelectionEndLine(JTextComponent c) {
        if (c == null || !(c.getDocument() instanceof StyledDocument)) {
            return 0;
        }
        int i = NbDocument.findLineNumber((StyledDocument)((StyledDocument)c.getDocument()), (int)c.getSelectionEnd());
        return c.getSelectionStart() == c.getSelectionEnd() || NbDocument.findLineColumn((StyledDocument)((StyledDocument)c.getDocument()), (int)c.getSelectionEnd()) > 0 ? i + 1 : i;
    }

    protected PPBlockInfo getBlock(JTextComponent target, ArrayList<PPLine> preprocessorLineList) {
        int x = this.getSelectionStartLine(target);
        if (x >= preprocessorLineList.size()) {
            return null;
        }
        return preprocessorLineList.get(x - 1).getBlock();
    }

    protected boolean overlapsBlockBorders(JTextComponent c, ArrayList<PPLine> preprocessorLineList) {
        int sL = this.getSelectionStartLine(c);
        int eL = this.getSelectionEndLine(c);
        if (sL >= preprocessorLineList.size() || eL >= preprocessorLineList.size()) {
            return false;
        }
        PPBlockInfo b = preprocessorLineList.get(sL - 1).getBlock();
        return b != null && (b.getStartLine() == sL || b.hasFooter() && b.getEndLine() == eL || b != preprocessorLineList.get(eL - 1).getBlock());
    }

    protected boolean overlapsGuardedBlocks(JTextComponent c) {
        Document d = c.getDocument();
        if (!(d instanceof StyledDocument)) {
            return false;
        }
        GuardedSectionManager man = GuardedSectionManager.getInstance((StyledDocument)((StyledDocument)d));
        if (man == null) {
            return false;
        }
        for (GuardedSection s : man.getGuardedSections()) {
            try {
                if (!s.contains(NbDocument.createPosition((Document)d, (int)c.getSelectionStart(), (Position.Bias)Position.Bias.Backward), false) && !s.contains(NbDocument.createPosition((Document)d, (int)c.getSelectionEnd(), (Position.Bias)Position.Bias.Forward), false) && (s.getStartPosition().getOffset() < c.getSelectionStart() || s.getEndPosition().getOffset() > c.getSelectionEnd())) continue;
                return true;
            }
            catch (BadLocationException ble) {
            }
        }
        return false;
    }
}

