/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;

public class PPVariableCompletionItem
implements CompletionItem {
    private final String varName;
    private final String varDesc;
    private static ImageIcon icon;
    private String leftText;

    PPVariableCompletionItem(String varName, String varType) {
        this.varName = varName;
        this.varDesc = varType;
    }

    public void defaultAction(JTextComponent component) {
        this.substitute(component, this.varName);
        Completion.get().hideAll();
    }

    private void substitute(JTextComponent component, String variable) {
        int offset = component.getCaret().getDot();
        Document doc = component.getDocument();
        try {
            int wordStart = Utilities.getWordStart((JTextComponent)component, (int)offset);
            int wordEnd = Utilities.getWordEnd((JTextComponent)component, (int)offset);
            if (wordStart > 0) {
                String word = doc.getText(wordStart, wordEnd - wordStart);
                if ("()".equals(word) || "(".equals(word)) {
                    doc.insertString(wordStart + 1, variable, null);
                } else if (")".equals(word)) {
                    doc.insertString(wordStart, variable, null);
                } else {
                    doc.remove(wordStart, word.length());
                    doc.insertString(wordStart, variable, null);
                }
            } else {
                doc.insertString(offset, variable, null);
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    public void processKeyEvent(KeyEvent event) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        PPVariableCompletionItem pPVariableCompletionItem = this;
        synchronized (pPVariableCompletionItem) {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/mobility/editor/resources/v.png", (boolean)false);
            }
        }
        if (selected) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
            g.setColor(defaultColor);
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return 50;
    }

    public CharSequence getSortText() {
        return this.varName;
    }

    private String getLeftText() {
        if (this.leftText == null) {
            this.leftText = "<b>" + PPVariableCompletionItem.toHtmlText(this.varName) + "</b>  ";
        }
        return this.leftText;
    }

    private String getRightText() {
        return PPVariableCompletionItem.toHtmlText(this.varDesc);
    }

    private static String toHtmlText(String text) {
        StringBuffer htmlText = null;
        for (int i = 0; i < text.length(); ++i) {
            String rep;
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    rep = "<br>";
                    break;
                }
                default: {
                    rep = null;
                }
            }
            if (rep != null) {
                if (htmlText == null) {
                    htmlText = new StringBuffer(120 * text.length() / 100);
                    if (i > 0) {
                        htmlText.append(text.substring(0, i));
                    }
                }
                htmlText.append(rep);
                continue;
            }
            if (htmlText == null) continue;
            htmlText.append(ch);
        }
        return htmlText != null ? htmlText.toString() : text;
    }

    public CharSequence getInsertPrefix() {
        return this.varName;
    }
}

