/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.openide.text.NbDocument;

public class ReferencesCache {
    static CsmObject UNRESOLVED = new CsmObject(){

        public String toString() {
            return "FAKE REFERENCE";
        }
    };
    private static final int MAX_CACHE_SIZE = 10;
    private final Object cacheLock = new CacheLock();
    private LinkedHashMap<CsmFile, Map<Integer, CacheEntry>> cache = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject getReferencedObject(CsmFile file, int offset, long callTimeVersion) {
        Object object = this.cacheLock;
        synchronized (object) {
            CacheEntry cacheEntry;
            Map<Integer, CacheEntry> entry = this.cache.get(file);
            CsmObject out = null;
            if (entry != null && (cacheEntry = entry.get(offset)) != null && (out = cacheEntry.csmObject) == UNRESOLVED) {
                long storedVersion = cacheEntry.fileVersion;
                long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                if (fileVersion != storedVersion) {
                    entry.put(offset, null);
                    out = null;
                }
            }
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putReferencedObject(CsmFile file, int offset, CsmObject object, long oldVersion) {
        Object object2 = this.cacheLock;
        synchronized (object2) {
            CacheEntry cacheEntry;
            Map<Integer, CacheEntry> entry = this.cache.get(file);
            if (entry == null) {
                if (this.cache.size() > 10) {
                    Map.Entry<CsmFile, Map<Integer, CacheEntry>> next = this.cache.entrySet().iterator().next();
                    this.cache.remove(next.getKey());
                }
                entry = new HashMap<Integer, CacheEntry>();
                this.cache.put(file, entry);
            }
            if ((cacheEntry = entry.get(offset)) == null) {
                cacheEntry = new CacheEntry();
                cacheEntry.csmObject = object;
                cacheEntry.fileVersion = oldVersion;
                entry.put(offset, cacheEntry);
            } else {
                long fileVersion;
                if (object == UNRESOLVED && oldVersion != (fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file))) {
                    return;
                }
                cacheEntry.csmObject = object;
                cacheEntry.fileVersion = oldVersion;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFileReferences(CsmFile file) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (file == null) {
                this.cache.clear();
            } else {
                this.cache.remove(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInfo(PrintWriter printOut) {
        Object object = this.cacheLock;
        synchronized (object) {
            printOut.printf("cache of size %d\n", this.cache.size());
            for (Map.Entry<CsmFile, Map<Integer, CacheEntry>> entry : this.cache.entrySet()) {
                CsmFile file = entry.getKey();
                printOut.printf("-----------------------\n", new Object[0]);
                printOut.printf("file %s version=%d, class=%s\n", file.getAbsolutePath(), CsmFileInfoQuery.getDefault().getFileVersion(file), file.getClass().getName());
                TreeMap<Integer, CacheEntry> unresolved = new TreeMap<Integer, CacheEntry>();
                for (Map.Entry<Integer, CacheEntry> entry2 : entry.getValue().entrySet()) {
                    if (entry2.getValue().csmObject != UNRESOLVED) continue;
                    unresolved.put(entry2.getKey(), entry2.getValue());
                }
                if (unresolved.isEmpty()) {
                    printOut.printf("no UNRESOLVED \n", new Object[0]);
                    continue;
                }
                for (Map.Entry<Integer, CacheEntry> entry3 : unresolved.entrySet()) {
                    printOut.printf("UNRESOLVED [%s] version=%d\n", this.getPosition(entry3.getKey(), file), entry3.getValue().fileVersion);
                    CsmObject checkAgain = ReferencesSupport.findDeclaration(file, (Document)ReferencesSupport.getDocument(file), null, entry3.getKey());
                    if (checkAgain == null) continue;
                    printOut.printf("\t ERROR: resolved as [%s]\n", checkAgain);
                }
            }
            printOut.printf("-----------------------\n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPosition(int offset, CsmFile file) {
        BaseDocument document = ReferencesSupport.getDocument(file);
        StringBuilder out = new StringBuilder();
        out.append("offset=").append(offset);
        if (document instanceof StyledDocument) {
            TokenItem jumpToken;
            int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)offset) + 1;
            out.append(", line=").append(line);
            int col = NbDocument.findLineColumn((StyledDocument)((StyledDocument)document), (int)offset) + 1;
            out.append(", column=").append(col);
            document.readLock();
            try {
                jumpToken = CndTokenUtilities.getTokenCheckPrev((Document)document, (int)offset);
            }
            finally {
                document.readUnlock();
            }
            out.append(", tok=").append(jumpToken);
        }
        return out.toString();
    }

    private static final class CacheEntry {
        private long fileVersion;
        private CsmObject csmObject;

        private CacheEntry() {
        }
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }
}

