/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class NbBundleProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(NbBundle.Messages.class.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String pkg;
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap pairs = new HashMap();
        HashMap identifiers = new HashMap();
        HashMap originatingElements = new HashMap();
        HashMap comments = new HashMap();
        for (Element element : roundEnv.getElementsAnnotatedWith(NbBundle.Messages.class)) {
            HashMap<String, String[]> commentsByPackage;
            ArrayList<Element> originatingElementsByPackage;
            HashSet<String> identifiersByPackage;
            pkg = this.findPackage(element);
            HashMap<String, String> pairsByPackage = (HashMap<String, String>)pairs.get(pkg);
            if (pairsByPackage == null) {
                pairsByPackage = new HashMap<String, String>();
                pairs.put(pkg, pairsByPackage);
            }
            if ((identifiersByPackage = (HashSet<String>)identifiers.get(pkg)) == null) {
                identifiersByPackage = new HashSet<String>();
                identifiers.put(pkg, identifiersByPackage);
            }
            if ((originatingElementsByPackage = (ArrayList<Element>)originatingElements.get(pkg)) == null) {
                originatingElementsByPackage = new ArrayList<Element>();
                originatingElements.put(pkg, originatingElementsByPackage);
            }
            if ((commentsByPackage = (HashMap<String, String[]>)comments.get(pkg)) == null) {
                commentsByPackage = new HashMap<String, String[]>();
                comments.put(pkg, commentsByPackage);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            NbBundle.Messages messages = element.getAnnotation(NbBundle.Messages.class);
            if (messages == null) continue;
            for (String keyValue : messages.value()) {
                if (keyValue.startsWith("#")) {
                    arrayList.add(keyValue);
                    continue;
                }
                int i = keyValue.indexOf(61);
                if (i == -1) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Bad key=value: " + keyValue, element);
                    continue;
                }
                String key = keyValue.substring(0, i);
                if (key.isEmpty() || !key.equals(key.trim())) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Whitespace not permitted in key: " + keyValue, element);
                    continue;
                }
                if (!identifiersByPackage.add(this.toIdentifier(key))) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate key: " + key, element);
                    continue;
                }
                String value = keyValue.substring(i + 1);
                pairsByPackage.put(key, value);
                originatingElementsByPackage.add(element);
                if (arrayList.isEmpty()) continue;
                commentsByPackage.put(key, arrayList.toArray(new String[arrayList.size()]));
                arrayList.clear();
            }
            if (arrayList.isEmpty()) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Comments must precede keys", element);
        }
        for (Map.Entry entry : pairs.entrySet()) {
            pkg = (String)entry.getKey();
            Map keysAndValues = (Map)entry.getValue();
            Element[] elements = ((List)originatingElements.get(pkg)).toArray(new Element[0]);
            try {
                InputStream is;
                EditableProperties p = new EditableProperties(true);
                try {
                    is = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, pkg, "Bundle.properties").openInputStream();
                    try {
                        p.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException x) {
                    // empty catch block
                }
                for (String string : p.keySet()) {
                    if (!keysAndValues.containsKey(string)) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Key " + string + " is a duplicate of one from Bundle.properties", elements[0]);
                }
                try {
                    is = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties").openInputStream();
                    try {
                        EditableProperties editableProperties = new EditableProperties(true);
                        editableProperties.load(is);
                        p.putAll(editableProperties);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException x) {
                    // empty catch block
                }
                p.putAll(keysAndValues);
                for (Map.Entry entry2 : ((Map)comments.get(pkg)).entrySet()) {
                    p.setComment((String)entry2.getKey(), (String[])entry2.getValue(), false);
                }
                OutputStream os = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, pkg, "Bundle.properties", elements).openOutputStream();
                try {
                    p.store(os);
                }
                finally {
                    os.close();
                }
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                try {
                    Matcher m = Pattern.compile("    /[*][*]\r?\n(?:     [*].+\r?\n)+     [*]/\r?\n    static String (\\w+).+\r?\n        .+\r?\n    [}]\r?\n").matcher(this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, pkg, "Bundle.java").getCharContent(false));
                    while (m.find()) {
                        treeMap.put(m.group(1), m.group());
                    }
                }
                catch (IOException x) {
                    // empty catch block
                }
                for (Map.Entry entry2 : keysAndValues.entrySet()) {
                    String key = (String)entry2.getKey();
                    String value = (String)entry2.getValue();
                    CharSequence method = new StringBuilder();
                    ((StringBuilder)method).append("    /**\n");
                    ArrayList<String> params = new ArrayList<String>();
                    int i = 0;
                    while (value.contains("{" + i)) {
                        params.add("arg" + i++);
                    }
                    String[] commentLines = (String[])((Map)comments.get(pkg)).get(key);
                    if (commentLines != null) {
                        for (String comment : commentLines) {
                            Matcher m = Pattern.compile("# [{](\\d+)[}] - (.+)").matcher(comment);
                            if (!m.matches()) continue;
                            i = Integer.parseInt(m.group(1));
                            while (i >= params.size()) {
                                params.add("arg" + params.size());
                            }
                            String desc = m.group(2);
                            params.set(i, this.toIdentifier(desc));
                            ((StringBuilder)method).append("     * @param ").append((String)params.get(i)).append(" ").append(this.toJavadoc(desc)).append("\n");
                        }
                    }
                    StringBuffer annotatedValue = new StringBuffer("<i>");
                    Matcher m = Pattern.compile("[{](\\d+)[}]").matcher(this.toJavadoc(value));
                    while (m.find()) {
                        i = Integer.parseInt(m.group(1));
                        m.appendReplacement(annotatedValue, i < params.size() ? "</i>{@code " + (String)params.get(i) + "}<i>" : m.group());
                    }
                    m.appendTail(annotatedValue);
                    annotatedValue.append("</i>");
                    ((StringBuilder)method).append("     * @return ").append(annotatedValue.toString().replace("<i></i>", "")).append('\n');
                    ((StringBuilder)method).append("     */\n");
                    String name = this.toIdentifier(key);
                    ((StringBuilder)method).append("    static String ").append(name).append("(");
                    boolean first = true;
                    for (String param : params) {
                        if (first) {
                            first = false;
                        } else {
                            ((StringBuilder)method).append(", ");
                        }
                        ((StringBuilder)method).append("Object ").append(param);
                    }
                    ((StringBuilder)method).append(") {\n");
                    ((StringBuilder)method).append("        return org.openide.util.NbBundle.getMessage(Bundle.class, \"").append(key).append("\"");
                    for (String param : params) {
                        ((StringBuilder)method).append(", ").append(param);
                    }
                    ((StringBuilder)method).append(");\n");
                    ((StringBuilder)method).append("    }\n");
                    treeMap.put(name, ((StringBuilder)method).toString());
                }
                String fqn = pkg + ".Bundle";
                Writer w = this.processingEnv.getFiler().createSourceFile(fqn, elements).openWriter();
                try {
                    PrintWriter pw = new PrintWriter(w);
                    pw.println("package " + pkg + ";");
                    pw.println("/** Localizable strings for {@link " + pkg + "}. */");
                    pw.println("@javax.annotation.Generated(value=\"" + NbBundleProcessor.class.getName() + "\")");
                    pw.println("class Bundle {");
                    for (CharSequence method : treeMap.values()) {
                        pw.print((String)method);
                    }
                    pw.println("    private void Bundle() {}");
                    pw.println("}");
                    pw.flush();
                    pw.close();
                }
                finally {
                    w.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not generate files: " + x, elements[0]);
            }
        }
        return true;
    }

    private String findPackage(Element e) {
        switch (e.getKind()) {
            case PACKAGE: {
                return ((PackageElement)e).getQualifiedName().toString();
            }
        }
        return this.findPackage(e.getEnclosingElement());
    }

    private String toIdentifier(String key) {
        if (Utilities.isJavaIdentifier(key)) {
            return key;
        }
        String i = key.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (Utilities.isJavaIdentifier(i)) {
            return i;
        }
        return "_" + i;
    }

    private String toJavadoc(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace("*/", "&#x2A;/").replace("\n", "<br>").replace("@", "&#64;");
    }
}

