/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenamePlugin;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HibernateMappingMovePlugin
implements RefactoringPlugin {
    private MoveRefactoring refactoring;
    private Project project;
    private String srcRoot;
    private ArrayList<MappingFileData> toBeMovedMappingFiles;

    public HibernateMappingMovePlugin(MoveRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        URL targetURL = (URL)this.refactoring.getTarget().lookup(URL.class);
        if (targetURL == null) {
            return null;
        }
        String targetPackageName = HibernateRefactoringUtil.getPackageName(targetURL);
        if (targetPackageName == null) {
            return null;
        }
        this.toBeMovedMappingFiles = this.getToBeMovedMappingFileData(targetPackageName);
        ArrayList<MappingFileData> mappingFilesInTargetPkg = this.getMappingFileDataInTargetPkg(targetPackageName);
        Problem fastCheckProblem = null;
        for (MappingFileData toBeMovedFo : this.toBeMovedMappingFiles) {
            for (MappingFileData existingFo : mappingFilesInTargetPkg) {
                if (toBeMovedFo.getFo().equals(existingFo.getFo()) || !toBeMovedFo.getNewResourcename().equals(existingFo.getResourceName())) continue;
                fastCheckProblem = HibernateRefactoringUtil.createProblem(fastCheckProblem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Name_Exists", (Object)toBeMovedFo.getFo().getNameExt()));
                return fastCheckProblem;
            }
        }
        return fastCheckProblem;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        HibernateEnvironment env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        if (env == null) {
            return null;
        }
        List<FileObject> configFiles = env.getAllHibernateConfigFileObjects();
        if (configFiles.isEmpty()) {
            return null;
        }
        for (MappingFileData tobemoved : this.toBeMovedMappingFiles) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getMappingResourceOccurrences(configFiles, tobemoved.getResourceName(), false);
            for (FileObject configFile : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(configFile);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRenameRefactoringElement elem = new HibernateRenameRefactoringElement(configFile, tobemoved.getResourceName(), tobemoved.getNewResourcename(), foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)elem);
                }
            }
            refactoringElements.registerTransaction((Transaction)new HibernateMappingRenameTransaction(occurrences.keySet(), tobemoved.getResourceName(), tobemoved.getNewResourcename()));
        }
        return null;
    }

    private ArrayList<MappingFileData> getToBeMovedMappingFileData(String targetPkgName) {
        ArrayList<MappingFileData> fileData = new ArrayList<MappingFileData>();
        for (FileObject fo : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            if (!fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
            if (this.project == null) {
                this.project = FileOwnerQuery.getOwner((FileObject)fo);
            }
            if (this.srcRoot == null) {
                SourceGroup[] grp = SourceGroups.getJavaSourceGroups((Project)this.project);
                if (grp.length == 0) {
                    return null;
                }
                this.srcRoot = grp[0].getRootFolder().getPath();
            }
            String oldPath = fo.getPath();
            String oldResource = oldPath.substring(this.srcRoot.length() + 1);
            String fileName = oldResource.substring(oldResource.lastIndexOf("/") + 1);
            String newResource = targetPkgName + "/" + fileName;
            fileData.add(new MappingFileData(fo, oldResource, newResource));
        }
        return fileData;
    }

    private ArrayList<MappingFileData> getMappingFileDataInTargetPkg(String targetPkgName) {
        ArrayList<MappingFileData> fileData = new ArrayList<MappingFileData>();
        HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnv == null) {
            return fileData;
        }
        List<FileObject> mappingFiles = hibernateEnv.getAllHibernateMappingFileObjects();
        for (FileObject fo : mappingFiles) {
            String packageName;
            String path = fo.getPath();
            String resourceName = path.substring(this.srcRoot.length() + 1);
            int separator = resourceName.lastIndexOf("/");
            if (separator <= 0 || !(packageName = resourceName.substring(0, separator)).equals(targetPkgName)) continue;
            fileData.add(new MappingFileData(fo, resourceName, null));
        }
        return fileData;
    }

    private class MappingFileData {
        private FileObject fo;
        private String resourceName;
        private String newResourcename;

        public MappingFileData(FileObject fo, String resourceName, String newResourcename) {
            this.fo = fo;
            this.resourceName = resourceName;
            this.newResourcename = newResourcename;
        }

        public FileObject getFo() {
            return this.fo;
        }

        public String getNewResourcename() {
            return this.newResourcename;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

