/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class HibernateFindUsagesPlugin
implements RefactoringPlugin {
    private final WhereUsedQuery query;
    private List<FileObject> mappingFileObjs;

    public HibernateFindUsagesPlugin(WhereUsedQuery query) {
        this.query = query;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (this.query.getBooleanValue((Object)"FIND_REFERENCES")) {
            TreePathHandle treePathHandle = (TreePathHandle)this.query.getRefactoringSource().lookup(TreePathHandle.class);
            FileObject fo = null;
            if (treePathHandle != null && (TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind()) || treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER)) {
                fo = treePathHandle.getFileObject();
            }
            if (fo == null) {
                return null;
            }
            Project proj = FileOwnerQuery.getOwner(fo);
            if (proj == null) {
                return null;
            }
            HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
            if (env == null) {
                return null;
            }
            this.mappingFileObjs = env.getAllHibernateMappingFileObjects();
            if (this.mappingFileObjs == null || this.mappingFileObjs.size() == 0) {
                return null;
            }
            try {
                if (treePathHandle != null) {
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePathHandle.getKind())) {
                        this.findJavaClassUsage(treePathHandle, refactoringElements, fo);
                    } else {
                        this.findJavaClassFieldUsage(treePathHandle, refactoringElements, fo);
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return null;
    }

    private void findJavaClassUsage(final TreePathHandle treePathHandle, RefactoringElementsBag refactoringElements, FileObject classFile) throws IOException {
        final String[] binaryClassName = new String[]{null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)classFile);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                binaryClassName[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
            }
        }, true);
        String className = binaryClassName[0];
        if (className != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaClassOccurrences(this.mappingFileObjs, className);
            for (FileObject mFileObj : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRefactoringElement elem = new HibernateRefactoringElement(mFileObj, className, foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)elem);
                }
            }
        }
    }

    private void findJavaClassFieldUsage(final TreePathHandle treePathHandle, RefactoringElementsBag refactoringElements, FileObject classFile) throws IOException {
        final String[] classAndFieldName = new String[]{null, null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)classFile);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.FIELD) {
                    return;
                }
                classAndFieldName[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element.getEnclosingElement()));
                classAndFieldName[1] = element.getSimpleName().toString();
            }
        }, true);
        String className = classAndFieldName[0];
        String fieldName = classAndFieldName[1];
        if (className != null && fieldName != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> occurrences = HibernateRefactoringUtil.getJavaFieldOccurrences(this.mappingFileObjs, className, fieldName);
            for (FileObject mFileObj : occurrences.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> foundPlaces = occurrences.get(mFileObj);
                for (HibernateRefactoringUtil.OccurrenceItem foundPlace : foundPlaces) {
                    HibernateRefactoringElement elem = new HibernateRefactoringElement(mFileObj, fieldName, foundPlace.getLocation(), foundPlace.getText());
                    refactoringElements.add((AbstractRefactoring)this.query, (RefactoringElementImplementation)elem);
                }
            }
        }
    }
}

