/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.mapping;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataLoader;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataNode;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingMetadata;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public class HibernateMappingDataObject
extends MultiDataObject {
    private HibernateMapping mapping;

    public HibernateMappingDataObject(FileObject pf, HibernateMappingDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookies));
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        cookies.add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        cookies.add((Node.Cookie)validateCookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMyClass(MyClass myClass) {
        OutputStream out = null;
        try {
            this.getHibernateMapping().addMyClass(myClass);
            out = this.getPrimaryFile().getOutputStream();
            this.getHibernateMapping().write(out);
        }
        catch (FileAlreadyLockedException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public HibernateMapping getHibernateMapping() {
        if (this.mapping == null) {
            try {
                this.mapping = HibernateMappingMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        assert (this.mapping != null);
        return this.mapping;
    }

    public void save() {
        EditorCookie edit = (EditorCookie)this.getCookie(EditorCookie.class);
        if (edit != null) {
            try {
                edit.saveDocument();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    protected Node createNodeDelegate() {
        return new HibernateMappingDataNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }
}

