/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RemoteProjectSupport {
    private RemoteProjectSupport() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration mk = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (mk != null) {
            return mk.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Project project) {
        File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File nbproject = CndFileUtils.createLocalFile((File)baseDir, (String)"nbproject");
        return nbproject.exists();
    }

    public static File getPrivateStorage(Project project) {
        File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        File privProjectStorage = CndFileUtils.createLocalFile((File)new File(baseDir, "nbproject"), (String)"private");
        return privProjectStorage;
    }

    public static File[] getProjectSourceDirs(Project project) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (conf == null) {
            File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
            return new File[]{baseDir};
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, conf);
    }

    public static File[] getProjectSourceDirs(Project project, MakeConfiguration conf) {
        MakeConfigurationDescriptor mcs;
        File baseDir = CndFileUtils.toFile((FileObject)project.getProjectDirectory()).getAbsoluteFile();
        if (conf == null) {
            return new File[]{baseDir};
        }
        HashSet<File> sourceFilesAndDirs = new HashSet<File>();
        if (!conf.isMakefileConfiguration()) {
            sourceFilesAndDirs.add(baseDir);
        }
        if ((mcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)project)) == null) {
            return new File[0];
        }
        for (String soorceRoot : mcs.getSourceRoots()) {
            String path = CndPathUtilitities.toAbsolutePath((String)baseDir.getAbsolutePath(), (String)soorceRoot);
            File file = CndFileUtils.createLocalFile((String)path);
            sourceFilesAndDirs.add(file);
        }
        RemoteProjectSupport.addExtraFiles(mcs, sourceFilesAndDirs);
        ArrayList<Project> subProjects = new ArrayList<Project>(conf.getSubProjects());
        for (LibraryItem.ProjectItem requiredProject : conf.getRequiredProjectsConfiguration().getValue()) {
            Project p = requiredProject.getProject(conf.getBaseDir());
            if (p == null) continue;
            subProjects.add(p);
        }
        for (Project subProject : subProjects) {
            File projectDirFile = FileUtil.toFile((FileObject)subProject.getProjectDirectory());
            if (projectDirFile != null) {
                sourceFilesAndDirs.add(projectDirFile);
            }
            MakeConfigurationDescriptor subMcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)subProject);
            for (String soorceRoot : mcs.getSourceRoots()) {
                File file = CndFileUtils.createLocalFile((String)soorceRoot).getAbsoluteFile();
                sourceFilesAndDirs.add(file);
            }
            RemoteProjectSupport.addExtraFiles(subMcs, sourceFilesAndDirs);
        }
        return sourceFilesAndDirs.toArray(new File[sourceFilesAndDirs.size()]);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<File> filesToSync) {
        SharabilityFilter filter = new SharabilityFilter();
        for (Item item : subMcs.getProjectItems()) {
            File normFile = item.getNormalizedFile();
            if (!filter.accept(normFile)) {
                filesToSync.add(normFile);
                continue;
            }
            if (!RemoteProjectSupport.isContained(normFile, filesToSync)) {
                filesToSync.add(normFile);
                continue;
            }
            if (normFile.exists()) continue;
            filesToSync.add(normFile);
        }
    }

    private static boolean isContained(File normFile, Set<File> files) {
        String itemAbsPath = normFile.getAbsolutePath();
        for (File dir : files) {
            String alreadyAddedPath;
            if (!dir.isDirectory() || !itemAbsPath.startsWith(alreadyAddedPath = dir.getAbsolutePath() + File.separatorChar)) continue;
            return true;
        }
        return false;
    }
}

