/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.support.impl;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.spi.support.SQLRequest;
import org.netbeans.modules.dlight.spi.support.SQLRequestsProcessor;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class SQLRequestsProcessorImpl
implements SQLRequestsProcessor {
    private static final Logger log = DLightLogger.getLogger(SQLRequestsProcessorImpl.class);
    private static final RequestProcessor RP = new RequestProcessor(SQLRequestsProcessorImpl.class.getName(), 10);
    private final int pollTimeout;
    private final TimeUnit pollTimeoutUnit;
    private final AtomicBoolean isActive = new AtomicBoolean();
    private final LinkedBlockingQueue<SQLRequest> queue = new LinkedBlockingQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition queueProcessingDone = this.lock.newCondition();
    private final Lock taskLock = new ReentrantLock();
    private ScheduledFuture<?> task = null;
    private final int pollRequests;
    private final int maxIdleLoops;

    public SQLRequestsProcessorImpl(int pollRequests, int pollTimeout, TimeUnit pollTimeoutUnit) {
        this.pollRequests = pollRequests;
        this.pollTimeout = pollTimeout;
        this.pollTimeoutUnit = pollTimeoutUnit;
        this.maxIdleLoops = Math.max(3, (int)(pollTimeoutUnit.convert(2L, TimeUnit.SECONDS) / (long)pollTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queueRequest(SQLRequest request) {
        if (!this.queue.offer(request)) {
            log.fine("Request dropped - no space in queue");
            return false;
        }
        if (!this.isActive.get()) {
            this.taskLock.lock();
            try {
                if (this.isActive.compareAndSet(false, true)) {
                    log.fine("Starting SQLRequestsProcessor worker ...");
                    this.task = RP.scheduleAtFixedRate((Runnable)new Worker(), 0L, (long)this.pollTimeout, this.pollTimeoutUnit);
                }
            }
            finally {
                this.taskLock.unlock();
            }
        }
        return true;
    }

    @Override
    public void processRequest(SQLRequest request) throws SQLException {
        request.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker() {
        this.taskLock.lock();
        try {
            if (this.isActive.compareAndSet(true, false)) {
                log.fine("Stopping SQLRequestsProcessor worker ...");
                this.task.cancel(true);
                this.task = null;
            }
        }
        finally {
            this.taskLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        while (true) {
            this.lock.lock();
            try {
                if (this.queue.isEmpty()) {
                    return;
                }
                this.queueProcessingDone.await();
                continue;
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    private class Worker
    implements Runnable {
        private boolean isInterrupted;
        private int idleLoops = 0;
        private final List<SQLRequest> requests = new LinkedList<SQLRequest>();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SQLRequestsProcessorImpl.this.isActive.get() || this.isInterrupted()) {
                return;
            }
            SQLRequestsProcessorImpl.this.lock.lock();
            try {
                int count = SQLRequestsProcessorImpl.this.queue.drainTo(this.requests, SQLRequestsProcessorImpl.this.pollRequests);
                if (count == 0) {
                    log.log(Level.FINE, "SQLQueueProcessor is empty {0}", this.idleLoops);
                    if (++this.idleLoops > SQLRequestsProcessorImpl.this.maxIdleLoops) {
                        SQLRequestsProcessorImpl.this.stopWorker();
                    }
                    return;
                }
                this.idleLoops = 0;
                if (count == SQLRequestsProcessorImpl.this.pollRequests) {
                    log.fine("SQLQueueProcessor is overload... ");
                } else {
                    log.log(Level.FINE, "SQLQueueProcessor load is {0}... ", count);
                }
                for (SQLRequest request : this.requests) {
                    if (this.isInterrupted()) break;
                    try {
                        request.execute();
                    }
                    catch (Throwable th) {
                        Exceptions.printStackTrace((Throwable)th);
                    }
                }
                this.requests.clear();
                SQLRequestsProcessorImpl.this.queueProcessingDone.signalAll();
            }
            finally {
                SQLRequestsProcessorImpl.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isInterrupted() {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
            this.isInterrupted |= Thread.currentThread().isInterrupted();
            if (this.isInterrupted) {
                SQLRequestsProcessorImpl.this.lock.lock();
                try {
                    SQLRequestsProcessorImpl.this.queue.clear();
                    SQLRequestsProcessorImpl.this.queueProcessingDone.signalAll();
                }
                finally {
                    SQLRequestsProcessorImpl.this.lock.unlock();
                }
            }
            return this.isInterrupted;
        }
    }
}

