/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.ProjectDefaultHtmlSourceVersionController;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class HtmlHintsProvider
implements HintsProvider {
    private static final HtmlRule ERROR_RULE = new HtmlRule(HintSeverity.ERROR, true);
    private static final HtmlRule WARNING_RULE = new HtmlRule(HintSeverity.WARNING, true);
    private static final HtmlRule INFO_RULE = new HtmlRule(HintSeverity.INFO, true);
    static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        HtmlVersion version = result.getDetectedHtmlVersion();
        FileObject file = result.getSnapshot().getSource().getFileObject();
        Project project = file != null ? FileOwnerQuery.getOwner((FileObject)file) : null;
        boolean xhtml = result.getSyntaxAnalyzerResult().mayBeXhtml();
        if (version == null) {
            if (project == null) {
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_CANNOT_DETERMINE_HTML_VERSION_NO_PROJECT"), file, new OffsetRange(0, 0), Collections.emptyList(), 100){});
            } else {
                HtmlVersion defaulted = ProjectDefaultHtmlSourceVersionController.getDefaultHtmlVersion(project, xhtml);
                String msg = defaulted == null ? NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION" : "MSG_CANNOT_DETERMINE_HTML_VERSION")) : NbBundle.getMessage(HtmlHintsProvider.class, (String)(xhtml ? "MSG_CANNOT_DETERMINE_XHTML_VERSION_DEFAULTED_ALREADY" : "MSG_CANNOT_DETERMINE_HTML_VERSION_DEFAULTED_ALREADY"), (Object)defaulted.getDisplayName());
                hints.add(new Hint((Rule)HtmlHintsProvider.getRule(Severity.INFO), msg, file, new OffsetRange(0, 0), HtmlHintsProvider.generateSetDefaultHtmlVersionHints(project, result.getSnapshot().getSource().getDocument(false), xhtml), 100){});
            }
        }
    }

    private static List<HintFix> generateSetDefaultHtmlVersionHints(Project project, Document doc, boolean xhtml) {
        LinkedList<HintFix> fixes = new LinkedList<HintFix>();
        if (project != null) {
            for (HtmlVersion v : HtmlVersion.values()) {
                if (xhtml != v.isXhtml()) continue;
                fixes.add(new SetDefaultHtmlVersionHintFix(v, project, doc, xhtml));
            }
        }
        return fixes;
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            ext.computeSelectionHints(manager, context, suggestions, start, end);
        }
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        Snapshot snapshot = context.parserResult.getSnapshot();
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        SyntaxAnalyzerResult saresult = result.getSyntaxAnalyzerResult();
        FileObject fo = snapshot.getSource().getFileObject();
        if (HtmlHintsProvider.isErrorCheckingEnabled(saresult)) {
            for (Error e : context.parserResult.getDiagnostics()) {
                assert (e.getDescription() != null);
                ArrayList<Object> fixes = new ArrayList<Object>(3);
                if (!HtmlHintsProvider.isErrorCheckingDisabledForFile(saresult)) {
                    fixes.add(new DisableErrorChecksFix(snapshot));
                }
                if (HtmlHintsProvider.isErrorCheckingEnabledForMimetype(saresult)) {
                    fixes.add(new DisableErrorChecksForMimetypeFix(saresult));
                }
                int astFrom = e.getStartPosition();
                int astTo = e.getEndPosition();
                int from = snapshot.getOriginalOffset(astFrom);
                int to = snapshot.getOriginalOffset(astTo);
                if (from == -1 && to == -1) continue;
                if (from == -1 && to != -1) {
                    from = to;
                } else if (from != -1 && to == -1) {
                    to = from;
                }
                Hint h = new Hint((Rule)HtmlHintsProvider.getRule(e.getSeverity()), e.getDescription(), e.getFile(), new OffsetRange(from, to), fixes, 20);
                hints.add(h);
            }
        } else {
            ArrayList<Object> fixes = new ArrayList<Object>(3);
            if (HtmlHintsProvider.isErrorCheckingDisabledForFile(saresult)) {
                fixes.add(new EnableErrorChecksFix(snapshot));
            }
            if (!HtmlHintsProvider.isErrorCheckingEnabledForMimetype(saresult)) {
                fixes.add(new EnableErrorChecksForMimetypeFix(saresult));
            }
            Hint h = new Hint((Rule)new HtmlRule(HintSeverity.INFO, false), NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE_DESCR"), fo, new OffsetRange(0, 0), fixes, 50);
            hints.add(h);
        }
        for (HtmlExtension ext : HtmlExtension.getRegisteredExtensions(context.parserResult.getSnapshot().getSource().getMimeType())) {
            ext.computeErrors(manager, context, hints, unhandled);
        }
    }

    private static Collection<HintFix> getCustomHintFixesForError(final RuleContext context, final Error e) {
        ArrayList<HintFix> fixes = new ArrayList<3>();
        if (e.getKey().equals("missing_required_attribute")) {
            fixes.add(new HintFix(){

                public String getDescription() {
                    return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_GENERATE_REQUIRED_ATTRIBUTES");
                }

                public void implement() throws Exception {
                    AstNode node = HtmlParserResult.getBoundAstNode(e);
                    Collection missingAttrs = (Collection)node.getProperty("missing_required_attribute");
                    assert (missingAttrs != null);
                    int astOffset = node.startOffset() + 1 + node.name().length();
                    int insertOffset = context.parserResult.getSnapshot().getOriginalOffset(astOffset);
                    if (insertOffset == -1) {
                        return;
                    }
                    StringBuilder templateText = new StringBuilder();
                    templateText.append(' ');
                    for (String attr : missingAttrs) {
                        templateText.append(attr);
                        templateText.append('=');
                        templateText.append('\"');
                        templateText.append("${");
                        templateText.append(attr);
                        templateText.append(" default=\"\"}");
                        templateText.append('\"');
                        templateText.append(' ');
                    }
                    templateText.append("${cursor}");
                    CodeTemplate ct = CodeTemplateManager.get((Document)context.doc).createTemporary(templateText.toString());
                    JTextComponent pane = EditorRegistry.focusedComponent();
                    if (pane != null) {
                        pane.setCaretPosition(insertOffset);
                        ct.insert(pane);
                    }
                }

                public boolean isSafe() {
                    return true;
                }

                public boolean isInteractive() {
                    return false;
                }
            });
        } else {
            fixes = Collections.emptyList();
        }
        return fixes;
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new RuleContext();
    }

    private static HtmlRule getRule(Severity s) {
        switch (s) {
            case INFO: {
                return INFO_RULE;
            }
            case WARNING: {
                return WARNING_RULE;
            }
            case ERROR: {
                return ERROR_RULE;
            }
        }
        throw new AssertionError((Object)"Unexpected severity level");
    }

    private static boolean isErrorCheckingEnabled(SyntaxAnalyzerResult result) {
        return !HtmlHintsProvider.isErrorCheckingDisabledForFile(result) && HtmlHintsProvider.isErrorCheckingEnabledForMimetype(result);
    }

    private static boolean isErrorCheckingDisabledForFile(SyntaxAnalyzerResult result) {
        FileObject fo = result.getSource().getSourceFileObject();
        return fo != null && fo.getAttribute(DISABLE_ERROR_CHECKS_KEY) != null;
    }

    private static boolean isErrorCheckingEnabledForMimetype(SyntaxAnalyzerResult result) {
        return HtmlPreferences.isHtmlErrorCheckingEnabledForMimetype(HtmlHintsProvider.getWebPageMimeType(result));
    }

    private static String getWebPageMimeType(SyntaxAnalyzerResult result) {
        String mimeType;
        InstanceContent ic = new InstanceContent();
        ic.add((Object)result);
        WebPageMetadata wpmeta = WebPageMetadata.getMetadata((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        if (wpmeta != null && (mimeType = (String)wpmeta.value("mimeType")) != null) {
            return mimeType;
        }
        FileObject fo = result.getSource().getSourceFileObject();
        if (fo != null) {
            return fo.getMIMEType();
        }
        return result.getSource().getSnapshot().getMimeType();
    }

    private static void forceReparse(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static class SetDefaultHtmlVersionHintFix
    implements HintFix {
        private HtmlVersion version;
        private Document doc;
        private Project project;
        private boolean xhtml;

        public SetDefaultHtmlVersionHintFix(HtmlVersion version, Project project, Document doc, boolean xhtml) {
            this.version = version;
            this.project = project;
            this.doc = doc;
            this.xhtml = xhtml;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_SET_DEFAULT_HTML_VERSION", (Object)this.version.getDisplayName());
        }

        public void implement() throws Exception {
            ProjectDefaultHtmlSourceVersionController.setDefaultHtmlVersion(this.project, this.version, this.xhtml);
            HtmlHintsProvider.forceReparse(this.doc);
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class EnableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public EnableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_MIMETYPE", (Object)this.getMimeType());
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.getMimeType(), true);
            Document doc = this.getSnapshot().getSource().getDocument(false);
            if (doc != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }
    }

    private static final class DisableErrorChecksForMimetypeFix
    extends AbstractErrorChecksForMimetypeFix {
        public DisableErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            super(result);
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_MIMETYPE", (Object)this.getMimeType());
        }

        public void implement() throws Exception {
            HtmlPreferences.setHtmlErrorChecking(this.getMimeType(), false);
            Document doc = this.getSnapshot().getSource().getDocument(false);
            if (doc != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }
    }

    private static abstract class AbstractErrorChecksForMimetypeFix
    implements HintFix {
        private SyntaxAnalyzerResult result;

        public AbstractErrorChecksForMimetypeFix(SyntaxAnalyzerResult result) {
            this.result = result;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        protected String getMimeType() {
            return HtmlHintsProvider.getWebPageMimeType(this.result);
        }

        protected Snapshot getSnapshot() {
            return this.result.getSource().getSnapshot();
        }
    }

    private static final class EnableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public EnableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_ENABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, null);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class DisableErrorChecksFix
    implements HintFix {
        private Snapshot snapshot;

        public DisableErrorChecksFix(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public String getDescription() {
            return NbBundle.getMessage(HtmlHintsProvider.class, (String)"MSG_HINT_DISABLE_ERROR_CHECKS_FILE");
        }

        public void implement() throws Exception {
            Document doc;
            FileObject fo = this.snapshot.getSource().getFileObject();
            if (fo != null) {
                fo.setAttribute(HtmlHintsProvider.DISABLE_ERROR_CHECKS_KEY, (Object)Boolean.TRUE);
            }
            if ((doc = this.snapshot.getSource().getDocument(false)) != null) {
                HtmlHintsProvider.forceReparse(doc);
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class HtmlRule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private HtmlRule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "html";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

