/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.dtd.spi.ReaderProvider;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class NbReaderProvider
implements ReaderProvider {
    private static final String CATALOG_FILE_NAME = "catalog";
    private Map<String, String> mapping = new HashMap<String, String>();
    private FileObject dtdSetFolder;

    @Deprecated
    public static synchronized void setupReaders() {
        Logger.global.log(Level.INFO, "Please remove the call to NbReaderProvider.setupReaders(), it is not necessary anymore.", new Exception());
    }

    public NbReaderProvider(FileObject folder) {
        this.dtdSetFolder = folder;
        this.initialize();
    }

    public Collection<String> getIdentifiers() {
        return this.mapping.keySet();
    }

    public Reader getReaderForIdentifier(String identifier, String filename) {
        FileObject file = this.getSystemId(identifier);
        if (file == null) {
            return null;
        }
        try {
            return new InputStreamReader(file.getInputStream());
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    public boolean isXMLContent(String identifier) {
        return HtmlVersion.find((String)identifier, null).isXhtml();
    }

    public FileObject getSystemId(String publicId) {
        String fileName = this.mapping.get(publicId);
        if (fileName == null) {
            return null;
        }
        if (this.dtdSetFolder == null) {
            return null;
        }
        FileObject file = this.dtdSetFolder.getFileObject(fileName);
        return file;
    }

    private void initialize() {
        FileObject catalog = this.dtdSetFolder.getFileObject(CATALOG_FILE_NAME);
        if (catalog != null) {
            try {
                this.mapping.putAll(this.parseCatalog(new InputStreamReader(catalog.getInputStream())));
            }
            catch (FileNotFoundException exc) {
                Exceptions.printStackTrace((Throwable)exc);
            }
        }
    }

    private Map<String, String> parseCatalog(Reader catalogReader) {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        LineNumberReader reader = new LineNumberReader(catalogReader);
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException exc) {
                return null;
            }
            if (line == null) break;
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens() || !"PUBLIC".equals(st.nextToken()) || !st.hasMoreTokens()) continue;
            st.nextToken("\"");
            if (!st.hasMoreTokens()) continue;
            String id = st.nextToken("\"");
            if (!st.hasMoreTokens()) continue;
            st.nextToken(" \t\n\r\f");
            if (!st.hasMoreTokens()) continue;
            String file = st.nextToken();
            hashmap.put(id, file);
        }
        return hashmap;
    }
}

