/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionDoc;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyType;
import org.netbeans.modules.spring.util.SpringBeansUIs;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

public abstract class SpringXMLConfigCompletionItem
implements CompletionItem {
    protected int substitutionOffset;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    private static final String UNKNOWN = "<unknown>";
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";

    public static SpringXMLConfigCompletionItem createBeanRefItem(int substitutionOffset, String displayName, SpringBean bean, FileObject containerFO) {
        return new BeanRefItem(substitutionOffset, displayName, bean, containerFO);
    }

    public static SpringXMLConfigCompletionItem createPackageItem(int substitutionOffset, String packageName, boolean deprecated) {
        return new PackageItem(substitutionOffset, packageName, deprecated);
    }

    public static SpringXMLConfigCompletionItem createTypeItem(int substitutionOffset, TypeElement elem, ElementHandle<TypeElement> elemHandle, boolean deprecated, boolean smartItem) {
        return new ClassItem(substitutionOffset, elem, elemHandle, deprecated, smartItem);
    }

    public static SpringXMLConfigCompletionItem createMethodItem(int substitutionOffset, ExecutableElement element, boolean isInherited, boolean isDeprecated) {
        return new MethodItem(substitutionOffset, element, isInherited, isDeprecated);
    }

    public static SpringXMLConfigCompletionItem createPropertyItem(int substitutionOffset, Property property) {
        return new PropertyItem(substitutionOffset, property);
    }

    public static SpringXMLConfigCompletionItem createAttribValueItem(int substitutionOffset, String displayText, String docText) {
        return new AttribValueItem(substitutionOffset, displayText, docText);
    }

    public static SpringXMLConfigCompletionItem createFolderItem(int substitutionOffset, FileObject folder) {
        return new FolderItem(substitutionOffset, folder);
    }

    public static SpringXMLConfigCompletionItem createSpringXMLFileItem(int substitutionOffset, FileObject file) {
        return new FileItem(substitutionOffset, file);
    }

    public static SpringXMLConfigCompletionItem createPropertyAttribItem(int substitutionOffset, String text, Property property) {
        return new PropertyAttribItem(substitutionOffset, text, property);
    }

    public static SpringXMLConfigCompletionItem createBeanNameItem(int substitutionOffset, String text, int sortPriority) {
        return new BeanNameItem(substitutionOffset, text, sortPriority);
    }

    protected SpringXMLConfigCompletionItem(int substitutionOffset) {
        this.substitutionOffset = substitutionOffset;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
        }
    }

    protected void substituteText(JTextComponent c, final int offset, final int len, String toAdd) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        CharSequence prefix = this.getSubstitutionText();
        String text = ((Object)prefix).toString();
        if (toAdd != null) {
            text = text + toAdd;
        }
        final String finalText = text;
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    Position position = doc.createPosition(offset);
                    doc.remove(offset, len);
                    doc.insertString(position.getOffset(), finalText.toString(), null);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    protected CharSequence getSubstitutionText() {
        return this.getInsertPrefix();
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    public static CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static CharSequence getTypeName(TypeMirror type, boolean fqn) {
        return SpringXMLConfigCompletionItem.getTypeName(type, fqn, false);
    }

    public static CharSequence getTypeName(TypeMirror type, boolean fqn, boolean varArg) {
        if (type == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(varArg).visit(type, fqn);
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static class JavaElementDocQuery
    extends AsyncCompletionQuery {
        private ElementHandle<?> elemHandle;

        public JavaElementDocQuery(ElementHandle<?> elemHandle) {
            this.elemHandle = elemHandle;
        }

        protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                JavaSource js = JavaUtils.getJavaSource(doc);
                if (js == null) {
                    return;
                }
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = JavaElementDocQuery.this.elemHandle.resolve((CompilationInfo)cc);
                        if (element == null) {
                            return;
                        }
                        SpringXMLConfigCompletionDoc doc = SpringXMLConfigCompletionDoc.createJavaDoc(cc, element);
                        resultSet.setDocumentation((CompletionDocumentation)doc);
                    }
                }, false);
                resultSet.finish();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(SpringXMLConfigCompletionItem.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !SpringXMLConfigCompletionItem.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getLowerBound();
            if (bound != null && bound.getKind() != TypeKind.NULL) {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            } else {
                bound = t.getUpperBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.TYPEVAR) {
                        bound = ((TypeVariable)bound).getLowerBound();
                    }
                    this.visit(bound, p);
                }
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else {
                    bound = SourceUtils.getBound((WildcardType)t);
                    if (!(bound == null || bound.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        this.visit(bound, p);
                    }
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }

    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }
    }

    private static class FileItem
    extends SpringXMLConfigCompletionItem {
        private FileObject file;

        public FileItem(int substitutionOffset, FileObject file) {
            super(substitutionOffset);
            this.file = file;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.file.getNameExt();
        }

        public CharSequence getInsertPrefix() {
            return this.file.getNameExt();
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/spring/beans/resources/spring.png", (boolean)false);
        }

        @Override
        protected String getLeftHtmlText() {
            return this.file.getNameExt();
        }
    }

    private static class PropertyAttribItem
    extends PropertyItem {
        private String text;

        public PropertyAttribItem(int substitutionOffset, String text, Property property) {
            super(substitutionOffset, property);
            this.text = text;
        }

        @Override
        public int getSortPriority() {
            return 200;
        }

        @Override
        public CharSequence getSortText() {
            return this.text;
        }

        @Override
        public CharSequence getInsertPrefix() {
            return this.text;
        }

        @Override
        protected CharSequence getSubstitutionText() {
            return this.text + "=\"\"";
        }

        @Override
        protected String getLeftHtmlText() {
            return this.text;
        }

        @Override
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            super.substituteText(c, offset, len, toAdd);
            int newCaretPos = c.getCaretPosition() - 1;
            c.setCaretPosition(newCaretPos);
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    private static class PropertyItem
    extends SpringXMLConfigCompletionItem {
        private static final String PROP_RO = "org/netbeans/modules/beans/resources/propertyRO.gif";
        private static final String PROP_RW = "org/netbeans/modules/beans/resources/propertyRW.gif";
        private static final String PROP_WO = "org/netbeans/modules/beans/resources/propertyWO.gif";
        private String displayName;
        private PropertyType propertyType;
        private String typeName;
        private static EnumMap<PropertyType, ImageIcon> type2Icon = new EnumMap(PropertyType.class);

        public PropertyItem(int substitutionOffset, Property property) {
            super(substitutionOffset);
            this.displayName = property.getName();
            this.typeName = SpringXMLConfigCompletionItem.escape(((Object)PropertyItem.getTypeName(property.getImplementationType(), false)).toString());
            this.propertyType = property.getType();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayName;
        }

        @Override
        protected String getRightHtmlText() {
            return this.typeName;
        }

        @Override
        protected ImageIcon getIcon() {
            ImageIcon cachedIcon = type2Icon.get((Object)this.propertyType);
            if (cachedIcon == null) {
                switch (this.propertyType) {
                    case READ_ONLY: {
                        cachedIcon = ImageUtilities.loadImageIcon((String)PROP_RO, (boolean)false);
                        break;
                    }
                    case READ_WRITE: {
                        cachedIcon = ImageUtilities.loadImageIcon((String)PROP_RW, (boolean)false);
                        break;
                    }
                    case WRITE_ONLY: {
                        cachedIcon = ImageUtilities.loadImageIcon((String)PROP_WO, (boolean)false);
                    }
                }
                type2Icon.put(this.propertyType, cachedIcon);
            }
            return cachedIcon;
        }
    }

    private static class FolderItem
    extends SpringXMLConfigCompletionItem {
        private FileObject folder;
        private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
        private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";

        public FolderItem(int substitutionOffset, FileObject folder) {
            super(substitutionOffset);
            this.folder = folder;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 400 && evt.getKeyChar() == '/') {
                Completion.get().hideDocumentation();
                JTextComponent component = (JTextComponent)evt.getSource();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()));
                Completion.get().showCompletion();
                evt.consume();
            }
        }

        public int getSortPriority() {
            return 300;
        }

        public CharSequence getSortText() {
            return this.folder.getName();
        }

        public CharSequence getInsertPrefix() {
            return this.folder.getName();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        @Override
        protected ImageIcon getIcon() {
            return new ImageIcon(FolderItem.getTreeFolderIcon());
        }

        @Override
        protected String getLeftHtmlText() {
            return this.folder.getName();
        }

        private static Image getTreeFolderIcon() {
            Image base = null;
            Icon baseIcon = UIManager.getIcon(ICON_KEY_UIMANAGER);
            if (baseIcon != null) {
                base = ImageUtilities.icon2Image((Icon)baseIcon);
            } else {
                base = (Image)UIManager.get(ICON_KEY_UIMANAGER_NB);
                if (base == null) {
                    Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
                    base = n.getIcon(1);
                }
            }
            assert (base != null);
            return base;
        }
    }

    private static class BeanNameItem
    extends AttribValueItem {
        private final int sortPriority;

        public BeanNameItem(int substitutionOffset, String displayText, int sortPriority) {
            super(substitutionOffset, displayText, null);
            this.sortPriority = sortPriority;
        }

        @Override
        public int getSortPriority() {
            return this.sortPriority;
        }
    }

    private static class AttribValueItem
    extends SpringXMLConfigCompletionItem {
        private String displayText;
        private String docText;

        public AttribValueItem(int substitutionOffset, String displayText, String docText) {
            super(substitutionOffset);
            this.displayText = displayText;
            this.docText = docText;
        }

        public int getSortPriority() {
            return 50;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    if (AttribValueItem.this.docText != null) {
                        SpringXMLConfigCompletionDoc documentation = SpringXMLConfigCompletionDoc.getAttribValueDoc(AttribValueItem.this.docText);
                        resultSet.setDocumentation((CompletionDocumentation)documentation);
                    }
                    resultSet.finish();
                }
            });
        }
    }

    private static class MethodItem
    extends SpringXMLConfigCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isPrimitive;
        private String typeName;
        private String sortText;
        private String leftText;
        private boolean isInherited;
        private String rightText;
        private static final int PUBLIC_LEVEL = 3;
        private static final int PROTECTED_LEVEL = 2;
        private static final int PACKAGE_LEVEL = 1;
        private static final int PRIVATE_LEVEL = 0;

        public MethodItem(int substitutionOffset, ExecutableElement element, boolean isInherited, boolean isDeprecated) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)element);
            this.isDeprecated = isDeprecated;
            this.isInherited = isInherited;
            this.simpleName = element.getSimpleName().toString();
            this.modifiers = element.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> it = element.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = ((ExecutableType)element.asType()).getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext()) {
                TypeMirror tm = tIt.next();
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)MethodItem.getTypeName(tm, false, element.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            TypeMirror retType = element.getReturnType();
            this.typeName = ((Object)MethodItem.getTypeName(retType, false)).toString();
            this.isPrimitive = retType.getKind().isPrimitive() || retType.getKind() == TypeKind.VOID;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc param = it.next();
                    sortParams.append(param.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(METHOD_COLOR);
                if (!this.isInherited) {
                    lText.append(SpringXMLConfigCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    lText.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated) {
                    lText.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    lText.append(SpringXMLConfigCompletionItem.BOLD_END);
                }
                lText.append(SpringXMLConfigCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(SpringXMLConfigCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(SpringXMLConfigCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                return lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = SpringXMLConfigCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        @Override
        protected ImageIcon getIcon() {
            int level = MethodItem.getProtectionLevel(this.modifiers);
            boolean isStatic = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon cachedIcon = icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = METHOD_PUBLIC;
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            MethodItem.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaElementDocQuery(this.elementHandle), EditorRegistry.lastFocusedComponent());
        }

        private static int getProtectionLevel(Set<Modifier> modifiers) {
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                return 3;
            }
            if (modifiers.contains((Object)Modifier.PROTECTED)) {
                return 2;
            }
            if (modifiers.contains((Object)Modifier.PRIVATE)) {
                return 0;
            }
            return 1;
        }

        static class ParamDesc {
            private String fullTypeName;
            private String typeName;
            private String name;

            public ParamDesc(String fullTypeName, String typeName, String name) {
                this.fullTypeName = fullTypeName;
                this.typeName = typeName;
                this.name = name;
            }
        }
    }

    private static class PackageItem
    extends SpringXMLConfigCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean deprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        public PackageItem(int substitutionOffset, String packageFQN, boolean deprecated) {
            super(substitutionOffset);
            int idx = packageFQN.lastIndexOf(46);
            this.simpleName = idx < 0 ? packageFQN : packageFQN.substring(idx + 1);
            this.deprecated = deprecated;
            this.sortText = this.simpleName + "#" + packageFQN;
        }

        public int getSortPriority() {
            return 50;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 400 && evt.getKeyChar() == '.') {
                Completion.get().hideDocumentation();
                JTextComponent component = (JTextComponent)evt.getSource();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()));
                Completion.get().showCompletion();
                evt.consume();
            }
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(PACKAGE_COLOR);
                if (this.deprecated) {
                    sb.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.deprecated) {
                    sb.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                sb.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }
    }

    private static class ClassItem
    extends SpringXMLConfigCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private ElementHandle<TypeElement> elemHandle;
        private boolean deprecated;
        private String displayName;
        private String enclName;
        private String sortText;
        private String leftText;
        private boolean smartItem;

        public ClassItem(int substitutionOffset, TypeElement elem, ElementHandle<TypeElement> elemHandle, boolean deprecated, boolean smartItem) {
            super(substitutionOffset);
            this.elemHandle = elemHandle;
            this.deprecated = deprecated;
            this.displayName = smartItem ? elem.getSimpleName().toString() : this.getRelativeName(elem);
            this.enclName = ((Object)ClassItem.getElementName(elem.getEnclosingElement(), true)).toString();
            this.sortText = this.displayName + ClassItem.getImportanceLevel(this.enclName) + "#" + this.enclName;
            this.smartItem = smartItem;
        }

        private String getRelativeName(TypeElement elem) {
            StringBuilder sb = new StringBuilder();
            sb.append(elem.getSimpleName().toString());
            Element parent = elem.getEnclosingElement();
            while (parent.getKind() != ElementKind.PACKAGE) {
                sb.insert(0, parent.getSimpleName().toString() + "$");
                parent = parent.getEnclosingElement();
            }
            return sb.toString();
        }

        public int getSortPriority() {
            return 200;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.smartItem ? "" : this.elemHandle.getBinaryName();
        }

        @Override
        protected CharSequence getSubstitutionText() {
            return this.elemHandle.getBinaryName();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getColor());
                if (this.deprecated) {
                    sb.append(SpringXMLConfigCompletionItem.STRIKE);
                }
                sb.append(this.displayName);
                if (this.deprecated) {
                    sb.append(SpringXMLConfigCompletionItem.STRIKE_END);
                }
                if (this.smartItem && this.enclName != null && this.enclName.length() > 0) {
                    sb.append(SpringXMLConfigCompletionItem.COLOR_END);
                    sb.append(PKG_COLOR);
                    sb.append(" (");
                    sb.append(this.enclName);
                    sb.append(")");
                }
                sb.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)CLASS, (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaElementDocQuery(this.elemHandle), EditorRegistry.lastFocusedComponent());
        }
    }

    private static class BeanRefItem
    extends SpringXMLConfigCompletionItem {
        private static final String CLASS_COLOR = "<font color=#808080>";
        private String beanId;
        private String beanClass;
        private List<String> beanNames;
        private String displayName;
        private String beanLocFile;
        private Action goToBeanAction;
        private String leftText;

        public BeanRefItem(int substitutionOffset, String displayName, SpringBean bean, FileObject containerFO) {
            super(substitutionOffset);
            File file;
            FileObject fo;
            this.beanId = bean.getId();
            this.beanClass = bean.getClassName();
            this.beanNames = bean.getNames();
            if (bean.getLocation() != null && (fo = FileUtil.toFileObject((File)(file = bean.getLocation().getFile()))) != null) {
                this.beanLocFile = FileUtil.getRelativePath((FileObject)containerFO.getParent(), (FileObject)fo);
            }
            this.goToBeanAction = SpringBeansUIs.createGoToBeanAction(bean);
            this.displayName = displayName;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.displayName);
                sb.append(CLASS_COLOR);
                sb.append(" (");
                if (this.beanClass != null) {
                    sb.append(this.beanClass);
                }
                sb.append(")");
                sb.append(SpringXMLConfigCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        @Override
        protected String getRightHtmlText() {
            return this.beanLocFile;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/spring/beans/resources/spring-bean.png", (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    SpringXMLConfigCompletionDoc docItem = SpringXMLConfigCompletionDoc.createBeanRefDoc(BeanRefItem.this.beanId, BeanRefItem.this.beanNames, BeanRefItem.this.beanClass, BeanRefItem.this.beanLocFile, BeanRefItem.this.goToBeanAction);
                    resultSet.setDocumentation((CompletionDocumentation)docItem);
                    resultSet.finish();
                }
            });
        }
    }
}

