/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryType;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.InstallationException;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class DownloadInstallationDataAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.description");
    public static final String DEFAULT_PROGRESS_TITLE_LOCAL = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.progress.local.title");
    public static final String PROGRESS_TITLE_LOCAL_PROPERTY = "progress.title.local";
    public static final String DEFAULT_PROGRESS_TITLE_REMOTE = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.progress.remote.title");
    public static final String PROGRESS_TITLE_REMOTE_PROPERTY = "progress.title.remote";
    public static final String DEFAULT_DOWNLOAD_FAILED_EXCEPTION = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.failed");
    public static final String DOWNLOAD_FAILED_EXCEPTION_PROPERTY = "download.failed";
    public static final String DEFAULT_DEPENDENT_FAILED_EXCEPTION = ResourceUtils.getString(DownloadInstallationDataAction.class, "DIDA.dependent.failed");
    public static final String DEPENDENT_FAILED_EXCEPTION_PROPERTY = "download.dependent.failed";
    private CompositeProgress overallProgress;
    private Progress currentProgress;

    public DownloadInstallationDataAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(PROGRESS_TITLE_LOCAL_PROPERTY, DEFAULT_PROGRESS_TITLE_LOCAL);
        this.setProperty(PROGRESS_TITLE_REMOTE_PROPERTY, DEFAULT_PROGRESS_TITLE_REMOTE);
        this.setProperty(DOWNLOAD_FAILED_EXCEPTION_PROPERTY, DEFAULT_DOWNLOAD_FAILED_EXCEPTION);
        this.setProperty(DEPENDENT_FAILED_EXCEPTION_PROPERTY, DEFAULT_DEPENDENT_FAILED_EXCEPTION);
    }

    public void execute() {
        LogManager.logEntry("getting all installation data");
        Registry registry = Registry.getInstance();
        List<Product> products = registry.getProductsToInstall();
        int percentageChunk = 100 / products.size();
        int percentageLeak = 100 % products.size();
        this.overallProgress = new CompositeProgress();
        this.overallProgress.setPercentage(percentageLeak);
        this.overallProgress.synchronizeDetails(true);
        this.getWizardUi().setProgress(this.overallProgress);
        for (int i = 0; i < products.size(); ++i) {
            Product product = products.get(i);
            this.currentProgress = new Progress();
            this.overallProgress.addChild(this.currentProgress, percentageChunk);
            try {
                String prop = product.getRegistryType() == RegistryType.REMOTE ? PROGRESS_TITLE_REMOTE_PROPERTY : PROGRESS_TITLE_LOCAL_PROPERTY;
                String overallProgressTitle = StringUtils.format(this.getProperty(prop), product.getDisplayName());
                this.overallProgress.setTitle(overallProgressTitle);
                product.downloadData(this.currentProgress);
                if (this.isCanceled()) {
                    return;
                }
                SystemUtils.sleep(200L);
                continue;
            }
            catch (DownloadException e) {
                InstallationException error = new InstallationException(StringUtils.format(this.getProperty(DOWNLOAD_FAILED_EXCEPTION_PROPERTY), product.getDisplayName()), e);
                product.setStatus(Status.NOT_INSTALLED);
                product.setInstallationError(error);
                for (Product dependent : registry.getProducts()) {
                    if (dependent.getStatus() != Status.TO_BE_INSTALLED || !registry.satisfiesRequirement(product, dependent)) continue;
                    String exString = StringUtils.format(this.getProperty(DEPENDENT_FAILED_EXCEPTION_PROPERTY), dependent.getDisplayName(), product.getDisplayName());
                    InstallationException dependentError = new InstallationException(exString, error);
                    dependent.setStatus(Status.NOT_INSTALLED);
                    dependent.setInstallationError(dependentError);
                    products.remove(dependent);
                }
                LogManager.log(1, (Throwable)error);
            }
        }
        LogManager.logExit("... finished getting of the installation data");
    }

    public void cancel() {
        if (this.currentProgress != null) {
            this.currentProgress.setCanceled(true);
        }
        if (this.overallProgress != null) {
            this.overallProgress.setCanceled(true);
        }
        super.cancel();
    }

    public boolean canExecuteForward() {
        return Registry.getInstance().getProductsToInstall().size() > 0;
    }

    public boolean isPointOfNoReturn() {
        return true;
    }
}

