/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.resource.ResourceUtils;
import org.primefaces.util.ComponentUtils;

public class CoreRenderer
extends Renderer {
    private static final String WIDGET_VAR_PREFIX = "widget_";

    protected void renderScriptDependency(FacesContext facesContext, String scriptPath) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)ResourceUtils.getResourceURL(facesContext, scriptPath), null);
        writer.endElement("script");
    }

    protected void renderCSSDependency(FacesContext facesContext, String cssPath) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("href", (Object)ResourceUtils.getResourceURL(facesContext, cssPath), null);
        writer.endElement("link");
    }

    protected void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected String getActionURL(FacesContext facesContext) {
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
        return facesContext.getExternalContext().encodeResourceURL(actionURL);
    }

    protected String getResourceURL(FacesContext facesContext, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        return facesContext.getExternalContext().encodeResourceURL(url);
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected String createUniqueWidgetVar(FacesContext facesContext, UIComponent component) {
        String widgetVar = (String)component.getAttributes().get("widgetVar");
        if (widgetVar != null) {
            return widgetVar;
        }
        String regex = "-|" + UINamingContainer.getSeparatorChar((FacesContext)facesContext);
        String formattedClientId = component.getClientId(facesContext).replaceAll(regex, "_");
        return WIDGET_VAR_PREFIX + facesContext.getExternalContext().encodeNamespace(formattedClientId);
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public String getEscapedClientId(String clientId) {
        return clientId.replaceAll(":", "\\\\\\\\:");
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected String buildAjaxRequest(FacesContext facesContext, AjaxSource source, String formId, String decodeParam) {
        UIComponent component = (UIComponent)source;
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest('");
        req.append(this.getActionURL(facesContext));
        req.append("',{");
        req.append("formId:'");
        req.append(formId);
        req.append("'");
        if (source.isAsync()) {
            req.append(",async:true");
        }
        if (source.getOnstart() != null) {
            req.append(",onstart:function(xhr){" + source.getOnstart() + ";}");
        }
        if (source.getOnerror() != null) {
            req.append(",onerror:function(xhr, status, error){" + source.getOnerror() + ";}");
        }
        if (source.getOnsuccess() != null) {
            req.append(",onsuccess:function(data, status, xhr, args){" + source.getOnsuccess() + ";}");
        }
        if (source.getOncomplete() != null) {
            req.append(",oncomplete:function(xhr, status, args){" + source.getOncomplete() + ";}");
        }
        req.append(",global:" + source.isGlobal());
        req.append("},{");
        req.append("'" + decodeParam + "'");
        req.append(":");
        req.append("'" + decodeParam + "'");
        if (source.getUpdate() != null) {
            req.append(",'primefacesPartialUpdate':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, component, source.getUpdate()) + "'");
        }
        if (source.getProcess() != null) {
            req.append(",'primefacesPartialProcess':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, component, source.getProcess()) + "'");
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            req.append(",");
            req.append("'" + parameter.getName() + "'");
            req.append(":");
            req.append("'" + parameter.getValue() + "'");
        }
        req.append("});");
        req.append("return false;");
        return req.toString();
    }

    protected String buildNonAjaxRequest(FacesContext facesContext, UIComponent component, String formId, String decodeParam) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String process = (String)component.getAttributes().get("process");
        boolean isPartialProcess = process != null;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            params.put(parameter.getName(), parameter.getValue());
        }
        StringBuffer request = new StringBuffer();
        request.append("PrimeFaces.addSubmitParam('" + formId + "', {'" + decodeParam + "':'" + decodeParam + "'");
        if (!params.isEmpty() || isPartialProcess) {
            if (isPartialProcess) {
                request.append(",primefacesPartialProcess:'" + ComponentUtils.findClientIds(facesContext, component, process) + "'");
            }
            if (!params.isEmpty()) {
                for (String paramName : params.keySet()) {
                    Object paramValue = params.get(paramName);
                    String toSend = paramValue != null ? paramValue.toString() : "";
                    request.append(",'" + paramName + "':'" + toSend + "'");
                }
            }
        }
        request.append("});");
        request.append("jQuery(PrimeFaces.escapeClientId('" + formId + "')).submit();");
        return request.toString();
    }

    protected String escapeText(String value) {
        return value == null ? "" : value.replaceAll("'", "\\\\'");
    }
}

