/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class TabViewRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        TabView tabView;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String activeIndexValue = (String)params.get((tabView = (TabView)component).getClientId(facesContext) + "_activeIndex");
        if (!this.isValueEmpty(activeIndexValue)) {
            tabView.setActiveIndex(Integer.parseInt(activeIndexValue));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        this.encodeMarkup(facesContext, tabView);
        this.encodeScript(facesContext, tabView);
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        Tab activeTab = (Tab)((Object)tabView.getChildren().get(tabView.getActiveIndex()));
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        ResponseWriter writer = facesContext.getResponseWriter();
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"" + response.getCharacterEncoding() + "\"?>");
            writer.write("<partialResponse>");
            writer.write("<tabContent>");
            writer.startCDATA();
            this.renderChildren(facesContext, (UIComponent)activeTab);
            writer.endCDATA();
            writer.write("</tabContent>");
            writer.write("<state>");
            writer.startCDATA();
            StateManager stateManager = facesContext.getApplication().getStateManager();
            stateManager.writeState(facesContext, stateManager.saveView(facesContext));
            writer.endCDATA();
            writer.write("</state>");
            writer.write("</partialResponse>");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        facesContext.responseComplete();
    }

    private void encodeScript(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        String tabViewVar = this.createUniqueWidgetVar(facesContext, (UIComponent)tabView);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(tabViewVar + " = new PrimeFaces.widget.TabView('" + clientId + "', {");
        writer.write("selected:" + tabView.getActiveIndex());
        if (tabView.isDynamic()) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)tabView);
            if (form == null) {
                throw new FacesException("TabView " + clientId + " must be nested inside a form when dynamic content loading is enabled");
            }
            writer.write(",dynamic:true");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            writer.write(",cache:" + tabView.isCache());
        } else {
            writer.write(",dynamic:false");
        }
        if (tabView.isCollapsible()) {
            writer.write(",collapsible:true");
        }
        if (tabView.getEvent() != null) {
            writer.write(",event:'" + tabView.getEvent() + "'");
        }
        if (tabView.getEffect() != null) {
            writer.write(",fx: {");
            writer.write(tabView.getEffect() + ":'toggle'");
            writer.write(",duration:'" + tabView.getEffectDuration() + "'");
            writer.write("}");
        }
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        int activeIndex = tabView.getActiveIndex();
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeHeaders(facesContext, tabView, activeIndex);
        this.encodeContents(facesContext, tabView, activeIndex);
        this.encodeActiveIndexHolder(facesContext, tabView);
        writer.endElement("div");
    }

    private void encodeActiveIndexHolder(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String paramName = tabView.getClientId(facesContext) + "_activeIndex";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)paramName, null);
        writer.writeAttribute("name", (Object)paramName, null);
        writer.writeAttribute("value", (Object)tabView.getActiveIndex(), null);
        writer.endElement("input");
    }

    private void encodeHeaders(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", null);
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tabView.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)("#" + tab.getClientId(facesContext)), null);
            writer.startElement("em", null);
            writer.write(tab.getTitle());
            writer.endElement("em");
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void encodeContents(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tabView.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)tab.getClientId(facesContext), null);
            if (tabView.isDynamic()) {
                if (i == activeTabIndex) {
                    this.renderChildren(facesContext, (UIComponent)tab);
                }
            } else {
                this.renderChildren(facesContext, (UIComponent)tab);
            }
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

