/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabslider;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tabslider.TabSlider;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;

public class TabSliderRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(TabSliderRenderer.class.getName());

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        logger.info("TabSlider is deprecated, use Carousel instead");
        TabSlider slider = (TabSlider)component;
        this.encodeMarkup(facesContext, slider);
        this.encodeScript(facesContext, slider);
    }

    private void encodeScript(FacesContext facesContext, TabSlider slider) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = slider.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)slider);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.TabSlider('" + clientId + "', {");
        writer.write("easing:'" + slider.getEffect() + "'");
        this.encodeHeaders(facesContext, slider);
        if (slider.getActiveIndex() != 1) {
            writer.write(",activeIndex:" + slider.getActiveIndex());
        }
        if (slider.getEffectDuration() != 600) {
            writer.write(",animationTime:" + slider.getEffectDuration());
        }
        if (!slider.isNavigator()) {
            writer.write(",buildNavigation:false");
        }
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeHeaders(FacesContext facesContext, TabSlider slider) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write(",navHeaders:new Array(");
        Iterator kids = slider.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.write("'" + tab.getTitle() + "'");
            if (!kids.hasNext()) continue;
            writer.write(",");
        }
        writer.write(")");
    }

    private void encodeMarkup(FacesContext facesContext, TabSlider slider) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = slider.getClientId(facesContext);
        String styleClass = slider.getStyleClass() == null ? "pf-tabslider" : "pf-tabslider " + slider.getStyleClass();
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (slider.getStyle() != null) {
            writer.writeAttribute("style", (Object)slider.getStyle(), null);
        }
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("class", (Object)"wrapper", null);
        writer.startElement("ul", (UIComponent)slider);
        for (UIComponent kid : slider.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("li", null);
            this.renderChild(facesContext, (UIComponent)tab);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

