/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spinner;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class SpinnerRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Spinner spinner = (Spinner)component;
        String clientId = spinner.getClientId(facesContext);
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId);
        spinner.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Spinner spinner = (Spinner)component;
        facesContext.getResponseWriter().write("<!--[if IE 8.0]><style type=\"text/css\">.ui-spinner {border:1px solid transparent;}</style><![endif]-->");
        this.encodeMarkup(facesContext, spinner);
        this.encodeScript(facesContext, spinner);
    }

    protected void encodeScript(FacesContext facesContext, Spinner spinner) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = spinner.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).spinner({");
        writer.write("step:" + spinner.getStepFactor());
        if (spinner.getMin() != Double.MIN_VALUE) {
            writer.write(",min:" + spinner.getMin());
        }
        if (spinner.getMax() != Double.MAX_VALUE) {
            writer.write(",max:" + spinner.getMax());
        }
        if (spinner.getWidth() != Integer.MIN_VALUE) {
            writer.write(",width:" + spinner.getWidth());
        }
        if (spinner.getShowOn() != null) {
            writer.write(",showOn:'" + spinner.getShowOn() + "'");
        }
        if (spinner.getPrefix() != null) {
            writer.write(",prefix:'" + spinner.getPrefix() + "'");
        }
        if (spinner.getSuffix() != null) {
            writer.write(",suffix:'" + spinner.getSuffix() + "'");
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Spinner spinner) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = spinner.getClientId(facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(facesContext, (UIComponent)spinner);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)spinner, HTML.INPUT_TEXT_ATTRS);
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        Spinner spinner = (Spinner)component;
        String value = (String)submittedValue;
        Converter converter = spinner.getConverter();
        if (converter != null) {
            return converter.getAsObject(facesContext, (UIComponent)spinner, value);
        }
        Class valueType = spinner.getValueExpression("value").getType(facesContext.getELContext());
        Converter converterForType = facesContext.getApplication().createConverter(valueType);
        if (converterForType != null) {
            return converterForType.getAsObject(facesContext, (UIComponent)spinner, value);
        }
        return value;
    }
}

