/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resizable;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.resizable.Resizable;
import org.primefaces.renderkit.CoreRenderer;

public class ResizableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Resizable resizable = (Resizable)component;
        String resizableVar = this.createUniqueWidgetVar(facesContext, component);
        String parentClientId = resizable.getParent().getClientId(facesContext);
        writer.startElement("script", (UIComponent)resizable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(document).ready(function(){");
        writer.write(resizableVar + " = new YAHOO.util.Resize('" + parentClientId + "',{");
        writer.write("proxy:" + resizable.isProxy());
        if (resizable.isStatus()) {
            writer.write(",status:" + resizable.isStatus());
        }
        if (resizable.isKnobHandles()) {
            writer.write(",knobHandles: true");
        }
        if (resizable.isGhost()) {
            writer.write(",ghost: true");
        }
        if (resizable.isAnimate()) {
            this.encodeAnimation(facesContext, resizable);
        }
        if (resizable.getHandles() != null) {
            this.encodeHandles(facesContext, resizable);
        }
        this.encodeBoundaries(facesContext, resizable);
        writer.write("});});\n");
        writer.endElement("script");
    }

    private void encodeBoundaries(FacesContext facesContext, Resizable resizable) throws IOException {
        String[] passThruBoundaries;
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String boundaryAttribute : passThruBoundaries = new String[]{"maxHeight", "maxWidth", "minHeight", "minWidth"}) {
            Object value = resizable.getAttributes().get(boundaryAttribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.write("," + boundaryAttribute + ":" + value.toString());
        }
    }

    private void encodeAnimation(FacesContext facesContext, Resizable resizable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write(",animate:true");
        writer.write(",animateDuration:" + resizable.getAnimateDuration());
        writer.write(",animateEasing:YAHOO.util.Easing." + resizable.getEffect());
    }

    private void encodeHandles(FacesContext facesContext, Resizable resizable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (resizable.getHandles().equals("all")) {
            writer.write(",handles:\"all\"");
        } else {
            writer.write(",handles:" + this.convertHandlesToJSArray(resizable.getHandles()) + "");
        }
    }

    private String convertHandlesToJSArray(String value) {
        String[] tokens = value.split(",");
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        for (String s : tokens) {
            buffer.append("\"");
            buffer.append(s);
            buffer.append("\"");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

