/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.message;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.message.Message;
import org.primefaces.renderkit.CoreRenderer;

public class MessageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Message uiMessage = (Message)component;
        UIComponent target = uiMessage.findComponent(uiMessage.getFor());
        if (target == null) {
            throw new FacesException("Cannot find component \"" + uiMessage.getFor() + "\" in view.");
        }
        Iterator msgs = facesContext.getMessages(target.getClientId(facesContext));
        writer.startElement("span", (UIComponent)uiMessage);
        writer.writeAttribute("id", (Object)uiMessage.getClientId(facesContext), null);
        if (msgs.hasNext()) {
            FacesMessage msg = (FacesMessage)msgs.next();
            if (msg.isRendered() && !uiMessage.isRedisplay()) {
                writer.endElement("span");
                return;
            }
            FacesMessage.Severity severity = msg.getSeverity();
            String severityKey = null;
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                severityKey = "error";
            } else if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                severityKey = "info";
            } else if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                severityKey = "warn";
            } else if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
                severityKey = "fatal";
            }
            writer.writeAttribute("class", (Object)("ui-message-" + severityKey + " ui-widget ui-corner-all"), null);
            if (uiMessage.isShowSummary()) {
                this.encodeMessageText(writer, msg.getSummary(), severityKey + "-summary");
            }
            if (uiMessage.isShowDetail()) {
                this.encodeMessageText(writer, msg.getDetail(), severityKey + "-detail");
            }
            msg.rendered();
        }
        writer.endElement("span");
    }

    private void encodeMessageText(ResponseWriter writer, String text, String severity) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-message-" + severity), null);
        writer.write(text);
        writer.endElement("span");
    }
}

