/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubar;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menubar.Menubar;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class MenubarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Menubar menubar = (Menubar)component;
        if (menubar.shouldBuildFromModel()) {
            menubar.buildMenuFromModel();
        }
        this.encodeMarkup(facesContext, menubar);
        this.encodeScript(facesContext, menubar);
    }

    protected void encodeScript(FacesContext facesContext, Menubar menubar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menubar.getClientId(facesContext);
        String menubarVar = this.createUniqueWidgetVar(facesContext, (UIComponent)menubar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(menubarVar + " = new YAHOO.widget.MenuBar('" + clientId + "',{");
        writer.write("autosubmenudisplay:" + menubar.isAutoSubmenuDisplay());
        if (!menubar.getEffect().equals("NONE")) {
            writer.write(",effect: {effect: YAHOO.widget.ContainerEffect." + menubar.getEffect());
            if (menubar.getEffectDuration() != 0.25) {
                writer.write(",duration:" + menubar.getEffectDuration() + "}");
            } else {
                writer.write(",duration: 0.25}");
            }
        }
        if (menubar.getZindex() != Integer.MAX_VALUE) {
            writer.write(",zIndex:" + menubar.getZindex());
        }
        writer.write("})\n;");
        writer.write(menubarVar + ".render();\n");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Menubar menubar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menubar.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ui-menubar ui-widget ui-widget-content", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-state-default", null);
        for (UIComponent child : menubar.getChildren()) {
            Submenu submenu = (Submenu)child;
            if (!submenu.isRendered()) continue;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-menubar-item", null);
            this.encodeSubmenu(facesContext, submenu);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSubmenu(FacesContext facesContext, Submenu submenu) throws IOException {
        String labelStyleClass;
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent labelFacet = submenu.getFacet("label");
        String clientId = submenu.getClientId(facesContext);
        boolean isMenubarItem = submenu.getParent() instanceof Menubar;
        String string = labelStyleClass = isMenubarItem ? "ui-menubar-item-label" : "ui-menu-item-label";
        if (labelFacet == null) {
            String href = submenu.getChildCount() > 0 ? "#" + clientId : "#";
            writer.startElement("a", null);
            if (submenu.getLabelStyle() != null) {
                writer.writeAttribute("style", (Object)labelStyleClass, null);
            }
            if (submenu.getLabelStyleClass() != null) {
                labelStyleClass = labelStyleClass + " " + submenu.getLabelStyleClass();
            }
            writer.writeAttribute("class", (Object)labelStyleClass, null);
            writer.writeAttribute("href", (Object)href, null);
            if (submenu.getLabel() != null) {
                writer.write(submenu.getLabel());
            }
            writer.endElement("a");
        } else {
            this.encodeMenuItem(facesContext, (MenuItem)labelFacet, labelStyleClass);
        }
        if (!isMenubarItem) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menu-item-submenu-icon ui-icon ui-icon-triangle-1-e", null);
            writer.endElement("span");
        }
        if (submenu.getChildCount() > 0) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"ui-menu ui-widget ui-widget-content ui-corner-all", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"bd", null);
            writer.startElement("ul", null);
            this.encodeSubmenuItems(facesContext, submenu);
            writer.endElement("ul");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    protected void encodeMenuItem(FacesContext facesContext, MenuItem menuItem, String labelStyleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(facesContext, (UIComponent)menuItem);
        } else {
            String icon;
            String clientId = menuItem.getClientId(facesContext);
            String string = icon = menuItem.getIcon() != null ? "background:url(" + this.getResourceURL(facesContext, menuItem.getIcon()) + ") no-repeat 1%;" : null;
            if (menuItem.getStyleClass() != null) {
                labelStyleClass = labelStyleClass + " " + menuItem.getStyleClass();
            }
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)labelStyleClass, null);
            if (menuItem.getStyle() != null && icon != null) {
                writer.writeAttribute("style", (Object)(icon + menuItem.getStyle()), null);
            } else if (menuItem.getStyle() == null && icon != null) {
                writer.writeAttribute("style", (Object)icon, null);
            } else if (menuItem.getStyle() != null && icon == null) {
                writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            }
            if (menuItem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, menuItem.getUrl()), null);
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"javascript:void(0)", null);
                UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String formClientId = form.getClientId(facesContext);
                String command = menuItem.isAjax() ? this.buildAjaxRequest(facesContext, menuItem, formClientId, clientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)menuItem, formClientId, clientId);
                command = menuItem.getOnclick() == null ? command : menuItem.getOnclick() + ";" + command;
                writer.writeAttribute("onclick", (Object)command, null);
            }
            if (menuItem.getValue() != null) {
                writer.write((String)menuItem.getValue());
            }
            if (menuItem.getHelpText() != null) {
                writer.startElement("em", null);
                writer.writeAttribute("class", (Object)"helptext", null);
                writer.write(menuItem.getHelpText());
                writer.endElement("em");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSubmenuItems(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent child : submenu.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-menu-item ui-corner-all", null);
            if (child instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)child;
                this.encodeMenuItem(facesContext, menuItem, "ui-menu-item-label ui-corner-all");
            } else if (child instanceof Submenu) {
                Submenu childSubmenu = (Submenu)child;
                this.encodeSubmenu(facesContext, childSubmenu);
            }
            writer.endElement("li");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

