/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class MenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Menu menu = (Menu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(facesContext, menu);
        this.encodeScript(facesContext, menu);
    }

    protected void encodeScript(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menu.getClientId(facesContext);
        String menuVar = this.createUniqueWidgetVar(facesContext, (UIComponent)menu);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(menuVar + " = new YAHOO.widget.Menu('" + clientId + "', {");
        if (menu.getPosition().equalsIgnoreCase("static")) {
            writer.write("position:'static'");
        } else if (menu.getPosition().equalsIgnoreCase("dynamic")) {
            writer.write("position:'dynamic'");
            if (menu.isVisible()) {
                writer.write(",visible:true");
            }
            if (!menu.isClickToHide()) {
                writer.write(",clicktohide:false");
            }
            if (menu.isKeepOpen()) {
                writer.write(",keepopen:true");
            }
            if (menu.getX() != -1) {
                writer.write(",x:" + menu.getX());
            }
            if (menu.getY() != -1) {
                writer.write(",y:" + menu.getY());
            }
            if (menu.isFixedCenter()) {
                writer.write(",fixedcenter:true");
            }
            if (!menu.isConstraintToViewport()) {
                writer.write(",constrainttoviewport:false");
            }
            if (menu.getShowDelay() != 250) {
                writer.write(",showdelay:" + menu.getShowDelay());
            }
            if (menu.getHideDelay() != 0) {
                writer.write(",hidedelay:" + menu.getHideDelay());
            }
            if (menu.getSubmenuHideDelay() != 250) {
                writer.write(",submenuhidedelay:" + menu.getSubmenuHideDelay());
            }
            if (menu.getContext() != null) {
                writer.write(",context:[" + menu.getContext() + "]");
            }
            if (menu.getZindex() != Integer.MAX_VALUE) {
                writer.write(",zIndex:" + menu.getZindex());
            }
        }
        if (!menu.isAutoSubmenuDisplay()) {
            writer.write(",autosubmenudisplay:false");
        }
        if (!menu.getEffect().equals("NONE")) {
            writer.write(",effect: {effect: YAHOO.widget.ContainerEffect." + menu.getEffect());
            if (menu.getEffectDuration() != 0.25) {
                writer.write(",duration:" + menu.getEffectDuration() + "}");
            } else {
                writer.write(",duration: 0.25}");
            }
        }
        writer.write("});\n");
        writer.write(menuVar + ".render();\n");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menu.getClientId(facesContext);
        String defaultStyleClass = "ui-menu ui-widget ui-widget-content ui-corner-all";
        String styleClass = menu.getStyleClass() == null ? defaultStyleClass : defaultStyleClass + " " + menu.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        if (menu.isTiered()) {
            this.renderTieredMenu(facesContext, menu);
        } else {
            this.encodeRegularMenu(facesContext, menu);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderTieredMenu(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", null);
        for (UIComponent child : menu.getChildren()) {
            this.encodeTieredSubmenu(facesContext, (Submenu)child);
        }
        writer.endElement("ul");
    }

    protected void encodeRegularMenu(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent child : menu.getChildren()) {
            Submenu submenu = (Submenu)child;
            if (!submenu.isRendered()) continue;
            if (submenu.getLabel() != null) {
                writer.startElement("div", null);
                String defaultLabelClass = "ui-submenu-label ui-widget-header ui-corner-all";
                String styleClass = submenu.getLabelStyleClass() == null ? defaultLabelClass : defaultLabelClass + " " + submenu.getLabelStyleClass();
                writer.writeAttribute("class", (Object)styleClass, null);
                if (submenu.getLabelStyle() != null) {
                    writer.writeAttribute("style", (Object)submenu.getLabelStyle(), null);
                }
                writer.write(submenu.getLabel());
                writer.endElement("div");
            }
            writer.startElement("ul", null);
            this.encodeSubmenuItems(facesContext, submenu);
            writer.endElement("ul");
        }
    }

    protected void encodeTieredSubmenu(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = submenu.getClientId(facesContext);
        String defaultLabelStyleClass = "ui-menu-item-label";
        String labelStyleClass = submenu.getLabelStyleClass() == null ? defaultLabelStyleClass : defaultLabelStyleClass + " " + submenu.getLabelStyleClass();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-menu-item ui-corner-all", null);
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)("#" + clientId), null);
        writer.writeAttribute("class", (Object)labelStyleClass, null);
        if (submenu.getLabel() != null) {
            writer.write(submenu.getLabel());
        }
        writer.endElement("a");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menu-item-submenu-icon ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ui-menu ui-widget ui-widget-content ui-corner-all", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        writer.startElement("ul", null);
        this.encodeSubmenuItems(facesContext, submenu);
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("li");
    }

    protected void encodeSubmenuItems(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent child : submenu.getChildren()) {
            if (child instanceof MenuItem && child.isRendered()) {
                MenuItem menuItem = (MenuItem)child;
                String menuItemClientId = menuItem.getClientId(facesContext);
                String defaultLabelStyleClass = "ui-menu-item-label";
                String labelStyleClass = menuItem.getStyleClass() == null ? defaultLabelStyleClass : defaultLabelStyleClass + " " + menuItem.getStyleClass();
                String icon = menuItem.getIcon() != null ? "background:url(" + this.getResourceURL(facesContext, menuItem.getIcon()) + ") no-repeat 1%;" : null;
                String style = menuItem.getStyle();
                if (style != null && icon != null) {
                    style = icon + style;
                } else if (style == null && icon != null) {
                    style = icon;
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menu-item ui-corner-all", null);
                if (menuItem.shouldRenderChildren()) {
                    this.renderChildren(facesContext, (UIComponent)menuItem);
                } else {
                    writer.startElement("a", null);
                    writer.writeAttribute("id", (Object)menuItemClientId, null);
                    writer.writeAttribute("class", (Object)labelStyleClass, null);
                    if (style != null) {
                        writer.writeAttribute("style", (Object)style, null);
                    }
                    if (menuItem.getUrl() != null) {
                        writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, menuItem.getUrl()), null);
                        if (menuItem.getOnclick() != null) {
                            writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                        }
                        if (menuItem.getTarget() != null) {
                            writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                        }
                    } else {
                        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
                        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)submenu);
                        if (form == null) {
                            throw new FacesException("Menu must be inside a form element");
                        }
                        String formClientId = form.getClientId(facesContext);
                        String command = menuItem.isAjax() ? this.buildAjaxRequest(facesContext, menuItem, formClientId, menuItemClientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)menuItem, formClientId, menuItemClientId);
                        command = menuItem.getOnclick() == null ? command : menuItem.getOnclick() + ";" + command;
                        writer.writeAttribute("onclick", (Object)command, null);
                    }
                    if (menuItem.getValue() != null) {
                        writer.write((String)menuItem.getValue());
                    }
                    writer.endElement("a");
                }
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu) || !child.isRendered()) continue;
            this.encodeTieredSubmenu(facesContext, (Submenu)child);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

