/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dialog.Dialog;
import org.primefaces.event.CloseEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DialogRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Dialog dialog = (Dialog)component;
        String clientId = dialog.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId + "_closed")) {
            dialog.setVisible(false);
            dialog.queueEvent(new CloseEvent((UIComponent)dialog));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Dialog dialog = (Dialog)component;
        this.encodeMarkup(facesContext, dialog);
        this.encodeScript(facesContext, dialog);
    }

    protected void encodeScript(FacesContext facesContext, Dialog dialog) throws IOException {
        String position;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dialog.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)dialog);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.Dialog('" + clientId + "',");
        writer.write("{");
        writer.write("autoOpen:" + dialog.isVisible());
        writer.write(",minHeight:" + dialog.getMinHeight());
        if (dialog.getStyleClass() != null) {
            writer.write(",dialogClass:'" + dialog.getStyleClass() + "'");
        }
        if (dialog.getWidth() != 300) {
            writer.write(",width:" + dialog.getWidth());
        }
        if (dialog.getHeight() != Integer.MIN_VALUE) {
            writer.write(",height:" + dialog.getHeight());
        }
        if (!dialog.isDraggable()) {
            writer.write(",draggable: false");
        }
        if (dialog.isModal()) {
            writer.write(",modal: true");
        }
        if (dialog.getZindex() != 1000) {
            writer.write(",zIndex:" + dialog.getZindex());
        }
        if (!dialog.isResizable()) {
            writer.write(",resizable:false");
        }
        if (dialog.getMinWidth() != 150) {
            writer.write(",minWidth:" + dialog.getMinWidth());
        }
        if (dialog.getShowEffect() != null) {
            writer.write(",show:'" + dialog.getShowEffect() + "'");
        }
        if (dialog.getHideEffect() != null) {
            writer.write(",hide:'" + dialog.getHideEffect() + "'");
        }
        if (!dialog.isCloseOnEscape()) {
            writer.write(",closeOnEscape:false");
        }
        if (!dialog.isClosable()) {
            writer.write(",closable:false");
        }
        if ((position = dialog.getPosition()) != null) {
            if (position.contains(",")) {
                writer.write(",position:[" + position + "]");
            } else {
                writer.write(",position:'" + position + "'");
            }
        }
        if (dialog.getCloseListener() != null || dialog.getOnCloseUpdate() != null) {
            writer.write(",ajaxClose:true");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            if (dialog.getOnCloseUpdate() != null) {
                writer.write(",onCloseUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)dialog, dialog.getOnCloseUpdate()) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dialog.getClientId(facesContext);
        String headerText = dialog.getHeader();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (headerText != null) {
            writer.writeAttribute("title", (Object)headerText, null);
        }
        this.renderChildren(facesContext, (UIComponent)dialog);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

