/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.collector;

import java.util.Collection;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;

public class Collector
implements ActionListener,
StateHolder {
    private ValueExpression addTo;
    private ValueExpression removeFrom;
    private ValueExpression value;
    private boolean _transient;

    public Collector() {
    }

    public Collector(ValueExpression addTo, ValueExpression removeFrom, ValueExpression value) {
        this.addTo = addTo;
        this.removeFrom = removeFrom;
        this.value = value;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (this.value == null) {
            throw new AbortProcessingException("@for has not been set");
        }
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        Object val = this.value.getValue(elContext);
        if (this.addTo != null) {
            Collection collection = (Collection)this.addTo.getValue(elContext);
            if (!collection.contains(val)) {
                collection.add(val);
            }
        } else if (this.removeFrom != null) {
            Collection collection = (Collection)this.removeFrom.getValue(elContext);
            collection.remove(val);
        } else {
            throw new IllegalArgumentException("Specify either addTo or removeFrom as collection reference");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.addTo, this.removeFrom, this.value};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.addTo = (ValueExpression)values[0];
        this.removeFrom = (ValueExpression)values[1];
        this.value = (ValueExpression)values[2];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public ValueExpression getAddTo() {
        return this.addTo;
    }

    public void setAddTo(ValueExpression addTo) {
        this.addTo = addTo;
    }

    public ValueExpression getRemoveFrom() {
        return this.removeFrom;
    }

    public void setRemoveFrom(ValueExpression removeFrom) {
        this.removeFrom = removeFrom;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }
}

