/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.calendar.Calendar;

public class CalendarUtils {
    public static String getValueAsString(FacesContext facesContext, Calendar calendar) {
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsString(facesContext, (UIComponent)calendar, value);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.getPattern(), calendar.calculateLocale(facesContext));
        dateFormat.setTimeZone(calendar.calculateTimeZone());
        return dateFormat.format(value);
    }

    public static String getDateAsString(Calendar calendar, Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return (String)date;
        }
        if (date instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(calendar.getPattern(), calendar.calculateLocale(FacesContext.getCurrentInstance()));
            dateFormat.setTimeZone(calendar.calculateTimeZone());
            return dateFormat.format((Date)date);
        }
        throw new FacesException("Date could be either String or java.util.Date");
    }

    public static String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        pattern = (pattern = pattern.replaceAll("yy", "y")).indexOf("MMM") != -1 ? pattern.replaceAll("MMM", "M") : pattern.replaceAll("M", "m");
        pattern = pattern.replaceAll("EEE", "D");
        return pattern;
    }
}

