/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;

public class AccordionPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        AccordionPanel accordionPanel = (AccordionPanel)component;
        String activeIndexParam = accordionPanel.getClientId(facesContext) + "_active";
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(activeIndexParam)) {
            accordionPanel.setActiveIndex(Integer.valueOf((String)params.get(activeIndexParam)));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AccordionPanel accordionPanel = (AccordionPanel)component;
        this.encodeMarkup(facesContext, accordionPanel);
        this.encodeScript(facesContext, accordionPanel);
    }

    protected void encodeMarkup(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = accordionPanel.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (accordionPanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)accordionPanel.getStyle(), null);
        }
        if (accordionPanel.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)accordionPanel.getStyleClass(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_acco"), null);
        this.encodeTabs(facesContext, accordionPanel);
        writer.endElement("div");
        this.encodeStateHolder(facesContext, accordionPanel);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, AccordionPanel acco) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = acco.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)acco);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.AccordionPanel('" + clientId + "', {");
        writer.write("active:" + acco.getActiveIndex());
        writer.write(",animated:'" + acco.getEffect() + "'");
        if (acco.getEvent() != null) {
            writer.write(",event:'" + acco.getEvent() + "'");
        }
        if (!acco.isAutoHeight()) {
            writer.write(",autoHeight:false");
        }
        if (acco.isCollapsible()) {
            writer.write(",collapsible:true");
        }
        if (acco.isFillSpace()) {
            writer.write(",fillSpace:true");
        }
        if (acco.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeStateHolder(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = accordionPanel.getClientId(facesContext);
        String stateHolderId = clientId + "_active";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        writer.writeAttribute("value", (Object)accordionPanel.getActiveIndex(), null);
        writer.endElement("input");
    }

    protected void encodeTabs(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent kid : accordionPanel.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("h3", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            if (tab.getTitle() != null) {
                writer.write(tab.getTitle());
            }
            writer.endElement("a");
            writer.endElement("h3");
            writer.startElement("div", null);
            this.renderChild(facesContext, (UIComponent)tab);
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

