/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.primefaces.component.PartialViewRoot;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.context.RequestContext;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.util.ArrayUtils;

public class PrimeFacesPhaseListener
implements PhaseListener {
    private static final Logger logger = Logger.getLogger(PrimeFacesPhaseListener.class.getName());
    public static final VisitCallback RENDER_RESPONSE = new VisitCallback(){

        public VisitResult visit(VisitContext visitContext, UIComponent component) {
            FacesContext facesContext = visitContext.getFacesContext();
            ResponseWriter writer = visitContext.getFacesContext().getResponseWriter();
            String clientId = component.getClientId(facesContext);
            try {
                writer.write("<component>");
                writer.write("<id>" + clientId + "</id>");
                writer.write("<output>");
                writer.startCDATA();
                component.encodeAll(facesContext);
                writer.endCDATA();
                writer.write("</output>");
                writer.write("</component>");
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            return VisitResult.ACCEPT;
        }
    };
    public static final ContextCallback RENDER_PARTIAL_RESPONSE = new ContextCallback(){

        public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
            try {
                ((AjaxComponent)component).encodePartially(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };

    public void afterPhase(PhaseEvent phaseEvent) {
        try {
            RequestContext.getCurrentInstance().release();
        }
        catch (NullPointerException exception) {
            logger.info("Warning: RequestContext is already null before releasing. This means you have more than one PrimeFaces jar in your classpath.");
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        boolean isPartialViewProcess;
        FacesContext facesContext = phaseEvent.getFacesContext();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        boolean isAjaxRequest = params.containsKey("primefacesPartialRequest");
        boolean bl = isPartialViewProcess = params.containsKey("primefacesPartialProcess") && !((String)params.get("primefacesPartialProcess")).equals("@all");
        if (isPartialViewProcess) {
            this.restorePartialView(facesContext);
        }
        if (isAjaxRequest) {
            try {
                this.handleAjaxRequest(facesContext);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private void handleAjaxRequest(FacesContext facesContext) throws IOException {
        boolean isPPRRequest;
        RequestContext requestContext = RequestContext.getCurrentInstance();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing PrimeFaces ajax request");
        }
        this.initPartialRenderView(facesContext);
        boolean bl = isPPRRequest = !params.containsKey("primefacesPartialSource");
        if (isPPRRequest) {
            String[] idsToUpdate = this.getIdsToUpdate(facesContext, requestContext);
            ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
            response.setContentType("text/xml");
            ResponseWriter writer = facesContext.getResponseWriter();
            try {
                writer.write("<?xml version=\"1.0\" encoding=\"" + response.getCharacterEncoding() + "\"?>");
                writer.write("<partialResponse>");
                if (requestContext.getAjaxRedirectUrl() != null) {
                    writer.write("<redirect-url>" + RequestContext.getCurrentInstance().getAjaxRedirectUrl() + "</redirect-url>");
                } else {
                    if (idsToUpdate != null) {
                        this.writeComponents(facesContext, idsToUpdate);
                    }
                    this.writeState(facesContext);
                    requestContext.addCallbackParam("validationFailed", facesContext.isValidationFailed());
                    this.writeCallbackParams(facesContext, requestContext);
                }
                writer.write("</partialResponse>");
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            String ajaxSource = (String)params.get("primefacesPartialSource");
            boolean found = facesContext.getViewRoot().invokeOnComponent(facesContext, ajaxSource, RENDER_PARTIAL_RESPONSE);
            if (!found) {
                logger.log(Level.WARNING, "Component \"{0}\" not found to be updated partially", ajaxSource);
            }
        }
        facesContext.responseComplete();
        facesContext.getResponseWriter().close();
    }

    private String[] getIdsToUpdate(FacesContext facesContext, RequestContext requestContext) {
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String[] idsToUpdate = null;
        String declaredUpdateIds = (String)params.get("primefacesPartialUpdate");
        List<String> dynamicUpdateIds = requestContext.getPartialUpdateTargets();
        if (declaredUpdateIds != null && !declaredUpdateIds.equals("@none")) {
            idsToUpdate = declaredUpdateIds.split("[,\\s]+");
        }
        if (!dynamicUpdateIds.isEmpty()) {
            idsToUpdate = idsToUpdate != null ? ArrayUtils.concat(idsToUpdate, dynamicUpdateIds.toArray(new String[0])) : dynamicUpdateIds.toArray(new String[0]);
        }
        return idsToUpdate;
    }

    private void restorePartialView(FacesContext facesContext) {
        PartialViewRoot partialView = (PartialViewRoot)facesContext.getViewRoot();
        partialView.restoreBase();
        facesContext.setViewRoot(partialView.getBase());
        partialView = null;
    }

    private void writeState(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("<state>");
        writer.startCDATA();
        StateManager stateManager = facesContext.getApplication().getStateManager();
        stateManager.writeState(facesContext, stateManager.saveView(facesContext));
        writer.endCDATA();
        writer.write("</state>");
    }

    private void writeComponents(FacesContext facesContext, String[] ids) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, Arrays.asList(ids), null);
        writer.write("<components>");
        facesContext.getViewRoot().visitTree(visitContext, RENDER_RESPONSE);
        writer.write("</components>");
    }

    private void writeCallbackParams(FacesContext facesContext, RequestContext requestContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, Object> params = requestContext.getCallbackParams();
        writer.write("<callbackParams>");
        for (String paramName : params.keySet()) {
            writer.write("<callbackParam>");
            try {
                Object paramValue = params.get(paramName);
                String json = this.isBean(paramValue) ? "{\"" + paramName + "\":" + new JSONObject(paramValue).toString() + "}" : new JSONObject().put(paramName, paramValue).toString();
                writer.write(json);
            }
            catch (JSONException e) {
                logger.log(Level.SEVERE, "Error in serializing callback parameter \"{0}\"", paramName);
                throw new FacesException(e.getMessage());
            }
            writer.write("</callbackParam>");
        }
        writer.write("</callbackParams>");
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void initPartialRenderView(FacesContext facesContext) {
        this.initPartialResponseWriter(facesContext);
    }

    private void initPartialResponseWriter(FacesContext facesContext) {
        if (facesContext.getResponseWriter() != null) {
            return;
        }
        try {
            ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
            ServletRequest request = (ServletRequest)facesContext.getExternalContext().getRequest();
            response.setCharacterEncoding(request.getCharacterEncoding());
            RenderKit renderKit = facesContext.getRenderKit();
            ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)response.getWriter(), null, request.getCharacterEncoding());
            facesContext.setResponseWriter(responseWriter);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

