/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenRemoteProjectAction
extends AbstractAction {
    private static final String PROJECT_CONFIGURATION_FILE = "nbproject/configurations.xml";
    private static final String PROJECT_PRIVATE_CONFIGURATION_FILE = "nbproject/private/configurations.xml";

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection records = ServerList.getRecords();
        ServerRecord rr = null;
        for (ServerRecord r : records) {
            if (!r.isRemote()) continue;
            rr = r;
            break;
        }
        if (rr == null) {
            return;
        }
        final ServerRecord record = rr;
        if (record.isOffline()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){

                public void doWork() {
                    record.validate(true);
                }

                public void doPostRunInEDT() {
                    OpenRemoteProjectAction.this.openProject(record);
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenRemoteProjectAction.comment.title");
            String msg = NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenRemoteProjectAction.comment.message", (Object)record.getDisplayName());
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            this.openProject(record);
        }
    }

    private void openProject(ServerRecord record) {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        FileChooserBuilder.JFileChooserEx fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileUtil.createFileChooser((ExecutionEnvironment)record.getExecutionEnvironment(), (String)record.getDisplayName(), (String)NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"OpenRemoteProjectAction.open"), (int)1, null, null, (boolean)true);
        int ret = fileChooser.showOpenDialog((Component)mainWindow);
        if (ret == 1) {
            return;
        }
        FileObject remoteProject = fileChooser.getSelectedFileObject();
        try {
            String path = ProjectChooser.getProjectsFolder().getAbsolutePath() + "/" + remoteProject.getNameExt();
            File destination = new File(path);
            int loop = 0;
            while (destination.exists()) {
                destination = new File(path + ++loop);
            }
            FileObject localProject = FileUtil.createFolder((File)destination);
            this.copy(remoteProject.getFileObject("nbproject"), localProject, "nbproject");
            this.updateProject(remoteProject, localProject, record);
            this.updateConfiguration(localProject, record);
            this.updatePrivateConfiguration(localProject, record);
            Project findProject = ProjectManager.getDefault().findProject(localProject);
            OpenProjects.getDefault().open(new Project[]{findProject}, false);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateProject(FileObject remoteProject, FileObject localProject, ServerRecord record) throws IOException, SAXException {
        NodeList dataList;
        FileObject fo = localProject.getFileObject("nbproject/project.xml");
        File projXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null && (dataList = root.getElementsByTagName("data")).getLength() > 0) {
            Node masterConfs = dataList.item(0);
            Element remoteMode = doc.createElement("remote-sources-mode");
            remoteMode.setTextContent("REMOTE_SOURCES");
            masterConfs.appendChild(remoteMode);
            Element remoteHost = doc.createElement("remote-filesystem-host");
            remoteHost.setTextContent(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment()));
            masterConfs.appendChild(remoteHost);
            Element remoteBaseDir = doc.createElement("remote-filesystem-base-dir");
            remoteBaseDir.setTextContent(remoteProject.getPath());
            masterConfs.appendChild(remoteBaseDir);
        }
        OpenRemoteProjectAction.saveXml(doc, localProject, "nbproject/project.xml");
    }

    private void updateConfiguration(FileObject localProject, ServerRecord record) throws IOException, SAXException {
        NodeList toolSetList;
        FileObject fo = localProject.getFileObject(PROJECT_CONFIGURATION_FILE);
        File confXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(confXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null && (toolSetList = root.getElementsByTagName("toolsSet")).getLength() > 0) {
            for (int i = 0; i < toolSetList.getLength(); ++i) {
                Node node = toolSetList.item(i);
                NodeList childNodes = node.getChildNodes();
                ArrayList<Node> list = new ArrayList<Node>();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    list.add(childNodes.item(j));
                }
                for (Node n : list) {
                    node.removeChild(n);
                }
                Element remoteMode = doc.createElement("remoteSyncFactory");
                remoteMode.setTextContent("full");
                node.appendChild(remoteMode);
                remoteMode = doc.createElement("remote-sources-mode");
                remoteMode.setTextContent("REMOTE_SOURCES");
                node.appendChild(remoteMode);
                remoteMode = doc.createElement("compilerSet");
                remoteMode.setTextContent("default");
                node.appendChild(remoteMode);
            }
        }
        OpenRemoteProjectAction.saveXml(doc, localProject, PROJECT_CONFIGURATION_FILE);
    }

    private void updatePrivateConfiguration(FileObject localProject, ServerRecord record) throws IOException, SAXException {
        NodeList toolSetList;
        FileObject fo = localProject.getFileObject(PROJECT_PRIVATE_CONFIGURATION_FILE);
        File confXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(confXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null && (toolSetList = root.getElementsByTagName("toolsSet")).getLength() > 0) {
            for (int i = 0; i < toolSetList.getLength(); ++i) {
                Node node = toolSetList.item(i);
                NodeList childNodes = node.getChildNodes();
                ArrayList<Node> list = new ArrayList<Node>();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    list.add(childNodes.item(j));
                }
                for (Node n : list) {
                    node.removeChild(n);
                }
                Element remoteMode = doc.createElement("developmentServer");
                remoteMode.setTextContent(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment()));
                node.appendChild(remoteMode);
            }
        }
        OpenRemoteProjectAction.saveXml(doc, localProject, PROJECT_PRIVATE_CONFIGURATION_FILE);
    }

    @Override
    public boolean isEnabled() {
        Collection records = ServerList.getRecords();
        for (ServerRecord record : records) {
            if (!record.isRemote()) continue;
            return true;
        }
        return false;
    }

    private FileObject copy(FileObject base, FileObject proxy, String name) throws IOException {
        if (base.isFolder()) {
            FileObject peer = proxy.createFolder(name);
            FileUtil.copyAttributes((FileObject)base, (FileObject)peer);
            for (FileObject fo : base.getChildren()) {
                this.copy(fo, peer, fo.getNameExt());
            }
            return peer;
        }
        FileObject dest = this.copyImpl(base, proxy, name);
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyImpl(FileObject source, FileObject destFolder, String newName) throws IOException {
        FileObject dest = destFolder.createData(newName);
        FileLock lock = null;
        InputStream bufIn = null;
        OutputStream bufOut = null;
        try {
            lock = dest.lock();
            bufIn = source.getInputStream();
            bufOut = dest.getOutputStream(lock);
            FileUtil.copy((InputStream)bufIn, (OutputStream)bufOut);
            FileUtil.copyAttributes((FileObject)source, (FileObject)dest);
        }
        finally {
            if (bufIn != null) {
                bufIn.close();
            }
            if (bufOut != null) {
                bufOut.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private static final class MyFileView
    extends FileView {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();

        public MyFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        @Override
        public Icon getIcon(File f) {
            Icon res = this.knownProjectIcons.get(f);
            if (res == null) {
                res = this._getIcon(f);
                this.knownProjectIcons.put(f, res);
            }
            return res;
        }

        public Icon _getIcon(File f) {
            try {
                if (f != null && f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                    String path = f.getAbsolutePath();
                    String project = path + "/nbproject";
                    File projectDir = this.chooser.getFileSystemView().createFileObject(project);
                    if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                        String projectXml = path + "/nbproject/project.xml";
                        File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                        if (projectFile.exists()) {
                            String conf = path + "/nbproject/configurations.xml";
                            File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                            if (configuration.exists()) {
                                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }
    }
}

