/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class EnhancedTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    protected Color backgroundNonSelectionColor;
    protected Color backgroundSelectionColor = UIConstants.TABLE_SELECTION_BACKGROUND_COLOR;
    protected Color borderSelectionColor;
    protected Color textNonSelectionColor;
    protected Color textSelectionColor = UIConstants.TABLE_SELECTION_FOREGROUND_COLOR;
    protected boolean hasFocus;
    protected boolean selected;
    private transient Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private transient Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private transient Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JTree tree;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public EnhancedTreeCellRenderer() {
        super(null);
        this.setOpaque(false);
        this.label1 = new InternalLabel();
        this.label2 = new InternalLabel();
        this.label3 = new InternalLabel();
        this.label2.setFont(this.label1.getFont().deriveFont(1));
        this.add(this.label1);
        this.add(this.label2);
        this.add(this.label3);
        this.label1.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Dimension size1 = this.label1.getPreferredSize();
        Dimension size2 = this.label2.getPreferredSize();
        Dimension size3 = this.label3.getPreferredSize();
        size.height = Math.max(size.height, size1.height);
        size.height = Math.max(size.height, size2.height);
        size.height = Math.max(size.height, size3.height);
        int x = 0;
        if ("".equals(this.label1.getText())) {
            size1.width += this.label1.getIconTextGap();
        }
        this.label1.setBounds(x, 0, size1.width, size.height);
        this.label2.setBounds(x += size1.width, 0, size2.width, size.height);
        this.label3.setBounds(x += size2.width, 0, size3.width, size.height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.label1.getPreferredSize();
        if ("".equals(this.label1.getText())) {
            size.width += this.label1.getIconTextGap();
        }
        size.width += this.label2.getPreferredSize().width;
        size.width += this.label3.getPreferredSize().width;
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = value != null ? value.toString() : "";
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.label1.setText(this.getLabel1Text(value, stringValue));
        this.label2.setText(this.getLabel2Text(value, stringValue));
        this.label3.setText(this.getLabel3Text(value, stringValue));
        if (sel) {
            this.label1.setForeground(this.getTextSelectionColor());
            this.label2.setForeground(this.getTextSelectionColor());
            Color c = this.getTextSelectionColor();
            this.label3.setForeground(c.equals(Color.BLACK) ? Color.GRAY : c.brighter());
        } else {
            this.label1.setForeground(this.getTextNonSelectionColor());
            this.label2.setForeground(this.getTextNonSelectionColor());
            Color c = this.getTextNonSelectionColor();
            this.label3.setForeground(c.equals(Color.BLACK) ? Color.GRAY : c.brighter());
        }
        if (!tree.isEnabled()) {
            this.label1.setEnabled(false);
            this.label2.setEnabled(false);
            this.label3.setEnabled(false);
            if (leaf) {
                this.label1.setDisabledIcon(this.getLeafIcon(value));
            } else if (expanded) {
                this.label1.setDisabledIcon(this.getOpenIcon(value));
            } else {
                this.label1.setDisabledIcon(this.getClosedIcon(value));
            }
        } else {
            this.label1.setEnabled(true);
            this.label2.setEnabled(true);
            this.label3.setEnabled(true);
            if (leaf) {
                this.label1.setIcon(this.getLeafIcon(value));
            } else if (expanded) {
                this.label1.setIcon(this.getOpenIcon(value));
            } else {
                this.label1.setIcon(this.getClosedIcon(value));
            }
        }
        this.label1.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    @Override
    public Component getTreeCellRendererComponentPersistent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        EnhancedTreeCellRenderer renderer = new EnhancedTreeCellRenderer();
        renderer.setLeafIcon(this.leafIcon);
        renderer.setClosedIcon(this.closedIcon);
        renderer.setOpenIcon(this.openIcon);
        return renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public void paint(Graphics g) {
        Color bsColor;
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        if (bColor != null) {
            g.setColor(bColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus && (bsColor = this.getBorderSelectionColor()) != null) {
            g.setColor(bsColor);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    protected Icon getClosedIcon(Object value) {
        return this.getClosedIcon();
    }

    protected String getLabel1Text(Object node, String value) {
        return value;
    }

    protected String getLabel2Text(Object node, String value) {
        return "";
    }

    protected String getLabel3Text(Object node, String value) {
        return "";
    }

    protected Icon getLeafIcon(Object value) {
        return this.getLeafIcon();
    }

    protected Icon getOpenIcon(Object value) {
        return this.getOpenIcon();
    }

    @Override
    public Insets getInsets() {
        return ZERO_INSETS;
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.doLayout();
        }
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    private static class InternalLabel
    extends JLabel {
        private FontMetrics fontMetrics;
        private String text;
        private Color foreground;
        private boolean enabled;

        private InternalLabel() {
        }

        @Override
        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        @Override
        public Color getForeground() {
            return this.foreground;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            if (this.fontMetrics == null) {
                this.fontMetrics = super.getFontMetrics(font);
            }
            return this.fontMetrics;
        }

        @Override
        public void setFont(Font font) {
            this.fontMetrics = null;
            super.setFont(font);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void setDisplayedMnemonic(int key) {
        }

        @Override
        public void setDisplayedMnemonic(char aChar) {
        }

        @Override
        public void setDisplayedMnemonicIndex(int index) {
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics componentGraphics = this.getComponentGraphics(g);
            Graphics co = componentGraphics == null ? null : componentGraphics.create();
            try {
                this.paintComponent(co);
            }
            finally {
                co.dispose();
            }
        }
    }
}

