/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class ProgressDisplayer
extends JPanel {
    private static final String PROGRESS_STRING = NbBundle.getMessage(ProgressDisplayer.class, (String)"ProgressDisplayer_ProgressString");
    private static final String CANCEL_BUTTON_TEXT = NbBundle.getMessage(ProgressDisplayer.class, (String)"ProgressDisplayer_CancelButtonText");
    private static final Object displayerLock = new Object();
    private static ProgressDisplayer defaultInstance;
    private Dialog owner;
    private JButton cancelButton;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private ProgressController controller;
    private boolean isOpened;

    private ProgressDisplayer() {
        this.initComponents();
    }

    public static ProgressDisplayer showProgress(String message) {
        return ProgressDisplayer.showProgress(message, null);
    }

    public static ProgressDisplayer showProgress(String message, ProgressController controller) {
        return ProgressDisplayer.showProgress(PROGRESS_STRING, message, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProgressDisplayer showProgress(String caption, String message, ProgressController controller) {
        Object object = displayerLock;
        synchronized (object) {
            final ProgressDisplayer pd = ProgressDisplayer.getDefault();
            DialogDescriptor dd = pd.createDialogDescriptor(caption, message, controller);
            final Dialog d = ProfilerDialogs.createDialog(dd);
            d.pack();
            pd.setOwner(d);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pd.setOpened(true);
                    d.setVisible(true);
                }
            });
            return pd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Object object = displayerLock;
        synchronized (object) {
            return this.isOpened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = displayerLock;
        synchronized (object) {
            if (this.owner != null) {
                this.owner.setVisible(false);
                this.owner.dispose();
            }
            this.cleanup();
        }
    }

    private static ProgressDisplayer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProgressDisplayer();
        }
        return defaultInstance;
    }

    private void setOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    private void setOwner(Dialog owner) {
        this.owner = owner;
        if (owner instanceof JDialog) {
            ((JDialog)owner).setDefaultCloseOperation(0);
        }
    }

    private void cleanup() {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
        }
        this.isOpened = false;
        this.controller = null;
        this.owner = null;
    }

    private DialogDescriptor createDialogDescriptor(String caption, String message, ProgressController controller) {
        this.controller = controller;
        this.progressLabel.setText(message);
        this.progressBar.setIndeterminate(true);
        DialogDescriptor dd = null;
        dd = controller == null ? new DialogDescriptor((Object)this, caption, true, new Object[0], null, 0, null, null) : new DialogDescriptor((Object)this, caption, true, new Object[]{this.cancelButton}, null, 0, null, null);
        dd.setClosingOptions(new Object[0]);
        return dd;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.progressLabel = new JLabel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 8, 0, 8);
        this.add((Component)this.progressLabel, constraints);
        this.progressBar = new JProgressBar(0);
        this.progressBar.setPreferredSize(new Dimension(300, this.progressBar.getPreferredSize().height));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 8, 15, 8);
        this.add((Component)this.progressBar, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), constraints);
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgressDisplayer.this.controller != null) {
                    ProgressDisplayer.this.controller.cancel();
                }
            }
        });
    }

    public static interface ProgressController
    extends Cancellable {
    }
}

