/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ThreadInfo;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import javax.management.openmbean.CompositeData;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;

public class LoadedSnapshot {
    private static final Logger LOGGER = Logger.getLogger(LoadedSnapshot.class.getName());
    private static final String ILLEGAL_SNAPSHOT_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_IllegalSnapshotDataMsg");
    private static final String INVALID_SNAPSHOT_FILE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_InvalidSnapshotFileMsg");
    private static final String UNSUPPORTED_SNAPSHOT_VERSION_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_UnsupportedSnapshotVersionMsg");
    private static final String WRONG_SNAPSHOT_TYPE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_WrongSnapshotTypeMsg");
    private static final String CANNOT_READ_SNAPSHOT_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_CannotReadSnapshotDataMsg");
    private static final String CANNOT_READ_SETTINGS_DATA_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_CannotReadSettingsDataMsg");
    private static final String UNRECOGNIZED_SNAPSHOT_TYPE_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_UnrecognizedSnapshotTypeMsg");
    private static final String SNAPSHOT_DATA_CORRUPTED_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotDataCorruptedMsg");
    private static final String SNAPSHOT_FILE_SHORT_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileShortMsg");
    private static final String SNAPSHOT_FILE_CORRUPTED = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileCorrupted");
    private static final String SNAPSHOT_FILE_CORRUPTED_REASON = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_SnapshotFileCorruptedReason");
    private static final String OUT_OF_MEMORY_LOADING = NbBundle.getMessage(LoadedSnapshot.class, (String)"LoadedSnapshot_OutOfMemoryLoadingMsg");
    public static final int SNAPSHOT_TYPE_UNKNOWN = 0;
    public static final int SNAPSHOT_TYPE_CPU = 1;
    public static final int SNAPSHOT_TYPE_CODEFRAGMENT = 2;
    public static final int SNAPSHOT_TYPE_MEMORY_ALLOCATIONS = 4;
    public static final int SNAPSHOT_TYPE_MEMORY_LIVENESS = 8;
    public static final int SNAPSHOT_TYPE_MEMORY = 12;
    public static final String PROFILER_FILE_MAGIC_STRING = "nBpRoFiLeR";
    private static final byte SNAPSHOT_FILE_VERSION_MAJOR = 1;
    private static final byte SNAPSHOT_FILE_VERSION_MINOR = 1;
    private File file;
    private ProfilingSettings settings;
    private Project project = null;
    private ResultsSnapshot snapshot;
    private boolean saved = false;

    public LoadedSnapshot(ResultsSnapshot snapshot, ProfilingSettings settings, File file, Project project) {
        if (snapshot == null) {
            throw new IllegalArgumentException();
        }
        if (settings == null) {
            throw new IllegalArgumentException();
        }
        this.snapshot = snapshot;
        this.settings = settings;
        this.file = file;
        this.project = project;
    }

    private LoadedSnapshot() {
    }

    public void setFile(File file) {
        this.file = file;
        this.saved = true;
    }

    public File getFile() {
        return this.file;
    }

    public Project getProject() {
        return this.project;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public ProfilingSettings getSettings() {
        return this.settings;
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public int getType() {
        if (this.snapshot instanceof CPUResultsSnapshot) {
            return 1;
        }
        if (this.snapshot instanceof CodeRegionResultsSnapshot) {
            return 2;
        }
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            return 8;
        }
        if (this.snapshot instanceof AllocMemoryResultsSnapshot) {
            return 4;
        }
        throw new IllegalStateException(ILLEGAL_SNAPSHOT_DATA_MSG);
    }

    public static LoadedSnapshot loadSnapshot(DataInputStream dis) throws IOException {
        dis.mark(100);
        try {
            LoadedSnapshot ls = new LoadedSnapshot();
            if (ls.load(dis)) {
                return ls;
            }
            return null;
        }
        catch (IOException ex) {
            if (INVALID_SNAPSHOT_FILE_MSG.equals(ex.getMessage())) {
                dis.reset();
                return LoadedSnapshot.loadSnapshotFromStackTraces(dis);
            }
            throw ex;
        }
    }

    private static LoadedSnapshot loadSnapshotFromStackTraces(DataInputStream dis) throws IOException {
        CPUResultsSnapshot snapshot;
        SamplesInputStream is = new SamplesInputStream(dis);
        StackTraceSnapshotBuilder builder = new StackTraceSnapshotBuilder();
        ThreadsSample sample = is.readSample();
        long startTime = sample.getTime();
        while (sample != null) {
            builder.addStacktrace(sample.getTinfos(), sample.getTime());
            sample = is.readSample();
        }
        is.close();
        is = null;
        try {
            snapshot = builder.createSnapshot(startTime);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException ex) {
            throw new IOException(ex);
        }
        return new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    static void writeToStream(CPUResultsSnapshot snapshot, DataOutputStream dos) throws IOException {
        LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        loadedSnapshot.save(dos);
    }

    public void save(DataOutputStream dos) throws IOException, OutOfMemoryError {
        Properties props = new Properties();
        this.settings.store((Map)props);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("save properties: --------------------------------------------------------------");
            LOGGER.finest(this.settings.debug());
            LOGGER.finest("-------------------------------------------------------------------------------");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000000);
        BufferedOutputStream bufBaos = new BufferedOutputStream(baos);
        DataOutputStream snapshotDataStream = new DataOutputStream(bufBaos);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream(10000);
        BufferedOutputStream bufBaos2 = new BufferedOutputStream(baos2);
        DataOutputStream settingsDataStream = new DataOutputStream(bufBaos2);
        try {
            this.snapshot.writeToStream(snapshotDataStream);
            snapshotDataStream.flush();
            props.store(settingsDataStream, "");
            settingsDataStream.flush();
            byte[] snapshotBytes = baos.toByteArray();
            byte[] compressedBytes = new byte[snapshotBytes.length];
            Deflater d = new Deflater();
            d.setInput(snapshotBytes);
            d.finish();
            int compressedLen = d.deflate(compressedBytes);
            int uncompressedLen = snapshotBytes.length;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("save version:1.1");
                LOGGER.finest("save type:" + this.getType());
                LOGGER.finest("length of uncompressed snapshot data:" + uncompressedLen);
                LOGGER.finest("save length of snapshot data:" + compressedLen);
                LOGGER.finest("length of settings data:" + baos2.size());
            }
            dos.writeBytes(PROFILER_FILE_MAGIC_STRING);
            dos.writeByte(1);
            dos.writeByte(1);
            dos.writeInt(this.getType());
            dos.writeInt(compressedLen);
            dos.writeInt(uncompressedLen);
            dos.write(compressedBytes, 0, compressedLen);
            dos.writeInt(baos2.size());
            dos.write(baos2.toByteArray());
        }
        catch (OutOfMemoryError e) {
            baos = null;
            bufBaos = null;
            snapshotDataStream = null;
            baos2 = null;
            bufBaos2 = null;
            settingsDataStream = null;
            throw e;
        }
        finally {
            if (snapshotDataStream != null) {
                snapshotDataStream.close();
            }
            if (settingsDataStream != null) {
                settingsDataStream.close();
            }
        }
    }

    public String toString() {
        String snapshotString = "snapshot = " + this.snapshot.toString();
        String fileString = "file = " + (this.file == null ? "null" : this.file.toString());
        String projectString = "project = " + (this.project == null ? "null" : ProjectUtils.getInformation((Project)this.project).getDisplayName());
        return "Loaded Results Snapshot, " + snapshotString + ", " + projectString + ", " + fileString;
    }

    private static String getCorruptedMessage(IOException e) {
        String message = e.getMessage();
        if (message == null) {
            if (e instanceof EOFException) {
                return MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_FILE_SHORT_MSG);
            }
            return SNAPSHOT_FILE_CORRUPTED;
        }
        return MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, message);
    }

    private boolean load(DataInputStream dis) throws IOException {
        try {
            byte[] settingsBytes;
            int readLen2;
            Properties props = new Properties();
            this.settings = new ProfilingSettings();
            byte[] magicArray = new byte[PROFILER_FILE_MAGIC_STRING.length()];
            int len = dis.read(magicArray);
            if (len != PROFILER_FILE_MAGIC_STRING.length() || !PROFILER_FILE_MAGIC_STRING.equals(new String(magicArray))) {
                throw new IOException(INVALID_SNAPSHOT_FILE_MSG);
            }
            byte majorVersion = dis.readByte();
            byte minorVersion = dis.readByte();
            if (majorVersion > 1) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, UNSUPPORTED_SNAPSHOT_VERSION_MSG));
            }
            int type = dis.readInt();
            if (type == -1) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, WRONG_SNAPSHOT_TYPE_MSG));
            }
            int compressedDataLen = dis.readInt();
            int uncompressedDataLen = dis.readInt();
            byte[] dataBytes = new byte[compressedDataLen];
            int readLen1 = dis.read(dataBytes, 0, compressedDataLen);
            if (compressedDataLen != readLen1) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, CANNOT_READ_SNAPSHOT_DATA_MSG));
            }
            int settingsLen = dis.readInt();
            if (settingsLen != (readLen2 = dis.read(settingsBytes = new byte[settingsLen]))) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, CANNOT_READ_SETTINGS_DATA_MSG));
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load version:" + majorVersion + "." + minorVersion);
                LOGGER.finest("load type:" + type);
                LOGGER.finest("load length of snapshot data:" + compressedDataLen);
                LOGGER.finest("uncompressed length of snapshot data:" + uncompressedDataLen);
                LOGGER.finest("load length of settings data:" + settingsLen);
            }
            switch (type) {
                case 1: {
                    this.snapshot = new CPUResultsSnapshot();
                    break;
                }
                case 2: {
                    this.snapshot = new CodeRegionResultsSnapshot();
                    break;
                }
                case 4: {
                    this.snapshot = new AllocMemoryResultsSnapshot();
                    break;
                }
                case 8: {
                    this.snapshot = new LivenessMemoryResultsSnapshot();
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, UNRECOGNIZED_SNAPSHOT_TYPE_MSG));
                }
            }
            Inflater d = new Inflater();
            d.setInput(dataBytes, 0, dataBytes.length);
            byte[] decompressedBytes = new byte[uncompressedDataLen];
            try {
                int decLen = d.inflate(decompressedBytes);
                if (decLen != uncompressedDataLen) {
                    throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_DATA_CORRUPTED_MSG));
                }
            }
            catch (DataFormatException e) {
                throw new IOException(MessageFormat.format(SNAPSHOT_FILE_CORRUPTED_REASON, SNAPSHOT_DATA_CORRUPTED_MSG));
            }
            d.end();
            ByteArrayInputStream bais = new ByteArrayInputStream(decompressedBytes);
            BufferedInputStream bufBais = new BufferedInputStream(bais);
            DataInputStream dataDis = new DataInputStream(bufBais);
            try {
                this.snapshot.readFromStream(dataDis);
            }
            catch (IOException e) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(e));
            }
            finally {
                dataDis.close();
            }
            ByteArrayInputStream bais2 = new ByteArrayInputStream(settingsBytes);
            BufferedInputStream bufBais2 = new BufferedInputStream(bais2);
            DataInputStream settingsDis = new DataInputStream(bufBais2);
            try {
                props.load(settingsDis);
            }
            catch (IOException e) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(e));
            }
            finally {
                settingsDis.close();
            }
            this.settings.load((Map)props);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load properties: --------------------------------------------------------------");
                LOGGER.finest(this.settings.debug());
                LOGGER.finest("-------------------------------------------------------------------------------");
            }
        }
        catch (OutOfMemoryError e) {
            NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_LOADING);
            return false;
        }
        return true;
    }

    static final class ThreadsSample {
        private final long time;
        private final ThreadInfo[] tinfos;

        ThreadsSample(long t, Collection<ThreadInfo> tis) {
            this.time = t;
            this.tinfos = tis.toArray(new ThreadInfo[tis.size()]);
        }

        long getTime() {
            return this.time;
        }

        ThreadInfo[] getTinfos() {
            return this.tinfos;
        }
    }

    static class SamplesInputStream {
        static final String ID = "NPSS";
        static final int MAX_SUPPORTED_VERSION = 2;
        int version;
        int samples;
        long lastTimestamp;
        ObjectInputStream in;
        Map<Long, ThreadInfo> threads;

        SamplesInputStream(File file) throws IOException {
            this(new FileInputStream(file));
        }

        SamplesInputStream(InputStream is) throws IOException {
            this.readHeader(is);
            this.in = new ObjectInputStream(new GZIPInputStream(is));
            if (this.version > 1) {
                this.samples = this.in.readInt();
                this.lastTimestamp = this.in.readLong();
            }
            this.threads = new HashMap<Long, ThreadInfo>(128);
        }

        int getSamples() {
            return this.samples;
        }

        long getLastTimestamp() {
            return this.lastTimestamp;
        }

        ThreadsSample readSample() throws IOException {
            int i;
            long time;
            try {
                time = this.in.readLong();
            }
            catch (EOFException ex) {
                return null;
            }
            HashMap<Long, ThreadInfo> newThreads = new HashMap<Long, ThreadInfo>(this.threads.size());
            int sameThreads = this.in.readInt();
            for (i = 0; i < sameThreads; ++i) {
                Long tid = this.in.readLong();
                ThreadInfo oldThread = this.threads.get(tid);
                assert (oldThread != null);
                newThreads.put(tid, oldThread);
            }
            ThreadInfo[] infos = new ThreadInfo[this.in.readInt()];
            for (i = 0; i < infos.length; ++i) {
                CompositeData infoData;
                try {
                    infoData = (CompositeData)this.in.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                ThreadInfo thread = ThreadInfo.from(infoData);
                newThreads.put(thread.getThreadId(), thread);
            }
            this.threads = newThreads;
            return new ThreadsSample(time, this.threads.values());
        }

        void close() throws IOException {
            this.in.close();
        }

        private void readHeader(InputStream is) throws IOException {
            byte[] idarr = new byte[ID.length()];
            is.read(idarr);
            String id = new String(idarr);
            if (!ID.equals(id)) {
                throw new IOException("Invalid header " + id);
            }
            this.version = is.read();
            if (this.version > 2) {
                throw new IOException("NPSS file version " + this.version + " is not supported");
            }
        }
    }
}

