/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public final class ResolvedPath {
    private final CharSequence folder;
    private final FileSystem fileSystem;
    private final CharSequence path;
    private final boolean isDefaultSearchPath;
    private final int index;

    public ResolvedPath(FileSystem fileSystem, CharSequence folder, CharSequence path, boolean isDefaultSearchPath, int index) {
        this.folder = folder;
        this.fileSystem = fileSystem;
        this.path = FilePathCache.getManager().getString(path);
        this.isDefaultSearchPath = isDefaultSearchPath;
        this.index = index;
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)folder);
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)path);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FileObject getFileObject() {
        return this.fileSystem.findResource(((Object)this.path).toString());
    }

    public CharSequence getPath() {
        return this.path;
    }

    public CharSequence getFolder() {
        return this.folder;
    }

    public boolean isDefaultSearchPath() {
        return this.isDefaultSearchPath;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.path + " in " + this.folder + " at " + this.fileSystem;
    }
}

