/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.FSPath;

public final class APTSystemStorage {
    private final Map<String, APTMacroMap> allMacroMaps = new HashMap<String, APTMacroMap>();
    private final APTIncludePathStorage includesStorage = new APTIncludePathStorage();
    private static final String baseNewName = "#SYSTEM MACRO MAP# ";
    private static final APTSystemStorage instance = new APTSystemStorage();

    private APTSystemStorage() {
    }

    public static synchronized APTSystemStorage getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTMacroMap getMacroMap(List<String> sysMacros) {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            APTSystemMacroMap map2 = new APTSystemMacroMap(sysMacros);
            for (APTMacroMap curMap : this.allMacroMaps.values()) {
                if (!map2.equals(curMap)) continue;
                return curMap;
            }
            this.allMacroMaps.put(baseNewName + this.allMacroMaps.size(), map2);
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTMacroMap getMacroMap(String configID, List<String> sysMacros) {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            APTMacroMap map2 = this.allMacroMaps.get(configID);
            if (map2 == null) {
                map2 = new APTSystemMacroMap(sysMacros);
                this.allMacroMaps.put(configID, map2);
                if (APTUtils.LOG.isLoggable(Level.FINE)) {
                    APTUtils.LOG.log(Level.FINE, "new system macro map was added\n {0}", new Object[]{map2});
                }
            }
            return map2;
        }
    }

    public List<IncludeDirEntry> getIncludes(CharSequence configID, List<FSPath> sysIncludes) {
        return this.includesStorage.get(configID, sysIncludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeImpl() {
        Map<String, APTMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            this.allMacroMaps.clear();
        }
        this.includesStorage.dispose();
    }

    public static void dispose() {
        instance.disposeImpl();
        APTMacroCache.getManager().dispose();
        IncludeDirEntry.disposeCache();
    }
}

